/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.impl.XML11EntityScanner;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.io.ASCIIReader;
import org.apache.xerces.impl.io.UCSReader;
import org.apache.xerces.impl.io.UTF8Reader;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLEntityManager
implements XMLComponent,
XMLEntityResolver {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    public static final int DEFAULT_INTERNAL_BUFFER_SIZE = 1024;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected static final String STANDARD_URI_CONFORMANT = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String BUFFER_SIZE = "http://apache.org/xml/properties/input-buffer-size";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/warn-on-duplicate-entitydef", "http://apache.org/xml/features/standard-uri-conformant"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/input-buffer-size", "http://apache.org/xml/properties/security-manager"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null, new Integer(2048), null};
    private static final String XMLEntity = "[xml]".intern();
    private static final String DTDEntity = "[dtd]".intern();
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_ENTITIES = false;
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_RESOLVER = false;
    protected boolean fValidation;
    protected boolean fExternalGeneralEntities;
    protected boolean fExternalParameterEntities;
    protected boolean fAllowJavaEncodings;
    protected boolean fWarnDuplicateEntityDef;
    protected boolean fStrictURI;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager;
    protected int fBufferSize = 2048;
    protected SecurityManager fSecurityManager = null;
    protected boolean fStandalone;
    protected boolean fInExternalSubset = false;
    protected XMLEntityHandler fEntityHandler;
    protected XMLEntityScanner fEntityScanner;
    protected XMLEntityScanner fXML10EntityScanner;
    protected XMLEntityScanner fXML11EntityScanner;
    protected int fEntityExpansionLimit = 0;
    protected int fEntityExpansionCount = 0;
    protected Hashtable fEntities = new Hashtable();
    protected Stack fEntityStack = new Stack();
    protected ScannedEntity fCurrentEntity;
    protected Hashtable fDeclaredEntities;
    private final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    protected Vector fOwnReaders = new Vector();
    private static String gUserDir;
    private static String gEscapedUserDir;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    public XMLEntityManager() {
        this(null);
    }

    public XMLEntityManager(XMLEntityManager xMLEntityManager) {
        this.fDeclaredEntities = xMLEntityManager != null ? xMLEntityManager.getDeclaredEntities() : null;
        this.setScannerVersion((short)1);
    }

    public void setStandalone(boolean bl) {
        this.fStandalone = bl;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public void setEntityHandler(XMLEntityHandler xMLEntityHandler) {
        this.fEntityHandler = xMLEntityHandler;
    }

    public XMLResourceIdentifier getCurrentResourceIdentifier() {
        return this.fResourceIdentifier;
    }

    public ScannedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    public void addInternalEntity(String string, String string2) {
        if (!this.fEntities.containsKey(string)) {
            InternalEntity internalEntity = new InternalEntity(string, string2, this.fInExternalSubset);
            this.fEntities.put(string, internalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public void addExternalEntity(String string, String string2, String string3, String string4) throws IOException {
        if (!this.fEntities.containsKey(string)) {
            if (string4 == null) {
                int n = this.fEntityStack.size();
                if (n == 0 && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                    string4 = this.fCurrentEntity.entityLocation.getExpandedSystemId();
                }
                for (int i = n - 1; i >= 0; --i) {
                    ScannedEntity scannedEntity = (ScannedEntity)this.fEntityStack.elementAt(i);
                    if (scannedEntity.entityLocation == null || scannedEntity.entityLocation.getExpandedSystemId() == null) continue;
                    string4 = scannedEntity.entityLocation.getExpandedSystemId();
                    break;
                }
            }
            ExternalEntity externalEntity = new ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, XMLEntityManager.expandSystemId(string3, string4, false)), null, this.fInExternalSubset);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public boolean isExternalEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public boolean isEntityDeclInExternalSubset(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isEntityDeclInExternalSubset();
    }

    public void addUnparsedEntity(String string, String string2, String string3, String string4, String string5) {
        if (!this.fEntities.containsKey(string)) {
            ExternalEntity externalEntity = new ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, null), string5, this.fInExternalSubset);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public boolean isUnparsedEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        return entity != null;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws IOException, XNIException {
        boolean bl;
        if (xMLResourceIdentifier == null) {
            return null;
        }
        String string = xMLResourceIdentifier.getPublicId();
        String string2 = xMLResourceIdentifier.getLiteralSystemId();
        String string3 = xMLResourceIdentifier.getBaseSystemId();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        boolean bl2 = bl = string4 == null;
        if (string3 == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null && (string3 = this.fCurrentEntity.entityLocation.getExpandedSystemId()) != null) {
            bl = true;
        }
        if (bl) {
            string4 = XMLEntityManager.expandSystemId(string2, string3, false);
        }
        XMLInputSource xMLInputSource = null;
        if (this.fEntityResolver != null) {
            xMLResourceIdentifier.setBaseSystemId(string3);
            xMLResourceIdentifier.setExpandedSystemId(string4);
            xMLInputSource = this.fEntityResolver.resolveEntity(xMLResourceIdentifier);
        }
        if (xMLInputSource == null) {
            xMLInputSource = new XMLInputSource(string, string2, string3);
        }
        return xMLInputSource;
    }

    public void startEntity(String string, boolean bl) throws IOException, XNIException {
        int n;
        int n2;
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            if (this.fEntityHandler != null) {
                String string2 = null;
                this.fResourceIdentifier.clear();
                this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string2);
                this.fEntityHandler.endEntity(string);
            }
            return;
        }
        boolean bl2 = entity.isExternal();
        if (bl2 && (this.fValidationManager == null || !this.fValidationManager.isCachedDTD())) {
            boolean bl3;
            n2 = entity.isUnparsed() ? 1 : 0;
            n = string.startsWith("%") ? 1 : 0;
            boolean bl4 = bl3 = n == 0;
            if (n2 != 0 || bl3 && !this.fExternalGeneralEntities || n != 0 && !this.fExternalParameterEntities) {
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String string3 = null;
                    ExternalEntity externalEntity = (ExternalEntity)entity;
                    String string4 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String string5 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String string6 = XMLEntityManager.expandSystemId(string4, string5, false);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, string4, string5, string6);
                    this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string3);
                    this.fEntityHandler.endEntity(string);
                }
                return;
            }
        }
        for (n = n2 = this.fEntityStack.size(); n >= 0; --n) {
            Entity entity2;
            Entity entity3 = entity2 = n == n2 ? this.fCurrentEntity : (Entity)this.fEntityStack.elementAt(n);
            if (entity2.name != string) continue;
            String string7 = string;
            for (int i = n + 1; i < n2; ++i) {
                entity2 = (Entity)this.fEntityStack.elementAt(i);
                string7 = string7 + " -> " + entity2.name;
            }
            string7 = string7 + " -> " + this.fCurrentEntity.name;
            string7 = string7 + " -> " + string;
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RecursiveReference", new Object[]{string, string7}, (short)2);
            if (this.fEntityHandler != null) {
                this.fResourceIdentifier.clear();
                String string8 = null;
                if (bl2) {
                    ExternalEntity externalEntity = (ExternalEntity)entity;
                    String string9 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String string10 = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String string11 = XMLEntityManager.expandSystemId(string9, string10, false);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, string9, string10, string11);
                }
                this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string8);
                this.fEntityHandler.endEntity(string);
            }
            return;
        }
        XMLInputSource xMLInputSource = null;
        if (bl2) {
            ExternalEntity externalEntity = (ExternalEntity)entity;
            xMLInputSource = this.resolveEntity(externalEntity.entityLocation);
        } else {
            InternalEntity internalEntity = (InternalEntity)entity;
            StringReader stringReader = new StringReader(internalEntity.text);
            xMLInputSource = new XMLInputSource(null, null, null, stringReader, null);
        }
        this.startEntity(string, xMLInputSource, bl, bl2);
    }

    public void startDocumentEntity(XMLInputSource xMLInputSource) throws IOException, XNIException {
        this.startEntity(XMLEntity, xMLInputSource, false, true);
    }

    public void startDTDEntity(XMLInputSource xMLInputSource) throws IOException, XNIException {
        this.startEntity(DTDEntity, xMLInputSource, false, true);
    }

    public void startExternalSubset() {
        this.fInExternalSubset = true;
    }

    public void endExternalSubset() {
        this.fInExternalSubset = false;
    }

    public void startEntity(String string, XMLInputSource xMLInputSource, boolean bl, boolean bl2) throws IOException, XNIException {
        String string2 = this.setupCurrentEntity(string, xMLInputSource, bl, bl2);
        if (this.fSecurityManager != null && this.fEntityExpansionCount++ > this.fEntityExpansionLimit) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityExpansionLimitExceeded", new Object[]{new Integer(this.fEntityExpansionLimit)}, (short)2);
            this.fEntityExpansionCount = 0;
        }
        if (this.fEntityHandler != null) {
            this.fEntityHandler.startEntity(string, this.fResourceIdentifier, string2);
        }
    }

    public String setupCurrentEntity(String string, XMLInputSource xMLInputSource, boolean bl, boolean bl2) throws IOException, XNIException {
        String string2 = xMLInputSource.getPublicId();
        String string3 = xMLInputSource.getSystemId();
        String string4 = xMLInputSource.getBaseSystemId();
        String string5 = xMLInputSource.getEncoding();
        Boolean bl3 = null;
        InputStream inputStream = null;
        Reader reader = xMLInputSource.getCharacterStream();
        String string6 = XMLEntityManager.expandSystemId(string3, string4, this.fStrictURI);
        if (string4 == null) {
            string4 = string6;
        }
        if (reader == null) {
            inputStream = xMLInputSource.getByteStream();
            if (inputStream == null) {
                inputStream = new URL(string6).openStream();
            }
            inputStream = new RewindableInputStream(inputStream);
            if (string5 == null) {
                int n;
                byte[] byArray = new byte[4];
                for (n = 0; n < 4; ++n) {
                    byArray[n] = (byte)inputStream.read();
                }
                if (n == 4) {
                    Object[] objectArray = this.getEncodingName(byArray, n);
                    string5 = (String)objectArray[0];
                    bl3 = (Boolean)objectArray[1];
                    inputStream.reset();
                    boolean bl4 = false;
                    if (n > 2 && string5.equals("UTF-8")) {
                        int n2 = byArray[0] & 0xFF;
                        int n3 = byArray[1] & 0xFF;
                        int n4 = byArray[2] & 0xFF;
                        if (n2 == 239 && n3 == 187 && n4 == 191) {
                            inputStream.skip(3L);
                        }
                    }
                    reader = this.createReader(inputStream, string5, bl3);
                } else {
                    reader = this.createReader(inputStream, string5, bl3);
                }
            } else {
                if ((string5 = string5.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
                    int n;
                    int[] nArray = new int[3];
                    for (n = 0; n < 3; ++n) {
                        nArray[n] = inputStream.read();
                        if (nArray[n] == -1) break;
                    }
                    if (n == 3) {
                        if (nArray[0] != 239 || nArray[1] != 187 || nArray[2] != 191) {
                            inputStream.reset();
                        }
                    } else {
                        inputStream.reset();
                    }
                } else if (string5.equals("ISO-10646-UCS-4")) {
                    int n;
                    int[] nArray = new int[4];
                    for (n = 0; n < 4; ++n) {
                        nArray[n] = inputStream.read();
                        if (nArray[n] == -1) break;
                    }
                    inputStream.reset();
                    if (n == 4) {
                        if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 60) {
                            bl3 = Boolean.TRUE;
                        } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0) {
                            bl3 = Boolean.FALSE;
                        }
                    }
                } else if (string5.equals("ISO-10646-UCS-2")) {
                    int n;
                    int[] nArray = new int[4];
                    for (n = 0; n < 4; ++n) {
                        nArray[n] = inputStream.read();
                        if (nArray[n] == -1) break;
                    }
                    inputStream.reset();
                    if (n == 4) {
                        if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 63) {
                            bl3 = Boolean.TRUE;
                        } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 63 && nArray[3] == 0) {
                            bl3 = Boolean.FALSE;
                        }
                    }
                }
                reader = this.createReader(inputStream, string5, bl3);
            }
        }
        this.fOwnReaders.addElement(reader);
        if (this.fCurrentEntity != null) {
            this.fEntityStack.push(this.fCurrentEntity);
        }
        this.fCurrentEntity = new ScannedEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, string6), inputStream, reader, string5, bl, false, bl2);
        this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        this.fResourceIdentifier.setValues(string2, string3, string4, string6);
        return string5;
    }

    public void setScannerVersion(short s) {
        if (s == 1) {
            if (this.fXML10EntityScanner == null) {
                this.fXML10EntityScanner = new XMLEntityScanner();
                this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            }
            this.fEntityScanner = this.fXML10EntityScanner;
            this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        } else {
            if (this.fXML11EntityScanner == null) {
                this.fXML11EntityScanner = new XML11EntityScanner();
                this.fXML11EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            }
            this.fEntityScanner = this.fXML11EntityScanner;
            this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        }
    }

    public XMLEntityScanner getEntityScanner() {
        if (this.fEntityScanner == null) {
            if (this.fXML10EntityScanner == null) {
                this.fXML10EntityScanner = new XMLEntityScanner();
            }
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML10EntityScanner;
        }
        return this.fEntityScanner;
    }

    public void closeReaders() {
        for (int i = this.fOwnReaders.size() - 1; i >= 0; --i) {
            try {
                ((Reader)this.fOwnReaders.elementAt(i)).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fOwnReaders.removeAllElements();
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fExternalGeneralEntities = xMLComponentManager.getFeature(EXTERNAL_GENERAL_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalGeneralEntities = true;
        }
        try {
            this.fExternalParameterEntities = xMLComponentManager.getFeature(EXTERNAL_PARAMETER_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalParameterEntities = true;
        }
        try {
            this.fAllowJavaEncodings = xMLComponentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fAllowJavaEncodings = false;
        }
        try {
            this.fWarnDuplicateEntityDef = xMLComponentManager.getFeature(WARN_ON_DUPLICATE_ENTITYDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateEntityDef = false;
        }
        try {
            this.fStrictURI = xMLComponentManager.getFeature(STANDARD_URI_CONFORMANT);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fStrictURI = false;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        try {
            this.fValidationManager = (ValidationManager)xMLComponentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidationManager = null;
        }
        try {
            this.fSecurityManager = (SecurityManager)xMLComponentManager.getProperty(SECURITY_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSecurityManager = null;
        }
        this.reset();
    }

    public void reset() {
        this.fEntityExpansionLimit = this.fSecurityManager != null ? this.fSecurityManager.getEntityExpansionLimit() : 0;
        this.fStandalone = false;
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fEntityExpansionCount = 0;
        this.fCurrentEntity = null;
        if (this.fXML10EntityScanner != null) {
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
        }
        if (this.fXML11EntityScanner != null) {
            this.fXML11EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
        }
        if (this.fDeclaredEntities != null) {
            Enumeration enumeration = this.fDeclaredEntities.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = this.fDeclaredEntities.get(k);
                this.fEntities.put(k, v);
            }
        }
        this.fEntityHandler = null;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        String string2;
        if (string.startsWith("http://apache.org/xml/features/") && (string2 = string.substring("http://apache.org/xml/features/".length())).equals("allow-java-encodings")) {
            this.fAllowJavaEncodings = bl;
        }
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            Integer n;
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
                return;
            }
            if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
                return;
            }
            if (string2.equals("internal/entity-resolver")) {
                this.fEntityResolver = (XMLEntityResolver)object;
                return;
            }
            if (string2.equals("input-buffer-size") && (n = (Integer)object) != null && n > 64) {
                this.fBufferSize = n;
                this.fEntityScanner.setBufferSize(this.fBufferSize);
            }
            if (string2.equals("security-manager")) {
                this.fSecurityManager = (SecurityManager)object;
                this.fEntityExpansionLimit = this.fSecurityManager != null ? this.fSecurityManager.getEntityExpansionLimit() : 0;
            }
        }
    }

    public Boolean getFeatureDefault(String string) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(string)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(string)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return null;
    }

    private static synchronized String getUserDir() {
        int n;
        int n2;
        String string = "";
        try {
            string = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.equals(gUserDir)) {
            return gEscapedUserDir;
        }
        gUserDir = string;
        char c = File.separatorChar;
        string = string.replace(c, '/');
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 * 3);
        if (n3 >= 2 && string.charAt(1) == ':' && (n2 = Character.toUpperCase(string.charAt(0))) >= 65 && n2 <= 90) {
            stringBuffer.append('/');
        }
        for (n = 0; n < n3 && (n2 = string.charAt(n)) < 128; ++n) {
            if (gNeedEscaping[n2]) {
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[n2]);
                stringBuffer.append(gAfterEscaping2[n2]);
                continue;
            }
            stringBuffer.append((char)n2);
        }
        if (n < n3) {
            byte[] byArray = null;
            try {
                byArray = string.substring(n).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            n3 = byArray.length;
            for (n = 0; n < n3; ++n) {
                byte by = byArray[n];
                if (by < 0) {
                    n2 = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n2 >> 4]);
                    stringBuffer.append(gHexChs[n2 & 0xF]);
                    continue;
                }
                if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                    continue;
                }
                stringBuffer.append((char)by);
            }
        }
        if (!string.endsWith("/")) {
            stringBuffer.append('/');
        }
        gEscapedUserDir = stringBuffer.toString();
        return gEscapedUserDir;
    }

    public static String expandSystemId(String string, String string2, boolean bl) throws URI.MalformedURIException {
        Object object;
        if (bl) {
            try {
                URI uRI = new URI(string);
                return string;
            }
            catch (URI.MalformedURIException malformedURIException) {
                URI uRI = null;
                if (string2 == null || string2.length() == 0) {
                    uRI = new URI("file", "", XMLEntityManager.getUserDir(), null, null);
                } else {
                    try {
                        uRI = new URI(string2);
                    }
                    catch (URI.MalformedURIException malformedURIException2) {
                        String string3 = XMLEntityManager.getUserDir();
                        string3 = string3 + string2;
                        uRI = new URI("file", "", string3, null, null);
                    }
                }
                URI uRI2 = new URI(uRI, string);
                return uRI2.toString();
            }
        }
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = XMLEntityManager.fixURI(string);
        URI uRI = null;
        URI uRI3 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string4 = XMLEntityManager.getUserDir();
                uRI = new URI("file", "", string4, null, null);
            } else {
                try {
                    uRI = new URI(XMLEntityManager.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", XMLEntityManager.fixURI(string2), null, null);
                    }
                    String string5 = XMLEntityManager.getUserDir();
                    string5 = string5 + XMLEntityManager.fixURI(string2);
                    uRI = new URI("file", "", string5, null, null);
                }
            }
            uRI3 = new URI(uRI, (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRI3 == null) {
            return string;
        }
        return uRI3.toString();
    }

    void endEntity() throws XNIException {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.endEntity(this.fCurrentEntity.name);
        }
        this.fCurrentEntity = this.fEntityStack.size() > 0 ? (ScannedEntity)this.fEntityStack.pop() : null;
        this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
    }

    protected Object[] getEncodingName(byte[] byArray, int n) {
        if (n < 2) {
            return new Object[]{"UTF-8", null};
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 255 && n3 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n < 3) {
            return new Object[]{"UTF-8", null};
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new Object[]{"UTF-8", null};
        }
        if (n < 4) {
            return new Object[]{"UTF-8", null};
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new Object[]{"CP037", null};
        }
        return new Object[]{"UTF-8", null};
    }

    protected Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException {
        String string2;
        String string3;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string3 = string.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string3.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string3.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        if (string3.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
            string = "ISO-8859-1";
        }
        if ((string2 = EncodingMap.getIANA2JavaMapping(string3)) == null) {
            if (this.fAllowJavaEncodings) {
                string2 = string;
            } else {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
                string2 = "ISO8859_1";
            }
        }
        return new InputStreamReader(inputStream, string2);
    }

    protected static String fixURI(String string) {
        int n;
        int n2;
        string = string.replace(File.separatorChar, '/');
        StringBuffer stringBuffer = null;
        if (string.length() >= 2) {
            n2 = string.charAt(1);
            if (n2 == 58) {
                n = Character.toUpperCase(string.charAt(0));
                if (n >= 65 && n <= 90) {
                    stringBuffer = new StringBuffer(string.length());
                    stringBuffer.append('/');
                }
            } else if (n2 == 47 && string.charAt(0) == '/') {
                stringBuffer = new StringBuffer(string.length());
                stringBuffer.append("file:");
            }
        }
        if ((n2 = string.indexOf(32)) < 0) {
            if (stringBuffer != null) {
                stringBuffer.append(string);
                string = stringBuffer.toString();
            }
        } else {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.length());
            }
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(string.charAt(n));
            }
            stringBuffer.append("%20");
            for (n = n2 + 1; n < string.length(); ++n) {
                if (string.charAt(n) == ' ') {
                    stringBuffer.append("%20");
                    continue;
                }
                stringBuffer.append(string.charAt(n));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    static final void print(ScannedEntity scannedEntity) {
    }

    static {
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            XMLEntityManager.gNeedEscaping[i] = true;
            XMLEntityManager.gAfterEscaping1[i] = gHexChs[i >> 4];
            XMLEntityManager.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        XMLEntityManager.gNeedEscaping[127] = true;
        XMLEntityManager.gAfterEscaping1[127] = 55;
        XMLEntityManager.gAfterEscaping2[127] = 70;
        char[] cArray = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            XMLEntityManager.gNeedEscaping[c] = true;
            XMLEntityManager.gAfterEscaping1[c] = gHexChs[c >> 4];
            XMLEntityManager.gAfterEscaping2[c] = gHexChs[c & 0xF];
        }
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream inputStream) {
            this.fInputStream = inputStream;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int n) {
            this.fStartOffset = n;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int read() throws IOException {
            int n = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] byArray = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
                this.fData = byArray;
            }
            if ((n = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)n;
            ++this.fOffset;
            return n & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.fLength - this.fOffset;
            if (n3 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                if (XMLEntityManager.this.fCurrentEntity.mayReadChunks) {
                    return this.fInputStream.read(byArray, n, n2);
                }
                int n4 = this.read();
                if (n4 == -1) {
                    this.fEndOffset = this.fOffset;
                    return -1;
                }
                byArray[n] = (byte)n4;
                return 1;
            }
            if (n2 < n3) {
                if (n2 <= 0) {
                    return 0;
                }
            } else {
                n2 = n3;
            }
            if (byArray != null) {
                System.arraycopy(this.fData, this.fOffset, byArray, n, n2);
            }
            this.fOffset += n2;
            return n2;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(l);
            }
            if (l <= (long)n) {
                this.fOffset = (int)((long)this.fOffset + l);
                return l;
            }
            this.fOffset += n;
            if (this.fOffset == this.fEndOffset) {
                return n;
            }
            return this.fInputStream.skip(l -= (long)n) + (long)n;
        }

        public int available() throws IOException {
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return XMLEntityManager.this.fCurrentEntity.mayReadChunks ? this.fInputStream.available() : 0;
            }
            return n;
        }

        public void mark(int n) {
            this.fMark = this.fOffset;
        }

        public void reset() {
            this.fOffset = this.fMark;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }

    public class ScannedEntity
    extends Entity {
        public InputStream stream;
        public Reader reader;
        public XMLResourceIdentifier entityLocation;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public String encoding;
        public boolean literal;
        public boolean isExternal;
        public char[] ch = null;
        public int position;
        public int count;
        public boolean mayReadChunks;

        public ScannedEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, InputStream inputStream, Reader reader, String string2, boolean bl, boolean bl2, boolean bl3) {
            super(string, XMLEntityManager.this.fInExternalSubset);
            this.entityLocation = xMLResourceIdentifier;
            this.stream = inputStream;
            this.reader = reader;
            this.encoding = string2;
            this.literal = bl;
            this.mayReadChunks = bl2;
            this.isExternal = bl3;
            this.ch = new char[bl3 ? XMLEntityManager.this.fBufferSize : 1024];
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void setReader(InputStream inputStream, String string, Boolean bl) throws IOException {
            this.reader = XMLEntityManager.this.createReader(inputStream, string, bl);
        }

        public String getExpandedSystemId() {
            int n = XMLEntityManager.this.fEntityStack.size();
            for (int i = n - 1; i >= 0; --i) {
                ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (scannedEntity.entityLocation == null || scannedEntity.entityLocation.getExpandedSystemId() == null) continue;
                return scannedEntity.entityLocation.getExpandedSystemId();
            }
            return null;
        }

        public String getLiteralSystemId() {
            int n = XMLEntityManager.this.fEntityStack.size();
            for (int i = n - 1; i >= 0; --i) {
                ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (scannedEntity.entityLocation == null || scannedEntity.entityLocation.getLiteralSystemId() == null) continue;
                return scannedEntity.entityLocation.getLiteralSystemId();
            }
            return null;
        }

        public int getLineNumber() {
            int n = XMLEntityManager.this.fEntityStack.size();
            for (int i = n - 1; i > 0; --i) {
                ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (!scannedEntity.isExternal()) continue;
                return scannedEntity.lineNumber;
            }
            return -1;
        }

        public int getColumnNumber() {
            int n = XMLEntityManager.this.fEntityStack.size();
            for (int i = n - 1; i > 0; --i) {
                ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (!scannedEntity.isExternal()) continue;
                return scannedEntity.columnNumber;
            }
            return -1;
        }

        public String getEncoding() {
            int n = XMLEntityManager.this.fEntityStack.size();
            for (int i = n - 1; i > 0; --i) {
                ScannedEntity scannedEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (!scannedEntity.isExternal()) continue;
                return scannedEntity.encoding;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("name=\"" + this.name + '\"');
            stringBuffer.append(",ch=" + this.ch);
            stringBuffer.append(",position=" + this.position);
            stringBuffer.append(",count=" + this.count);
            return stringBuffer.toString();
        }
    }

    protected static class ExternalEntity
    extends Entity {
        public XMLResourceIdentifier entityLocation;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, boolean bl) {
            super(string, bl);
            this.entityLocation = xMLResourceIdentifier;
            this.notation = string2;
        }

        public final boolean isExternal() {
            return true;
        }

        public final boolean isUnparsed() {
            return this.notation != null;
        }

        public void clear() {
            super.clear();
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(ExternalEntity externalEntity) {
            super.setValues(externalEntity);
            this.entityLocation = externalEntity.entityLocation;
            this.notation = externalEntity.notation;
        }
    }

    protected static class InternalEntity
    extends Entity {
        public String text;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String string, String string2, boolean bl) {
            super(string, bl);
            this.text = string2;
        }

        public final boolean isExternal() {
            return false;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void clear() {
            super.clear();
            this.text = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.text = null;
        }

        public void setValues(InternalEntity internalEntity) {
            super.setValues(internalEntity);
            this.text = internalEntity.text;
        }
    }

    public static abstract class Entity {
        public String name;
        public boolean inExternalSubset;

        public Entity() {
            this.clear();
        }

        public Entity(String string, boolean bl) {
            this.name = string;
            this.inExternalSubset = bl;
        }

        public boolean isEntityDeclInExternalSubset() {
            return this.inExternalSubset;
        }

        public abstract boolean isExternal();

        public abstract boolean isUnparsed();

        public void clear() {
            this.name = null;
            this.inExternalSubset = false;
        }

        public void setValues(Entity entity) {
            this.name = entity.name;
            this.inExternalSubset = entity.inExternalSubset;
        }
    }
}

