/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.opti;

import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.DefaultDocument;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    ElementImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;

    public SchemaDOM() {
        this.reset();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n, int n2) throws XNIException {
        ElementImpl elementImpl = new ElementImpl(n, n2);
        this.processElement(qName, xMLAttributes, augmentations, elementImpl);
        this.parent = elementImpl;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n, int n2) throws XNIException {
        ElementImpl elementImpl = new ElementImpl(n, n2);
        this.processElement(qName, xMLAttributes, augmentations, elementImpl);
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, ElementImpl elementImpl) throws XNIException {
        int n;
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        for (n = 0; n < xMLAttributes.getLength(); ++n) {
            attrArray[n] = new AttrImpl(null, xMLAttributes.getPrefix(n), xMLAttributes.getLocalName(n), xMLAttributes.getQName(n), xMLAttributes.getURI(n), xMLAttributes.getValue(n));
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        n = 0;
        int n2 = 1;
        for (n2 = 1; n2 < this.relations[this.currLoc].length; ++n2) {
            if (this.relations[this.currLoc][n2] != null) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n2] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n2;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.currLoc = this.parent.row;
        this.parent = this.relations[this.currLoc][0];
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    private void resizeRelations() {
        ElementImpl[][] elementImplArrayArray = new ElementImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, elementImplArrayArray, 0, this.relations.length);
        for (int i = this.relations.length; i < elementImplArrayArray.length; ++i) {
            elementImplArrayArray[i] = new ElementImpl[10];
        }
        this.relations = elementImplArrayArray;
    }

    private void resizeRelations(int n) {
        ElementImpl[] elementImplArray = new ElementImpl[this.relations[n].length + 10];
        System.arraycopy(this.relations[n], 0, elementImplArray, 0, this.relations[n].length);
        this.relations[n] = elementImplArray;
    }

    public void reset() {
        this.relations = new ElementImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        for (int i = 0; i < 15; ++i) {
            this.relations[i] = new ElementImpl[10];
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int n) {
        Object object;
        SchemaDOM.indent(n);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                System.out.print("  " + ((Attr)object.item(i)).getName() + "=\"" + ((Attr)object.item(i)).getValue() + "\"");
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n += 4;
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                SchemaDOM.traverse((Node)object, n);
            }
            SchemaDOM.indent(n -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }

    public Element getDocumentElement() {
        return this.relations[0][1];
    }
}

