/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xml.dtm.SecuritySupport;

class FactoryFinder {
    private static boolean debug;
    private static String foundFactory;
    static /* synthetic */ Class class$org$apache$xml$dtm$FactoryFinder;

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader cl = (class$org$apache$xml$dtm$FactoryFinder == null ? (class$org$apache$xml$dtm$FactoryFinder = FactoryFinder.class$("org.apache.xml.dtm.FactoryFinder")) : class$org$apache$xml$dtm$FactoryFinder).getClassLoader();
        FactoryFinder.dPrint("find factoryId=" + factoryId);
        try {
            String systemProp = ss.getSystemProperty(factoryId);
            if (systemProp != null) {
                FactoryFinder.dPrint("found system property, value=" + systemProp);
                return FactoryFinder.newInstance(systemProp, cl, true);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        Class clazz = class$org$apache$xml$dtm$FactoryFinder == null ? (class$org$apache$xml$dtm$FactoryFinder = FactoryFinder.class$("org.apache.xml.dtm.FactoryFinder")) : class$org$apache$xml$dtm$FactoryFinder;
        synchronized (clazz) {
            if (foundFactory == null) {
                Properties xalanProperties = null;
                try {
                    String javah = ss.getSystemProperty("java.home");
                    String configFile = javah + File.separator + "lib" + File.separator + "xalan.properties";
                    File f = new File(configFile);
                    FileInputStream fis = ss.getFileInputStream(f);
                    xalanProperties = new Properties();
                    xalanProperties.load(fis);
                    fis.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (xalanProperties != null) {
                    foundFactory = xalanProperties.getProperty(factoryId);
                    if (foundFactory != null) {
                        FactoryFinder.dPrint("found in xalan.properties, value=" + foundFactory);
                    }
                } else {
                    FactoryFinder.findJarServiceProvider(factoryId);
                    if (foundFactory == null) {
                        if (fallbackClassName == null) {
                            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
                        }
                        FactoryFinder.dPrint("using fallback, value=" + fallbackClassName);
                        foundFactory = fallbackClassName;
                    }
                }
            }
        }
        return FactoryFinder.newInstance(foundFactory, cl, true);
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    private static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class<?> providerClass;
            if (cl == null) {
                providerClass = Class.forName(className);
            } else {
                try {
                    providerClass = cl.loadClass(className);
                }
                catch (ClassNotFoundException x) {
                    if (doFallback) {
                        cl = (class$org$apache$xml$dtm$FactoryFinder == null ? (class$org$apache$xml$dtm$FactoryFinder = FactoryFinder.class$("org.apache.xml.dtm.FactoryFinder")) : class$org$apache$xml$dtm$FactoryFinder).getClassLoader();
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
            }
            Object instance = providerClass.newInstance();
            FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    private static String findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        SecuritySupport ss = SecuritySupport.getInstance();
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = (class$org$apache$xml$dtm$FactoryFinder == null ? (class$org$apache$xml$dtm$FactoryFinder = FactoryFinder.class$("org.apache.xml.dtm.FactoryFinder")) : class$org$apache$xml$dtm$FactoryFinder).getClassLoader();
        is = ss.getResourceAsStream(cl, serviceId);
        if (is == null) {
            return null;
        }
        FactoryFinder.dPrint("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            FactoryFinder.dPrint("found in resource, value=" + factoryClassName);
            return factoryClassName;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        foundFactory = null;
        try {
            String val = SecuritySupport.getInstance().getSystemProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (SecurityException se) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

