/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.DocumentEvent;
import butterfly.xmlview.model.DocumentSourceEvent;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.IDocumentSourceEvent;
import butterfly.xmlview.model.interfaces.IDocumentSourceListener;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IMarkerListener;
import butterfly.xmlview.model.interfaces.IMultiNode;
import butterfly.xmlview.model.interfaces.INode;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractDocument
implements IDocument {
    public static final String DESCRIPTION_PROPERTY_KEY = "document-description";
    private String contentType_;
    private String sourceFileName_;
    private Vector markerListeners_;
    private boolean isDirty_ = false;
    protected Properties properties_;
    private String name_;
    private boolean locked_;
    private DocumentListenerManager documentListeners_ = new DocumentListenerManager();
    private DocumentSourceListenerManager documentSourceListeners_ = new DocumentSourceListenerManager();
    private Vector eventQueue_;
    private boolean queueEvents_ = false;
    private boolean valid_ = true;
    private boolean exists_ = true;

    public AbstractDocument(String string) {
        this.contentType_ = string;
        this.properties_ = new Properties();
    }

    public void addDocumentListener(IDocumentListener iDocumentListener) {
        this.documentListeners_.addListener(iDocumentListener);
    }

    public void setSource(String string) {
    }

    public void addDocumentSourceListener(IDocumentSourceListener iDocumentSourceListener) {
        this.documentSourceListeners_.addListener(iDocumentSourceListener);
    }

    public void insertString(int n, String string) {
        DocumentSourceEvent documentSourceEvent = new DocumentSourceEvent(this, n, 0, string);
        this.fireDocumentSourceEvent(documentSourceEvent);
    }

    public void removeString(int n, int n2) {
        DocumentSourceEvent documentSourceEvent = new DocumentSourceEvent(this, n, n2, null);
        this.fireDocumentSourceEvent(documentSourceEvent);
    }

    protected void fireDocumentEvent(IDocumentEvent iDocumentEvent) {
        if (this.queueEvents_) {
            this.eventQueue_.add(iDocumentEvent);
        } else {
            this.documentListeners_.fireEvent(iDocumentEvent);
        }
    }

    protected void fireDocumentSourceEvent(IDocumentSourceEvent iDocumentSourceEvent) {
        if (this.queueEvents_) {
            this.eventQueue_.add(iDocumentSourceEvent);
        } else {
            this.documentSourceListeners_.fireEvent(iDocumentSourceEvent);
        }
    }

    protected void queueEvents() {
        this.queueEvents_ = true;
        if (this.eventQueue_ == null) {
            this.eventQueue_ = new Vector();
        } else {
            this.eventQueue_.clear();
        }
    }

    protected void unQueueEvents() {
        this.queueEvents_ = false;
        int n = 0;
        while (n < this.eventQueue_.size()) {
            if (this.eventQueue_.elementAt(n) instanceof IDocumentSourceEvent) {
                this.fireDocumentSourceEvent((IDocumentSourceEvent)this.eventQueue_.elementAt(n));
            } else {
                this.fireDocumentEvent((IDocumentEvent)this.eventQueue_.elementAt(n));
            }
            ++n;
        }
        this.eventQueue_.clear();
    }

    protected INode getChild(INode iNode, String string) {
        if (iNode == null) {
            return null;
        }
        if (iNode instanceof IMultiNode) {
            int n = this.getPathIndex(string);
            return ((IMultiNode)iNode).childAt(n);
        }
        return null;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public String getDescription() {
        return this.getProperty(DESCRIPTION_PROPERTY_KEY);
    }

    public String getName() {
        return this.name_;
    }

    public INode getNode(INode iNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        while (stringTokenizer.hasMoreTokens()) {
            if (string.equals("..")) {
                iNode = iNode.getParent();
                continue;
            }
            if (string.equals(".")) continue;
            iNode = this.getChild(iNode, stringTokenizer.nextToken());
        }
        return iNode;
    }

    public INode getNode(String string) {
        return this.getNode(this.getRoot(), string);
    }

    public String getPath(INode iNode) {
        INode iNode2 = iNode.getParent();
        String string = "/";
        while (iNode2 != null) {
            string = iNode2 instanceof IMultiNode ? String.valueOf(string) + iNode.getClass().getName() + "[" + ((IMultiNode)iNode2).indexOfChild(iNode) + "]/" : String.valueOf(string) + iNode.getClass().getName() + "/";
            iNode = iNode2;
            iNode2 = iNode2.getParent();
        }
        return string;
    }

    protected int getPathIndex(String string) {
        int n;
        int n2;
        if (string.indexOf("[") > -1 && (n2 = string.indexOf("]", n = string.indexOf("["))) > n) {
            int n3 = 0;
            String string2 = string.substring(n + 1, n2);
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
            return n3;
        }
        return 0;
    }

    public String getProperty(String string) {
        return this.properties_.getProperty(string);
    }

    public String getSourceFileName() {
        return this.sourceFileName_;
    }

    public boolean isDirty() {
        return this.isDirty_;
    }

    public void nodeChanged(INode iNode) {
        INode iNode2 = iNode.getParent();
        DocumentEvent documentEvent = new DocumentEvent((IDocument)this, iNode2, iNode, iNode2.indexOfChild(iNode), 4);
        this.fireDocumentEvent(documentEvent);
    }

    public void removeDocumentListener(IDocumentListener iDocumentListener) {
        this.documentListeners_.removeListener(iDocumentListener);
    }

    public void removeDocumentSourceListener(IDocumentSourceListener iDocumentSourceListener) {
        this.documentSourceListeners_.removeListener(iDocumentSourceListener);
    }

    public void setContentType(String string) {
        this.contentType_ = string;
    }

    public void setDescription(String string) {
        this.setProperty(DESCRIPTION_PROPERTY_KEY, string);
    }

    public void setDirty(boolean bl) {
        this.isDirty_ = bl;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public void setProperty(String string, String string2) {
        this.properties_.setProperty(string, string2);
    }

    public void setSourceFileName(String string) {
        this.sourceFileName_ = string;
        if (this.sourceFileName_ != null && this.name_ == null) {
            int n = this.sourceFileName_.lastIndexOf(File.separator);
            this.name_ = n > -1 ? this.sourceFileName_.substring(n + 1) : this.sourceFileName_;
        }
    }

    public void childAdded(INode iNode, INode iNode2, int n) {
        DocumentEvent documentEvent = new DocumentEvent((IDocument)this, iNode, iNode2, n, 3);
        this.fireDocumentEvent(documentEvent);
    }

    public void childRemoved(INode iNode, INode iNode2, int n) {
        DocumentEvent documentEvent = new DocumentEvent((IDocument)this, iNode, iNode2, n, 2);
        this.fireDocumentEvent(documentEvent);
    }

    public void addChild(INode iNode, INode iNode2, int n) {
        iNode.addChild(n, iNode2);
    }

    public void removeChild(INode iNode, INode iNode2) {
        iNode.removeChild(iNode2);
    }

    public void addChild(INode iNode, INode iNode2, int n, boolean bl) {
    }

    public void removeChild(INode iNode, INode iNode2, boolean bl) {
        iNode.removeChild(iNode2);
    }

    public void lock() {
        this.locked_ = true;
    }

    public boolean locked() {
        return this.locked_;
    }

    public void unlock() {
        this.locked_ = false;
    }

    public void updateNode(INode iNode, boolean bl) {
        this.nodeChanged(iNode);
    }

    public boolean isValid() {
        return this.valid_;
    }

    public void setValid(boolean bl) {
        this.valid_ = bl;
    }

    public void addMarkerListener(IMarkerListener iMarkerListener) {
        if (this.markerListeners_ == null) {
            this.markerListeners_ = new Vector();
        }
        this.markerListeners_.add(iMarkerListener);
    }

    public void removeMarkerListener(IMarkerListener iMarkerListener) {
        this.markerListeners_.remove(iMarkerListener);
    }

    public void markerAdded(INode iNode, IMarker iMarker) {
        if (this.markerListeners_ == null) {
            return;
        }
        int n = 0;
        while (n < this.markerListeners_.size()) {
            ((IMarkerListener)this.markerListeners_.elementAt(n)).markerAdded(iNode, iMarker);
            ++n;
        }
    }

    public void markerRemoved(INode iNode, IMarker iMarker) {
        if (this.markerListeners_ == null) {
            return;
        }
        int n = 0;
        while (n < this.markerListeners_.size()) {
            ((IMarkerListener)this.markerListeners_.elementAt(n)).markerRemoved(iNode, iMarker);
            ++n;
        }
    }

    public boolean exists() {
        return this.exists_;
    }

    public void setExists(boolean bl) {
        this.exists_ = bl;
    }

    public void childrenAdded(INode iNode, INode[] iNodeArray, int n) {
    }

    public void childrenRemoved(INode iNode, INode[] iNodeArray, int n) {
    }

    public int length() {
        return this.toString().length();
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public abstract INode getRoot();

    class DocumentListenerManager {
        private Vector listeners_ = new Vector();

        DocumentListenerManager() {
        }

        public void addListener(IDocumentListener iDocumentListener) {
            this.listeners_.add(iDocumentListener);
        }

        public void removeListener(IDocumentListener iDocumentListener) {
            this.listeners_.remove(iDocumentListener);
        }

        public void fireEvent(IDocumentEvent iDocumentEvent) {
            int n = 0;
            while (n < this.listeners_.size()) {
                ((IDocumentListener)this.listeners_.elementAt(n)).handleDocumentEvent(iDocumentEvent);
                ++n;
            }
        }
    }

    class DocumentSourceListenerManager {
        private Vector listeners_ = new Vector();

        DocumentSourceListenerManager() {
        }

        public void addListener(IDocumentSourceListener iDocumentSourceListener) {
            this.listeners_.add(iDocumentSourceListener);
        }

        public void removeListener(IDocumentSourceListener iDocumentSourceListener) {
            this.listeners_.remove(iDocumentSourceListener);
        }

        public void fireEvent(IDocumentSourceEvent iDocumentSourceEvent) {
            int n = 0;
            while (n < this.listeners_.size()) {
                ((IDocumentSourceListener)this.listeners_.elementAt(n)).handleDocumentSourceEvent(iDocumentSourceEvent);
                ++n;
            }
        }
    }
}

