/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.AbstractDocument;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.interfaces.IComment;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IProcessingInstruction;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IValidatedDocument;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.validation.CompoundValidationDocument;
import butterfly.xmlview.model.validation.ValidationWarningMarker;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeStructure;
import butterfly.xmlview.model.validation.interfaces.INodeValidationError;
import butterfly.xmlview.model.validation.interfaces.INodeValidator;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractValidatedDocument
extends AbstractDocument
implements IValidatedDocument {
    public static final int FIRST_BRANCH = 1;
    public static final int ONLY_BRANCH = 2;
    private static final Logger logger_;
    private IValidationDocument validationDocument_;
    private Hashtable errors_ = new Hashtable(3);
    private boolean validate_ = true;
    private boolean autoGenerateRequiredContent_ = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.AbstractValidatedDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public AbstractValidatedDocument(String string) {
        super(string);
    }

    public boolean hasErrors() {
        return this.errors_.size() < 1;
    }

    public IValidationDocument getValidationDocument() {
        this.getRoot();
        if (this.validationDocument_ == null) {
            this.setValidationDocument(new CompoundValidationDocument("text/validation"));
        }
        return this.validationDocument_;
    }

    public void setValidationDocument(IValidationDocument iValidationDocument) {
        this.validationDocument_ = iValidationDocument;
    }

    public void addChild(INode iNode, INode iNode2, int n, boolean bl) {
        super.addChild(iNode, iNode2, n, bl);
        if (this.validationIsOn() && !(iNode2 instanceof IScratchTag)) {
            this.validate(iNode);
            this.validate(iNode2);
        }
    }

    public void addChild(INode iNode, INode iNode2, int n) {
        super.addChild(iNode, iNode2, n);
        if (!this.locked()) {
            try {
                if (this.validationIsOn() && !(iNode2 instanceof IScratchTag)) {
                    logger_.debug((Object)"validating...");
                    this.validate(iNode);
                    this.validate(iNode2);
                }
                if (this.autoGenerateRequiredContentIsOn() && iNode2 instanceof IElement) {
                    final IElement iElement = (IElement)iNode2;
                    if (iElement.getDocument() == null) {
                        iElement.setDocument(this);
                    }
                    Runnable runnable = new Runnable(){

                        public void run() {
                            IElementStructure iElementStructure = AbstractValidatedDocument.this.getValidationDocument().getElementStructure(iElement.getLocalName(), iElement.getNameSpace());
                            if (iElementStructure != null) {
                                AbstractValidatedDocument.this.lock();
                                boolean bl = AbstractValidatedDocument.this.autoGenerateRequiredContentIsOn();
                                AbstractValidatedDocument.this.setAutoGenerateRequiredContent(false);
                                iElementStructure.getDefaultContent(iElement);
                                AbstractValidatedDocument.this.setAutoGenerateRequiredContent(bl);
                                AbstractValidatedDocument.this.unlock();
                                AbstractValidatedDocument.this.validate(iElement);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void validateChildren(INode iNode, boolean bl) {
        int n = 0;
        while (n < iNode.childCount()) {
            INode iNode2 = iNode.childAt(n);
            this.validate(iNode2);
            if (bl) {
                this.validateChildren(iNode2, bl);
            }
            ++n;
        }
    }

    public void validate(INode iNode) {
        INodeValidator iNodeValidator;
        if (iNode instanceof IScratchTag || iNode instanceof IComment || iNode instanceof IDTDNode || iNode instanceof IValueNode || iNode instanceof IProcessingInstruction || iNode instanceof IDocumentDeclaration || iNode instanceof DocumentRoot) {
            return;
        }
        INodeStructure iNodeStructure = this.getValidationDocument().getNodeStructure(iNode);
        INodeValidationError[] iNodeValidationErrorArray = null;
        if (iNodeStructure != null && (iNodeValidator = iNodeStructure.getValidator()) != null) {
            iNodeValidationErrorArray = iNodeValidator.validate(iNode);
        }
        this.clearOldErrors(iNode);
        this.attachValidationErrors(iNodeValidationErrorArray, iNode);
    }

    protected void removeValidationErrors(INode iNode) {
        this.attachValidationErrors(null, iNode);
    }

    protected void clearOldErrors(INode iNode) {
        this.clearErrorMarkers(iNode, iNode);
        int n = 0;
        while (n < iNode.childCount()) {
            this.clearErrorMarkers(iNode.childAt(n), iNode);
            ++n;
        }
    }

    protected void clearErrorMarkers(INode iNode, INode iNode2) {
        if (!iNode.hasWarningMarkers()) {
            return;
        }
        IMarker[] iMarkerArray = iNode.getMarkersOfType(0);
        int n = 0;
        while (n < iMarkerArray.length) {
            ValidationWarningMarker validationWarningMarker;
            if (iMarkerArray[n].getID() == -1010101 && (validationWarningMarker = (ValidationWarningMarker)iMarkerArray[n]).getError().getValidationContext() == iNode2) {
                iNode.removeMarker(validationWarningMarker);
            }
            ++n;
        }
    }

    protected void attachValidationErrors(INodeValidationError[] iNodeValidationErrorArray, INode iNode) {
        if (iNodeValidationErrorArray == null) {
            return;
        }
        int n = 0;
        while (n < iNodeValidationErrorArray.length) {
            INodeValidationError iNodeValidationError = iNodeValidationErrorArray[n];
            Vector vector = this.getErrorList(iNodeValidationError.getInvalidNode());
            vector.add(iNodeValidationErrorArray[n]);
            iNodeValidationErrorArray[n].getInvalidNode().addMarker(new ValidationWarningMarker(iNodeValidationErrorArray[n]));
            ++n;
        }
    }

    protected Vector getErrorList(INode iNode) {
        Vector vector = (Vector)this.errors_.get(iNode);
        if (vector == null) {
            vector = new Vector(1);
            this.errors_.put(iNode, vector);
        }
        return vector;
    }

    public INodeValidationError[] getValidationErrors(INode iNode) {
        Vector vector = (Vector)this.errors_.get(iNode);
        if (vector == null) {
            return null;
        }
        return vector.toArray(new INodeValidationError[0]);
    }

    public void removeChild(INode iNode, INode iNode2, boolean bl) {
        super.removeChild(iNode, iNode2, bl);
        if (this.validationIsOn() && !(iNode2 instanceof IScratchTag)) {
            this.validate(iNode);
        }
    }

    public void removeChild(INode iNode, INode iNode2) {
        super.removeChild(iNode, iNode2);
        if (this.validationIsOn() && !(iNode2 instanceof IScratchTag)) {
            this.validate(iNode);
        }
    }

    public void updateNode(INode iNode, boolean bl) {
        super.updateNode(iNode, bl);
        if (this.validationIsOn()) {
            this.validate(iNode);
        }
    }

    public void setValidate(boolean bl) {
        this.validate_ = bl;
    }

    public boolean validationIsOn() {
        return this.validate_;
    }

    public IElementStructure[] getElementStructures() {
        return this.getValidationDocument().getElementStructures();
    }

    public boolean autoGenerateRequiredContentIsOn() {
        return this.autoGenerateRequiredContent_;
    }

    public void setAutoGenerateRequiredContent(boolean bl) {
        this.autoGenerateRequiredContent_ = bl;
    }

    public boolean validate() {
        this.validateChildren(this.getRoot(), true);
        return this.hasErrors();
    }

    public void nodeChanged(INode iNode) {
        super.nodeChanged(iNode);
        if (this.validationIsOn()) {
            this.validate(iNode);
        }
    }

    public abstract void addValidationDocument(String var1, IValidationDocument var2);

    public abstract void removeValidationDocument(String var1);

    public abstract INode createNode(Object var1);
}

