/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.AttributeInfo;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributeParser {
    public static final String ATTRIBUTE_PATTERN = "[ ]*[\\w]*=\\\"[^<^>^\\\"]*\\\"";
    private static final Pattern pattern_ = Pattern.compile("[ ]*[\\w]*=\\\"[^<^>^\\\"]*\\\"");
    private Matcher matcher_;
    private String src_;
    private int start_;
    private int end_;
    private int lastEnd_;

    public AttributeParser(String string) {
        this.src_ = string;
        this.matcher_ = pattern_.matcher(this.src_);
    }

    public AttributeInfo[] parse() {
        Vector<AttributeInfo> vector = new Vector<AttributeInfo>();
        AttributeInfo attributeInfo = null;
        while ((attributeInfo = this.nextAttribute()) != null) {
            vector.add(attributeInfo);
        }
        return vector.toArray(new AttributeInfo[0]);
    }

    public AttributeInfo nextAttribute() {
        String string;
        if (this.matcher_.find(this.start_)) {
            this.start_ = this.matcher_.start();
            this.end_ = this.matcher_.end();
            String string2 = this.src_.substring(this.start_, this.end_);
            String string3 = this.src_.substring(this.lastEnd_, this.start_);
            if (string3.trim().length() > 0) {
                AttributeInfo attributeInfo = this.parseInvalidAttribute(string3);
                attributeInfo.start = this.lastEnd_;
                attributeInfo.length = this.start_ - this.lastEnd_;
                this.lastEnd_ = this.start_ = this.start_;
                return attributeInfo;
            }
            this.start_ = this.end_;
            this.lastEnd_ = this.end_;
            AttributeInfo attributeInfo = this.parseAttribute(string2);
            attributeInfo.start = this.start_;
            attributeInfo.length = this.end_ - this.start_;
            return attributeInfo;
        }
        if (this.lastEnd_ < this.src_.length() - 1 && (string = this.src_.substring(this.lastEnd_)).trim().length() > 0) {
            AttributeInfo attributeInfo = this.parseInvalidAttribute(string);
            attributeInfo.start = this.lastEnd_;
            attributeInfo.length = this.src_.length() - this.lastEnd_;
            this.lastEnd_ = this.src_.length() - 1;
            return attributeInfo;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "a=\"b\" jules=\"cool\" crap";
        AttributeParser attributeParser = new AttributeParser(string);
        AttributeInfo[] attributeInfoArray = attributeParser.parse();
        int n = 0;
        while (n < attributeInfoArray.length) {
            System.out.println(String.valueOf(attributeInfoArray[n].name) + " = " + attributeInfoArray[n].value + " valid=" + attributeInfoArray[n].valid);
            ++n;
        }
    }

    public AttributeInfo parseInvalidAttribute(String string) {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.valid = false;
        attributeInfo.name = "Invalid attribute declaration \"" + string + "\"";
        return attributeInfo;
    }

    public AttributeInfo parseAttribute(String string) {
        string = string.trim();
        int n = string.indexOf("=");
        String string2 = string.substring(0, n);
        n = string.indexOf("\"");
        int n2 = string.indexOf("\"", n + 1);
        String string3 = string.substring(n + 1, n2);
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.name = string2;
        attributeInfo.value = string3;
        return attributeInfo;
    }
}

