/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.DTDNode;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.interfaces.IContextParent;
import butterfly.xmlview.model.interfaces.IDTDDeclaration;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IScratchTagState;
import butterfly.xmlview.model.interfaces.IScratchable;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.ITag;
import butterfly.xmlview.model.interfaces.IValidatedDocument;
import butterfly.xmlview.model.validation.DTDParser;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeStructure;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import butterfly.xmlview.util.FileSystem;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.parser.XMLInputSource;

public class DTDDeclaration
extends DTDNode
implements IContextParent,
IScratchable,
IDTDDeclaration,
ITag,
ISourceElement {
    private String systemID_;
    private String publicID_;
    private String name_;
    private int endTagStart_;
    private int endTagLength_;
    private ValidationDocument validationDocument_;
    private boolean dirty_ = false;
    private static final Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.DTDDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public DTDDeclaration() {
    }

    public DTDDeclaration(String string, String string2, String string3) {
        this.name_ = string;
        this.publicID_ = string2;
        this.systemID_ = string3;
        if (this.systemID_ != null || this.publicID_ != null) {
            this.dirty_ = true;
        }
        this.validationDocument_ = new DTDValidationDocument("text/dtd", null);
    }

    public int getEndTagLength() {
        return this.endTagLength_;
    }

    public int getEndTagStart() {
        return this.endTagStart_;
    }

    public String getName() {
        return this.name_;
    }

    public String getPublicID() {
        return this.publicID_;
    }

    public String getSystemID() {
        return this.systemID_;
    }

    private int getEndIndex(ISourceNode iSourceNode) {
        if (iSourceNode instanceof ISourceElement) {
            ISourceElement iSourceElement = (ISourceElement)iSourceNode;
            return iSourceElement.getEndTagStart() + iSourceElement.getEndTagLength();
        }
        return iSourceNode.getStart() + iSourceNode.getLength();
    }

    public void scratchContents() {
    }

    public IScratchTag scratch(boolean bl, int n) {
        this.dirty_ = true;
        if (bl && (n == this.getStart() || n == this.getEndTagStart())) {
            ScratchTag scratchTag = new ScratchTag((IModelToSourceMapping)((Object)this.getDocument()), this.getDocument(), (IScratchTagState)ScratchTag.TEXT_STATE, n, 0);
            if (n == this.getStart()) {
                int n2 = this.getParent().indexOfChild(this);
                this.getDocument().addChild(this.getParent(), scratchTag, n2);
            } else {
                this.getDocument().addChild(this, scratchTag, this.childCount());
            }
            return null;
        }
        if (this.getDocument() != null && this.getDocument() instanceof AbstractValidatedDocument) {
            ((AbstractValidatedDocument)this.getDocument()).removeValidationDocument(null);
        }
        INode iNode = this.getParent();
        int n3 = iNode.indexOfChild(this);
        int n4 = this.getStart();
        int n5 = this.getEndTagStart() + this.getEndTagLength();
        if (n5 <= n4) {
            n5 = this.getStart() + this.getLength();
        }
        int cfr_ignored_0 = n5 - n4;
        IDocument iDocument = this.getDocument();
        iDocument.removeChild(iNode, this, false);
        int n6 = 0;
        ScratchTag scratchTag = new ScratchTag((IModelToSourceMapping)((Object)iDocument), iDocument, (IScratchTagState)ScratchTag.TEXT_STATE, n4, n5 - n4);
        iDocument.addChild(iNode, scratchTag, n3 + n6, false);
        ++n6;
        scratchTag.revalidateState();
        return null;
    }

    public void setEndTagLength(int n) {
        this.endTagLength_ = n;
    }

    public void setEndTagStart(int n) {
        this.endTagStart_ = n;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public void setPublicID(String string) {
        this.publicID_ = string;
    }

    public void setSystemID(String string) {
        this.systemID_ = string;
    }

    public String toEndString() {
        return "]>";
    }

    public String toString() {
        return this.toXml();
    }

    public String toDTD() {
        String string = "";
        int n = 0;
        while (n < this.childCount()) {
            string = String.valueOf(string) + this.childAt(n).toString();
            ++n;
        }
        return string;
    }

    public String toXml() {
        StringBuffer stringBuffer = new StringBuffer("<!DOCTYPE ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" ");
        if (this.getPublicID() != null) {
            stringBuffer.append("PUBLIC \"");
            stringBuffer.append(this.getPublicID());
            stringBuffer.append("\" ");
            if (this.getSystemID() != null) {
                stringBuffer.append("\"");
                stringBuffer.append(this.getSystemID());
                stringBuffer.append("\" ");
            }
        } else if (this.getSystemID() != null) {
            stringBuffer.append("SYSTEM \"");
            stringBuffer.append(this.getSystemID());
            stringBuffer.append("\" ");
        }
        if (this.getEndTagStart() > 0) {
            stringBuffer.append("[");
        } else {
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    public void checkChildren() {
        INode iNode = null;
        int n = 0;
        while (n < this.childCount()) {
            iNode = this.childAt(n);
            if (!(iNode instanceof IDTDNode) && !(iNode instanceof IScratchTag)) {
                ((IScratchable)((Object)this.childAt(n))).scratch(false, -2);
            }
            if (iNode instanceof ScratchTag) {
                ((ScratchTag)iNode).setDirty(true);
                ((ScratchTag)iNode).check();
            }
            ++n;
        }
    }

    public INode createNode() {
        DTDDeclaration dTDDeclaration = new DTDDeclaration(this.getName(), this.getPublicID(), this.getSystemID());
        return dTDDeclaration;
    }

    public IValidationDocument getValidationDocument() {
        if (this.getDocument() == null) {
            logger_.debug((Object)"DTDDeclaration requires its parent document to be set before it can generate a ValidationDocument");
            return null;
        }
        if (this.dirty_) {
            try {
                StringReader stringReader;
                XMLInputSource xMLInputSource;
                Hashtable hashtable;
                Object object;
                this.dirty_ = false;
                String string = "";
                if (this.getSystemID() != null && this.getPublicID() == null) {
                    logger_.debug((Object)"loading external dtd...");
                    try {
                        IDocument iDocument = FileSystem.loadDocument(FileSystem.resolve(this.getDocument().getSourceFileName(), this.getSystemID()));
                        if (iDocument != null) {
                            string = String.valueOf(iDocument.toString()) + "\n";
                        }
                        if (string.trim().startsWith("<?xml") && string.indexOf(">") > 0) {
                            string = string.trim();
                            string = string.substring(string.indexOf(">") + 1);
                        }
                        logger_.debug((Object)("dtd loaded: " + string));
                    }
                    catch (Exception exception) {
                        logger_.warn((Object)("unable to load external dtd " + this.getSystemID()));
                        exception.printStackTrace();
                    }
                }
                if (this.getEndTagStart() > 0) {
                    string = String.valueOf(string) + this.getDocument().toString().substring(this.getStart() + this.getLength(), this.getEndTagStart());
                    int n = 0;
                    int n2 = 0;
                    while (n2 < this.childCount()) {
                        if (this.childAt(n2) instanceof IScratchTag) {
                            object = (IScratchTag)this.childAt(n2);
                            int n3 = object.getStart();
                            int n4 = object.getLength() + n3;
                            if (object.getLength() > 0) {
                                if (n3 - n >= 0 && n4 - n < string.length() && n4 - n >= 0 && n3 - n <= string.length()) {
                                    string = string.substring(n3 - n, n4 - n);
                                    n += object.getLength();
                                } else {
                                    logger_.warn((Object)("bad scratch tag bounds:" + object));
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if ((hashtable = ((DTDParser)(object = new DTDParser())).buildElementStructure(xMLInputSource = new XMLInputSource(null, null, null, (Reader)(stringReader = new StringReader(string)), "UTF-8"))) == null || this.validationDocument_ == null) {
                    return this.validationDocument_;
                }
                this.validationDocument_.setElementStructures(hashtable.values().toArray(new IElementStructure[0]));
                logger_.debug((Object)"DTDValidationDocument updated.");
                IElementStructure[] iElementStructureArray = this.validationDocument_.getElementStructures();
                int n = 0;
                while (n < iElementStructureArray.length) {
                    logger_.debug((Object)iElementStructureArray[n]);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.validationDocument_;
    }

    public void addChild(INode iNode) {
        if (iNode instanceof IDTDNode || iNode instanceof IScratchTag) {
            this.dirty_ = true;
        }
        super.addChild(iNode);
        this.triggerValidation();
    }

    public void addChild(int n, INode iNode) {
        if (iNode instanceof IDTDNode || iNode instanceof IScratchTag) {
            this.dirty_ = true;
        }
        super.addChild(n, iNode);
        this.triggerValidation();
    }

    public void removeChild(INode iNode) {
        super.removeChild(iNode);
        if (iNode instanceof IDTDNode) {
            this.dirty_ = true;
        }
        this.triggerValidation();
    }

    public void removeChildAt(int n) {
        this.dirty_ = true;
        this.triggerValidation();
        super.removeChildAt(n);
    }

    protected void triggerValidation() {
        if (this.dirty_ && this.getDocument() instanceof IValidatedDocument) {
            ((IValidatedDocument)this.getDocument()).validate();
        }
    }

    public void shiftEnd(int n) {
        this.endTagStart_ += n;
    }

    class DTDValidationDocument
    extends ValidationDocument {
        public DTDValidationDocument(String string, IDocument iDocument) {
            super(string, iDocument);
        }

        public IElementStructure getElementStructure(String string, String string2) {
            DTDDeclaration.this.getValidationDocument();
            return super.getElementStructure(string, string2);
        }

        public IElementStructure[] getElementStructures() {
            DTDDeclaration.this.getValidationDocument();
            return super.getElementStructures();
        }

        public INodeStructure getNodeStructure(INode iNode) {
            DTDDeclaration.this.getValidationDocument();
            return super.getNodeStructure(iNode);
        }

        public INodeStructure[] getNodeStructures() {
            DTDDeclaration.this.getValidationDocument();
            return super.getNodeStructures();
        }
    }
}

