/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.DocumentDeclaration;
import butterfly.xmlview.model.Marker;
import butterfly.xmlview.model.Node;
import butterfly.xmlview.model.interfaces.IDTDDeclaration;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.INode;

public class DocumentRoot
extends Node {
    public static final int NO_ROOT_ELEMENT_MARKER_ID = -100001;
    public static final IMarker NO_ROOT_ELEMENT_MARKER = new Marker("An XML document may only have one root element", 0, -100001);
    private IElement lastElement_;
    private boolean hasDTD_ = false;
    public static final String PATH = "/";

    public INode getParent() {
        return null;
    }

    public String getPath() {
        return PATH;
    }

    public void setParent(INode iNode) {
    }

    public String toString() {
        return "DocumentRoot";
    }

    public void addChild(int n, INode iNode) {
        if (iNode instanceof IDTDDeclaration) {
            this.hasDTD_ = true;
        }
        if (iNode instanceof IElement) {
            if (this.lastElement_ == null) {
                this.lastElement_ = (IElement)iNode;
            } else {
                int n2 = this.indexOfChild(this.lastElement_);
                if (n > n2 && iNode instanceof Node) {
                    iNode.addMarker(NO_ROOT_ELEMENT_MARKER);
                } else {
                    INode iNode2 = this.childAt(n2);
                    iNode2.addMarker(NO_ROOT_ELEMENT_MARKER);
                    this.lastElement_ = (IElement)iNode;
                }
            }
        }
        super.addChild(n, iNode);
    }

    public void removeChild(INode iNode) {
        if (iNode instanceof IDTDDeclaration) {
            this.hasDTD_ = false;
        }
        if (iNode instanceof IElement && iNode instanceof Node) {
            iNode.removeMarker(NO_ROOT_ELEMENT_MARKER);
        }
        super.removeChild(iNode);
        if (iNode.equals(this.lastElement_)) {
            IElement iElement = this.firstElement();
            if (iElement != null) {
                if (iElement instanceof Node) {
                    iElement.removeMarker(NO_ROOT_ELEMENT_MARKER);
                    this.lastElement_ = iElement;
                }
            } else {
                this.lastElement_ = null;
            }
        }
    }

    public IElement firstElement() {
        IElement iElement = null;
        int n = 0;
        while (n < this.childCount()) {
            if (this.childAt(n) instanceof IElement) {
                iElement = (IElement)this.childAt(n);
                break;
            }
            ++n;
        }
        return iElement;
    }

    public boolean hasDTD() {
        return this.hasDTD_;
    }

    protected INode createNode() {
        return new DocumentDeclaration();
    }
}

