/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.AttributeList;
import butterfly.xmlview.model.EditInfo;
import butterfly.xmlview.model.MultiNode;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IEditInfo;
import butterfly.xmlview.model.interfaces.IEditable;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INamespacePrefixMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IScratchTagState;
import butterfly.xmlview.model.interfaces.IScratchable;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ITag;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class Element
extends MultiNode
implements IElement,
ISourceElement,
IEditable,
ITag,
IScratchable {
    public static final String XML_NAMESPACE_ATTRIBUTE = "xmlns";
    private String name_;
    private String nameSpace_ = null;
    private AttributeList attributes_;
    private Hashtable prefixMappings_;
    private int endTagStart_ = -1;
    private int endTagLength_ = -1;
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public Element(String string) {
        this.name_ = string;
    }

    public void addAttribute(int n, IAttribute iAttribute) {
        if (this.attributes_ == null) {
            this.attributes_ = new AttributeList();
        }
        this.attributes_.addAttribute(n, iAttribute);
        if (iAttribute instanceof INamespacePrefixMapping) {
            this.addPrefixMapping((INamespacePrefixMapping)iAttribute);
        }
        if (iAttribute.getName().equals(XML_NAMESPACE_ATTRIBUTE)) {
            this.setNameSpace(iAttribute.getData().toString());
        }
        if (this.getDocument() != null) {
            this.getDocument().nodeChanged(this);
        }
    }

    public void addAttribute(IAttribute iAttribute) {
        if (this.attributes_ == null) {
            this.attributes_ = new AttributeList();
        }
        this.attributes_.addAttribute(iAttribute);
        if (iAttribute instanceof INamespacePrefixMapping) {
            this.addPrefixMapping((INamespacePrefixMapping)iAttribute);
        }
        if (iAttribute.getName().equals(XML_NAMESPACE_ATTRIBUTE)) {
            this.setNameSpace(iAttribute.getData().toString());
        }
        if (this.getDocument() != null) {
            this.getDocument().nodeChanged(this);
        }
    }

    public IAttribute attributeAt(int n) {
        return this.attributes_.attributeAt(n);
    }

    public int attributeCount() {
        if (this.attributes_ == null) {
            return 0;
        }
        return this.attributes_.size();
    }

    public void clearAttributes() {
        if (this.attributes_ != null) {
            this.attributes_.clear();
            if (this.prefixMappings_ != null) {
                this.prefixMappings_.clear();
                this.nameSpace_ = null;
            }
        }
        if (this.getDocument() != null) {
            this.getDocument().nodeChanged(this);
        }
    }

    public String getDescription() {
        return "<p>The tag editor allows you to change the properties of an XML element</p>";
    }

    public IEditInfo[] getEditableProperties() {
        EditInfo editInfo = new EditInfo(this);
        editInfo.setPropertyName("");
        editInfo.setDescription("The element's attributes.");
        IEditInfo[] iEditInfoArray = new IEditInfo[]{editInfo};
        return iEditInfoArray;
    }

    public int getEndTagLength() {
        return this.endTagLength_;
    }

    public int getEndTagStart() {
        return this.endTagStart_;
    }

    public String getName() {
        return this.name_;
    }

    public String getNameSpace() {
        String string = this.getPrefix();
        if (string == null && this.nameSpace_ == null) {
            if (this.getParent() instanceof IElement) {
                return ((IElement)this.getParent()).getDefaultNamespace();
            }
            return null;
        }
        if (string != null) {
            return this.resolvePrefix(string);
        }
        return this.nameSpace_;
    }

    public String getDefaultNamespace() {
        if (this.nameSpace_ == null && this.getParent() instanceof IElement) {
            return ((IElement)this.getParent()).getDefaultNamespace();
        }
        return this.nameSpace_;
    }

    public String getTitle() {
        return "Element: " + this.getName();
    }

    public void removeAttribute(IAttribute iAttribute) {
        this.attributes_.removeAttribute(iAttribute);
        if (iAttribute instanceof INamespacePrefixMapping) {
            this.removePrefixMapping(((INamespacePrefixMapping)iAttribute).getPrefix());
        }
        if (iAttribute.getName().equals(XML_NAMESPACE_ATTRIBUTE)) {
            this.setNameSpace(null);
        }
        if (this.getDocument() != null) {
            this.getDocument().nodeChanged(this);
        }
    }

    public void removeAttributeAt(int n) {
        this.removeAttribute(this.attributeAt(n));
    }

    public void setEndTagLength(int n) {
        this.endTagLength_ = n;
    }

    public void setEndTagStart(int n) {
        this.endTagStart_ = n;
    }

    public void shiftEnd(int n) {
        this.endTagStart_ += n;
    }

    public void setName(String string) {
        if (this.getDocument() != null) {
            this.getDocument().getPath(this);
            this.name_ = string;
            this.getDocument().nodeChanged(this);
        }
        this.name_ = string;
    }

    public void setNameSpace(String string) {
        this.nameSpace_ = string;
        if (this.getDocument() != null) {
            this.getDocument().nodeChanged(this);
        }
    }

    public String toEndString() {
        StringBuffer stringBuffer = new StringBuffer("</");
        stringBuffer.append(this.getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(this.getName());
        int n = 0;
        while (n < this.attributeCount()) {
            stringBuffer.append(" ");
            stringBuffer.append(this.attributeAt(n).getName());
            stringBuffer.append("=\"");
            stringBuffer.append(this.attributeAt(n).getData());
            stringBuffer.append("\"");
            ++n;
        }
        if (this.getEndTagStart() < 0) {
            stringBuffer.append("/");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public IScratchTag scratch(boolean bl, int n) {
        if (bl && (n == this.getStart() || n == this.getEndTagStart())) {
            ScratchTag scratchTag = new ScratchTag((IModelToSourceMapping)((Object)this.getDocument()), this.getDocument(), (IScratchTagState)ScratchTag.TEXT_STATE, n, 0);
            if (n == this.getStart()) {
                int n2 = this.getParent().indexOfChild(this);
                this.getDocument().addChild(this.getParent(), scratchTag, n2);
            } else {
                this.getDocument().addChild(this, scratchTag, this.childCount());
            }
            return null;
        }
        ScratchTag scratchTag = null;
        ScratchTag scratchTag2 = new ScratchTag((IModelToSourceMapping)((Object)this.getDocument()), this.getDocument(), (IScratchTagState)ScratchTag.CLOSED_STATE, this.getStart(), this.getLength());
        if (this.getEndTagStart() > -1) {
            scratchTag = new ScratchTag((IModelToSourceMapping)((Object)this.getDocument()), this.getDocument(), (IScratchTagState)ScratchTag.CLOSED_STATE, this.getEndTagStart(), this.getEndTagLength());
        }
        int n3 = this.getParent().indexOfChild(this);
        INode iNode = this.getParent();
        IDocument iDocument = this.getDocument();
        int n4 = this.childCount();
        ((XmlDocument)iDocument).moveNodes(this, 0, this.childCount(), iNode, n3);
        iDocument.removeChild(iNode, this, false);
        iDocument.addChild(iNode, scratchTag2, n3, false);
        ++n3;
        n3 += n4;
        if (scratchTag != null) {
            iDocument.addChild(iNode, scratchTag, n3, false);
            if (n >= this.getStart() + this.getLength()) {
                scratchTag.setSplitTag(scratchTag2);
            } else {
                scratchTag2.setSplitTag(scratchTag);
            }
        }
        if (n > this.getStart() + this.getLength()) {
            return scratchTag;
        }
        return scratchTag2;
    }

    protected void addPrefixMapping(INamespacePrefixMapping iNamespacePrefixMapping) {
        if (this.prefixMappings_ == null) {
            this.prefixMappings_ = new Hashtable(1);
        }
        if (iNamespacePrefixMapping.getPrefix() != null) {
            this.prefixMappings_.put(iNamespacePrefixMapping.getPrefix(), iNamespacePrefixMapping);
        } else {
            this.setNameSpace(iNamespacePrefixMapping.getURI());
        }
    }

    protected void removePrefixMapping(String string) {
        this.prefixMappings_.remove(string);
    }

    public INamespacePrefixMapping[] getPrefixMappings() {
        if (this.prefixMappings_ == null) {
            return null;
        }
        return this.prefixMappings_.values().toArray(new INamespacePrefixMapping[0]);
    }

    public INamespacePrefixMapping getPrefixMapping(String string) {
        if (this.prefixMappings_ == null) {
            return null;
        }
        return (INamespacePrefixMapping)this.prefixMappings_.get(string);
    }

    public String getPrefix() {
        int n = this.getName().indexOf(58);
        if (n > -1) {
            return this.getName().substring(0, n);
        }
        return null;
    }

    public String getLocalName() {
        int n = this.getName().indexOf(58);
        if (n > -1) {
            return this.getName().substring(n + 1);
        }
        return this.getName();
    }

    public String resolvePrefix(String string) {
        INamespacePrefixMapping iNamespacePrefixMapping = this.getPrefixMapping(string);
        if (iNamespacePrefixMapping == null && this.getParent() != null && this.getParent() instanceof IElement) {
            return ((IElement)this.getParent()).resolvePrefix(string);
        }
        if (iNamespacePrefixMapping != null) {
            return iNamespacePrefixMapping.getURI();
        }
        return null;
    }

    public IAttribute getAttribute(String string) {
        return this.getAttribute(null, string);
    }

    public IAttribute getAttribute(String string, String string2) {
        IAttribute iAttribute = null;
        int n = 0;
        while (n < this.attributeCount()) {
            iAttribute = this.attributeAt(n);
            if (iAttribute.getLocalName().equals(string2)) {
                System.out.println("same name");
                if (string == null) {
                    return iAttribute;
                }
                String string3 = this.getNameSpace();
                if (iAttribute.getPrefix() != null) {
                    string3 = this.resolvePrefix(iAttribute.getPrefix());
                }
                if (string.equals(string3)) {
                    return iAttribute;
                }
            }
            ++n;
        }
        return null;
    }

    protected INode createNode() {
        Element element = new Element(this.getName());
        element.setNameSpace(this.nameSpace_);
        int n = 0;
        while (n < this.attributeCount()) {
            element.addAttribute(this.attributeAt(n).createCopy());
            ++n;
        }
        return element;
    }
}

