/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IOccurrence;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeValidator;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ElementStructure
implements IElementStructure {
    private Hashtable occurrences_ = new Hashtable(3);
    private Vector subElements_;
    private Vector attributes_;
    private Vector defaultContent_ = new Vector(1);
    private String name_;
    private String nameSpace_;

    public ElementStructure(IElement iElement) {
        this(iElement.getNameSpace(), iElement.getLocalName());
        int n = 0;
        while (n < iElement.attributeCount()) {
            this.addAttribute(iElement.attributeAt(n).getName());
            if (iElement.attributeAt(n).getData().equals("default__")) {
                this.defaultContent_.add(iElement.attributeAt(n).getName());
            }
            ++n;
        }
    }

    public ElementStructure(String string, String string2) {
        this.subElements_ = new Vector();
        this.attributes_ = new Vector();
        this.name_ = string2;
        this.nameSpace_ = string;
    }

    public void addAttribute(String string) {
        if (!this.attributes_.contains(string)) {
            this.attributes_.add(string);
        }
    }

    public void addAttributes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.addAttribute(stringTokenizer.nextToken());
        }
    }

    public void addSubElement(IElementStructure iElementStructure) {
        if (!this.subElements_.contains(iElementStructure)) {
            this.subElements_.add(iElementStructure);
        }
    }

    public void setAllowedSubElements(Vector vector) {
        this.subElements_ = vector;
    }

    public void addSubElements(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.addSubElement((IElementStructure)vector.elementAt(n));
            ++n;
        }
    }

    public void addSubElement(IElementStructure iElementStructure, int n, int n2) {
        this.addSubElement(iElementStructure);
        Occurrence occurrence = new Occurrence();
        occurrence.min = n;
        occurrence.max = n2;
        this.setOccurrence(iElementStructure, occurrence);
    }

    public void setOccurrence(IElementStructure iElementStructure, IOccurrence iOccurrence) {
        this.occurrences_.put(iElementStructure.getName(), iOccurrence);
    }

    public String attributeAt(int n) {
        return (String)this.attributes_.elementAt(n);
    }

    public int attributeCount() {
        return this.attributes_.size();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IElementStructure) {
            IElementStructure iElementStructure = (IElementStructure)object;
            boolean bl = true;
            bl = this.getNamespace() == null || iElementStructure.getNamespace() == null ? iElementStructure.getNamespace() == this.getNamespace() : iElementStructure.getNamespace().equals(this.getNamespace());
            return iElementStructure.getName().equals(this.getName()) && bl;
        }
        return false;
    }

    public Vector getAttributes() {
        return this.attributes_;
    }

    public String getName() {
        return this.name_;
    }

    public String getNamespace() {
        return this.nameSpace_;
    }

    public Vector getSubElements() {
        return this.subElements_;
    }

    public void removeAttribute(String string) {
        this.attributes_.remove(string);
    }

    public void removeSubElement(IElementStructure iElementStructure) {
        this.subElements_.remove(iElementStructure);
    }

    public IElementStructure subElementAt(int n) {
        if (!(this.subElements_.elementAt(n) instanceof IElementStructure)) {
            System.out.println("");
        }
        return (IElementStructure)this.subElements_.elementAt(n);
    }

    public int subElementCount() {
        return this.subElements_.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(this.getName());
        stringBuffer.append(">");
        stringBuffer.append("\n");
        stringBuffer.append(" Allowed Attributes:\n");
        int n = 0;
        while (n < this.attributeCount()) {
            stringBuffer.append("  @" + this.attributeAt(n));
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append(" Allowed Sub-elements:\n");
        n = 0;
        while (n < this.subElementCount()) {
            stringBuffer.append("  <");
            stringBuffer.append(this.subElementAt(n).getName());
            stringBuffer.append(">\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public IOccurrence getOccurrence(IElementStructure iElementStructure) {
        return (IOccurrence)this.occurrences_.get(iElementStructure.getName());
    }

    public IElementStructure[] allowedElementsAt(IElement iElement, int n) {
        return null;
    }

    public INodeValidator getValidator() {
        return null;
    }

    public void getDefaultContent(IElement iElement) {
        System.out.println("get default content");
        this.getDefaultContent(iElement, new Hashtable());
    }

    private void getDefaultContent(IElement iElement, Hashtable hashtable) {
        hashtable.put(this, this);
        IDocument iDocument = iElement.getDocument();
        int n = 0;
        while (n < this.defaultContent_.size()) {
            Object e = this.defaultContent_.elementAt(n);
            if (e instanceof String) {
                iElement.addAttribute(new Attribute((String)e, ""));
            } else if (hashtable.get(e) == null) {
                ElementStructure elementStructure = (ElementStructure)e;
                String string = elementStructure.getNamespace();
                String string2 = null;
                if (iDocument instanceof XmlDocument) {
                    string2 = ((XmlDocument)iDocument).getPrefixForNamespace(string);
                }
                String string3 = elementStructure.getName();
                if (string2 != null) {
                    string3 = String.valueOf(string2) + ":" + string3;
                }
                Element element = new Element(string3);
                if (iDocument != null) {
                    iDocument.addChild(iElement, element, iElement.childCount(), true);
                } else {
                    iElement.addChild(element);
                }
                elementStructure.getDefaultContent(element, hashtable);
            }
            ++n;
        }
        if (iDocument != null) {
            iDocument.updateNode(iElement, true);
        }
    }

    public void setNamespace(String string) {
        this.nameSpace_ = string;
    }

    public void addToDefaultContent(ElementStructure elementStructure) {
        this.defaultContent_.add(elementStructure);
    }

    public void addToDefaultContent(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            this.defaultContent_.add(stringTokenizer.nextToken());
        }
    }

    public boolean hasAttribute(String string) {
        return this.attributes_.contains(string);
    }

    class Occurrence
    implements IOccurrence {
        public int min = 0;
        public int max = 1;

        Occurrence() {
        }

        public int getMax() {
            return this.max;
        }

        public int getMin() {
            return this.min;
        }
    }
}

