/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.NodeList;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IMultiNode;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceNode;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Node
implements IMultiNode,
INode,
ISourceNode,
Comparable {
    private INode parent_;
    private IDocument document_;
    private int start_ = -1;
    private int length_ = -1;
    private NodeList elements_;
    private Vector markers_;
    private int errorMarkerCount_ = 0;
    private int warningMarkerCount_ = 0;

    public void addChild(int n, INode iNode) {
        if (iNode != null) {
            if (this.elements_ == null) {
                this.elements_ = new NodeList();
            }
            iNode.setDocument(this.getDocument());
            this.elements_.addNode(n, iNode);
            iNode.setParent(this);
            if (this.getDocument() != null) {
                this.getDocument().childAdded(this, iNode, n);
            }
        }
    }

    public void addChild(INode iNode) {
        if (this.elements_ == null) {
            this.elements_ = new NodeList();
        }
        this.addChild(this.elements_.size(), iNode);
    }

    public INode childAt(int n) {
        if (this.elements_ == null) {
            return null;
        }
        return this.elements_.nodeAt(n);
    }

    public int childCount() {
        if (this.elements_ == null) {
            return 0;
        }
        return this.elements_.size();
    }

    public int compareTo(Object object) {
        int n;
        if (this.equals(object)) {
            return 0;
        }
        int n2 = ((ISourceNode)object).getStart();
        if (n2 == (n = this.getStart())) {
            int n3 = this.getLength() - ((ISourceNode)object).getLength();
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }
        return n - n2;
    }

    public int compareTo(INode iNode) {
        int n;
        if (this.equals(iNode)) {
            return 0;
        }
        int n2 = iNode.getStart();
        if (n2 == (n = this.getStart())) {
            int n3 = this.getLength() - iNode.getLength();
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }
        return n - n2;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public IDocument getDocument() {
        return this.document_;
    }

    public int getLength() {
        return this.length_;
    }

    public INode getParent() {
        return this.parent_;
    }

    public String getPath() {
        if (this.getDocument() == null) {
            return null;
        }
        return this.getDocument().getPath(this);
    }

    public int getStart() {
        return this.start_;
    }

    public int indexOfChild(INode iNode) {
        return this.elements_.indexOfNode(iNode);
    }

    public void removeChild(INode iNode) {
        int n = this.elements_.indexOfNode(iNode);
        this.elements_.removeNode(iNode);
        iNode.setDocument(null);
        if (this.getDocument() != null) {
            this.getDocument().childRemoved(this, iNode, n);
        }
    }

    public void removeChildAt(int n) {
        INode iNode = this.elements_.nodeAt(n);
        this.removeChild(iNode);
    }

    public void setDocument(IDocument iDocument) {
        if (this.document_ != iDocument) {
            this.document_ = iDocument;
            int n = 0;
            while (n < this.childCount()) {
                this.childAt(n).setDocument(iDocument);
                ++n;
            }
        }
    }

    public void setLength(int n) {
        this.length_ = n;
    }

    public void setParent(INode iNode) {
        this.parent_ = iNode;
        if (this.markers_ != null) {
            IMarker iMarker = null;
            Enumeration enumeration = this.markers_.elements();
            while (enumeration.hasMoreElements()) {
                iMarker = (IMarker)enumeration.nextElement();
                if (!iMarker.isContextSensitive()) continue;
                this.removeMarker(iMarker);
            }
        }
    }

    public void setStart(int n) {
        this.start_ = n;
    }

    public void shift(int n) {
        this.start_ += n;
    }

    public String toString() {
        return "";
    }

    public void addMarker(IMarker iMarker) {
        switch (iMarker.getType()) {
            case 0: {
                ++this.warningMarkerCount_;
                break;
            }
            case -1: {
                ++this.errorMarkerCount_;
            }
        }
        if (this.markers_ == null) {
            this.markers_ = new Vector(3);
        }
        this.markers_.add(iMarker);
        if (this.getDocument() != null) {
            this.getDocument().markerAdded(this, iMarker);
        }
    }

    public void removeMarker(IMarker iMarker) {
        if (this.markers_ == null || !this.markers_.contains(iMarker)) {
            return;
        }
        switch (iMarker.getType()) {
            case 0: {
                --this.warningMarkerCount_;
                break;
            }
            case -1: {
                --this.errorMarkerCount_;
            }
        }
        if (this.markers_ != null && iMarker != null) {
            this.markers_.remove(iMarker);
            if (this.getDocument() != null) {
                this.getDocument().markerRemoved(this, iMarker);
            }
        }
    }

    public IMarker[] getMarkers() {
        if (this.markers_ == null) {
            return null;
        }
        return this.markers_.toArray(new IMarker[0]);
    }

    public IMarker[] getMarkersOfType(int n) {
        if (this.markers_ == null) {
            return null;
        }
        Vector vector = new Vector(this.markers_.size());
        int n2 = 0;
        while (n2 < this.markers_.size()) {
            if (((IMarker)this.markers_.elementAt(n2)).getType() == n) {
                vector.add(this.markers_.elementAt(n2));
            }
            ++n2;
        }
        return vector.toArray(new IMarker[0]);
    }

    public IMarker[] getMarkersWithID(int n) {
        if (this.markers_ == null) {
            return null;
        }
        Vector vector = new Vector(this.markers_.size());
        int n2 = 0;
        while (n2 < this.markers_.size()) {
            if (((IMarker)this.markers_.elementAt(n2)).getID() == n) {
                vector.add(this.markers_.elementAt(n2));
            }
            ++n2;
        }
        return vector.toArray(new IMarker[0]);
    }

    public boolean hasWarningMarkers() {
        return this.warningMarkerCount_ > 0;
    }

    public boolean hasErrorMarkers() {
        return this.errorMarkerCount_ > 0;
    }

    public INode createCopy(boolean bl) {
        INode iNode = this.createNode();
        if (bl) {
            this.copyChildren(iNode, true);
        }
        return iNode;
    }

    public void copyChildren(INode iNode, boolean bl) {
        int n = 0;
        while (n < this.childCount()) {
            iNode.addChild(this.childAt(n).createCopy(bl));
            ++n;
        }
    }

    public INode[] removeChildren(int n, int n2) {
        if (n == n2) {
            return new INode[0];
        }
        INode[] iNodeArray = this.elements_.removeNodes(n, n2);
        if (this.getDocument() != null) {
            this.getDocument().childrenRemoved(this, iNodeArray, n);
        }
        return iNodeArray;
    }

    public void addChildren(int n, INode[] iNodeArray) {
        if (this.elements_ == null) {
            this.elements_ = new NodeList();
        }
        int n2 = 0;
        while (n2 < iNodeArray.length) {
            iNodeArray[n2].setParent(this);
            ++n2;
        }
        this.elements_.addNodes(n, iNodeArray);
        if (this.getDocument() != null) {
            this.getDocument().childrenAdded(this, iNodeArray, n);
        }
    }

    protected abstract INode createNode();
}

