/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceNode;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class OrderedNodeList
implements IModelToSourceMapping {
    private ArrayList nodes_;
    private NodePositionComparator nodeComparator_ = new NodePositionComparator();
    private SourcePositionComparator sourceComparator_ = new SourcePositionComparator();
    public static long time = 0L;
    public static String id = "";

    public OrderedNodeList() {
        this.nodes_ = new ArrayList(500);
    }

    public int size() {
        return this.nodes_.size();
    }

    public void remove(INode iNode) {
        this.removeNode(iNode);
    }

    public void removeNode(INode iNode) {
        ((AbstractCollection)this.nodes_).remove(iNode);
    }

    public void addNode(INode iNode) {
        if (this.size() == 0) {
            this.addNode(iNode, 0);
        } else {
            int[] nArray = this.find(this.nodeComparator_, iNode);
            if (nArray[1] == this.size()) {
                this.addNode(iNode, this.size());
                return;
            }
            if (this.nodeComparator_.compare(this.nodeAtIndex(nArray[1]), iNode) >= 0) {
                this.addNode(iNode, nArray[1]);
            } else {
                this.addNode(iNode, nArray[1] + 1);
            }
        }
    }

    protected void addNode(INode iNode, int n) {
        this.nodes_.add(n, iNode);
    }

    public INode nodeAtIndex(int n) {
        if (this.nodes_.size() == 0 || n < 0 || n >= this.size()) {
            return null;
        }
        return (INode)this.nodes_.get(n);
    }

    public INode nodeAt(int n, int n2, int n3) {
        if (this.size() == 0) {
            return null;
        }
        this.sourceComparator_.setForwardOffset(n3);
        this.sourceComparator_.setBackwardOffset(n2);
        Integer n4 = new Integer(n);
        int[] nArray = this.find(this.sourceComparator_, n4);
        if (nArray[0] < 0) {
            return null;
        }
        int n5 = nArray[1] - 1;
        INode iNode = null;
        while (n5 >= 0) {
            iNode = this.nodeAtIndex(n5);
            if (this.sourceComparator_.compare(iNode, n4) != 0) break;
            nArray[1] = n5--;
        }
        return this.nodeAtIndex(nArray[1]);
    }

    public INode nodeAt(Class clazz, int n, int n2, int n3) {
        if (this.size() == 0) {
            return null;
        }
        this.sourceComparator_.setForwardOffset(n3);
        this.sourceComparator_.setBackwardOffset(n2);
        Integer n4 = new Integer(n);
        int[] nArray = this.find(this.sourceComparator_, n4);
        if (nArray[0] < 0) {
            return null;
        }
        int n5 = nArray[1];
        INode iNode = null;
        INode iNode2 = null;
        while (n5 >= 0) {
            iNode2 = this.nodeAtIndex(n5);
            if (this.sourceComparator_.compare(iNode2, n4) != 0) break;
            if (clazz.getClass().isAssignableFrom(iNode2.getClass())) {
                nArray[1] = n5;
                iNode = iNode2;
            }
            --n5;
        }
        return iNode;
    }

    protected int[] find(Comparator comparator, Object object) {
        if (this.size() == 0) {
            return new int[]{-1, -1};
        }
        return this.find(comparator, object, 0, this.size() - 1);
    }

    protected int[] find(Comparator comparator, Object object, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 1) {
            if (comparator.compare(this.nodeAtIndex(n), object) == 0) {
                return new int[]{1, n};
            }
            if (comparator.compare(this.nodeAtIndex(n2), object) == 0) {
                return new int[]{1, n2};
            }
            if (comparator.compare(this.nodeAtIndex(n2), object) < 0) {
                return new int[]{-1, n2};
            }
            return new int[]{-1, n};
        }
        int n4 = comparator.compare(this.nodeAtIndex(n3 = n + n3 / 2), object);
        if (n4 == 0) {
            return new int[]{1, n3};
        }
        if (n4 > 0) {
            n2 = n3;
        } else {
            n = n3;
        }
        return this.find(comparator, object, n, n2);
    }

    public String getText(int n, int n2) {
        return null;
    }

    public ISourceNode nodeAfter(int n) {
        if (this.size() == 0) {
            return null;
        }
        this.sourceComparator_.reset();
        this.sourceComparator_.setForwardOffset(1);
        int[] nArray = this.find(this.sourceComparator_, new Integer(n));
        if (nArray[0] == 1) {
            return (ISourceNode)this.nodeAtIndex(nArray[1]);
        }
        if (nArray[1] >= this.size() - 1) {
            return null;
        }
        int n2 = nArray[1];
        INode iNode = null;
        INode iNode2 = null;
        while (n2 < this.size()) {
            iNode2 = this.nodeAtIndex(n2);
            if (iNode2.getStart() >= n) {
                iNode = iNode2;
                break;
            }
            ++n2;
        }
        return (ISourceNode)iNode;
    }

    public ISourceNode nodeAt(int n) {
        return (ISourceNode)this.nodeAt(n, 0, 0);
    }

    public ISourceNode nodeBefore(int n) {
        if (this.size() == 0) {
            return null;
        }
        this.sourceComparator_.reset();
        int[] nArray = this.find(this.sourceComparator_, new Integer(n));
        INode iNode = null;
        int n2 = nArray[1];
        while (n2 >= 0) {
            iNode = this.nodeAtIndex(n2);
            if (iNode.getStart() + iNode.getLength() <= n) {
                return (ISourceNode)iNode;
            }
            --n2;
        }
        return null;
    }

    public void shiftNodes(ISourceNode iSourceNode, int n) {
        if (this.size() == 0) {
            return;
        }
        int n2 = iSourceNode.getStart();
        int[] nArray = this.find(this.nodeComparator_, iSourceNode);
        INode iNode = null;
        int n3 = nArray[1];
        if (nArray[0] == 1) {
            ++n3;
        }
        while (n3 >= 0) {
            iNode = this.nodeAtIndex(n3);
            if (iNode.getStart() >= n2) break;
            --n3;
        }
        int n4 = n3 + 1;
        while (n4 < this.size()) {
            iNode = this.nodeAtIndex(n4);
            iNode.setStart(iNode.getStart() + n);
            ++n4;
        }
    }

    public void updateNodeLength(ISourceNode iSourceNode, int n) {
        int n2 = n - iSourceNode.getLength();
        this.shiftNodes(iSourceNode, n2);
        iSourceNode.setLength(n);
    }

    public boolean contains(INode iNode) {
        return this.find(this.nodeComparator_, iNode)[0] > 0;
    }

    public void clear() {
        this.nodes_.clear();
    }

    public SortedSet tailSet(INode iNode) {
        int[] nArray = this.find(this.nodeComparator_, iNode);
        nArray[1] = nArray[0] == 1 ? nArray[1] + 1 : (this.nodeComparator_.compare(this.nodeAtIndex(nArray[1]), iNode) > 0 ? 0 : nArray[1] + 1);
        int n = nArray[1];
        return new TreeSet(((AbstractList)this.nodes_).subList(n, this.size()));
    }

    public String toString() {
        String string = "{\n";
        int n = 0;
        while (n < this.size()) {
            string = String.valueOf(string) + "  (" + this.nodeAtIndex(n).getStart() + "," + this.nodeAtIndex(n).getLength() + ")" + this.nodeAtIndex(n) + "\n";
            ++n;
        }
        string = String.valueOf(string) + "}";
        return string;
    }

    public static void start(String string) {
        id = string;
        time = System.currentTimeMillis();
    }

    public static void stop() {
        double d = System.currentTimeMillis() - time;
        System.out.println(String.valueOf(id) + " took " + d / 100.0 + " second(s)");
    }

    class SourcePositionComparator
    implements Comparator {
        private int forwardOffset_;
        private int backwardOffset_;

        SourcePositionComparator() {
        }

        public void reset() {
            this.forwardOffset_ = 0;
            this.backwardOffset_ = 0;
        }

        public int compare(Object object, Object object2) {
            INode iNode = (INode)object;
            Integer n = (Integer)object2;
            int n2 = iNode.getStart();
            int n3 = n2 + iNode.getLength();
            int n4 = n;
            if (n2 <= n4 + this.backwardOffset_ && n3 > n4 - this.forwardOffset_) {
                return 0;
            }
            return n2 - (n4 + this.backwardOffset_);
        }

        public int getBackwardOffset() {
            return this.backwardOffset_;
        }

        public int getForwardOffset() {
            return this.forwardOffset_;
        }

        public void setBackwardOffset(int n) {
            this.backwardOffset_ = n;
        }

        public void setForwardOffset(int n) {
            this.forwardOffset_ = n;
        }
    }

    class NodePositionComparator
    implements Comparator {
        NodePositionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object2 == object) {
                return 0;
            }
            INode iNode = (INode)object;
            int n = -1;
            if (object2 instanceof ISourceNode && (n = iNode.getStart() - ((ISourceNode)object2).getStart()) == 0) {
                n = ((ISourceNode)object2).getLength() == iNode.getLength() ? 0 : iNode.getLength() - ((ISourceNode)object2).getLength();
            }
            return n;
        }
    }
}

