/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.Marker;
import butterfly.xmlview.model.TagInfo;
import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.incremental.MatchingScratchTagClass;
import butterfly.xmlview.model.incremental.ScratchTagConverter;
import butterfly.xmlview.model.incremental.ScratchTagMatcher;
import butterfly.xmlview.model.incremental.ScratchTagState;
import butterfly.xmlview.model.incremental.StatelessScratchTagParser;
import butterfly.xmlview.model.interfaces.ICDATANode;
import butterfly.xmlview.model.interfaces.IContextParent;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.INodeClass;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IScratchTagState;
import butterfly.xmlview.model.interfaces.IScratchable;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.ITagInfo;
import butterfly.xmlview.model.interfaces.IUnparsedSection;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ScratchTag
extends ValueNode
implements Comparable,
IScratchTag {
    public static final INodeClass CDATA_START_CLASS = new MatchingScratchTagClass(null, 7, false);
    public static final INodeClass CDATA_END_CLASS = new MatchingScratchTagClass(null, 8, false);
    public static final INodeClass COMMENT_START_CLASS = new MatchingScratchTagClass(null, 9, false, true);
    public static final INodeClass COMMENT_END_CLASS = new MatchingScratchTagClass(null, 10, false, true);
    private static final ScratchTagConverter tagConverter_ = new ScratchTagConverter();
    private IScratchTagState currentState_;
    private boolean locked_ = false;
    private Marker errorMarker_;
    private static Logger logger_;
    private static StatelessScratchTagParser tagChecker_;
    private boolean dirty_ = true;
    private TagInfo tagInfo_;
    private String errorMessage_;
    private IModelToSourceMapping mapping_;
    private ScratchTag splitTag_;
    public static TextState TEXT_STATE;
    public static OpenState OPEN_STATE;
    public static EndedState ENDED_STATE;
    public static ClosedState CLOSED_STATE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.ScratchTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        tagChecker_ = new StatelessScratchTagParser();
        TEXT_STATE = new TextState();
        OPEN_STATE = new OpenState();
        ENDED_STATE = new EndedState();
        CLOSED_STATE = new ClosedState();
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, int n, int n2) {
        this.mapping_ = iModelToSourceMapping;
        this.setStart(n);
        this.setLength(n2);
        this.currentState_ = TEXT_STATE;
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, IDocument iDocument, IScratchTagState iScratchTagState, int n, int n2) {
        this.setDocument(iDocument);
        this.mapping_ = iModelToSourceMapping;
        this.setStart(n);
        this.setLength(n2);
        this.currentState_ = iScratchTagState;
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, IScratchTagState iScratchTagState, int n, int n2) {
        this.mapping_ = iModelToSourceMapping;
        this.setStart(n);
        this.setLength(n2);
        this.currentState_ = iScratchTagState;
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, IXmlDocument iXmlDocument, IScratchTagState iScratchTagState, int n, int n2) {
        this.setDocument(iXmlDocument);
        this.mapping_ = iModelToSourceMapping;
        this.setStart(n);
        this.setLength(n2);
        this.currentState_ = iScratchTagState;
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, IXmlDocument iXmlDocument, ScratchTagState scratchTagState, int n, int n2) {
        this.setDocument(iXmlDocument);
        this.mapping_ = iModelToSourceMapping;
        this.setStart(n);
        this.setLength(n2);
        this.currentState_ = scratchTagState;
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, IXmlDocument iXmlDocument, String string, int n) {
        this(iModelToSourceMapping, n, string.length());
        this.setDocument(iXmlDocument);
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            this.handleInsert(n, string.substring(n2, n2 + 1));
            --n2;
        }
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, ScratchTagState scratchTagState, int n, int n2) {
        this.mapping_ = iModelToSourceMapping;
        this.setStart(n);
        this.setLength(n2);
        this.currentState_ = scratchTagState;
    }

    public ScratchTag(IModelToSourceMapping iModelToSourceMapping, String string, int n) {
        this(iModelToSourceMapping, n, string.length());
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            this.handleInsert(n, string.substring(n2, n2 + 1));
            --n2;
        }
    }

    private ISourceNode[] nodesBetween(ISourceNode iSourceNode, ISourceNode iSourceNode2) {
        Vector<ISourceNode> vector = new Vector<ISourceNode>();
        XmlDocument xmlDocument = (XmlDocument)this.getDocument();
        ISourceNode iSourceNode3 = xmlDocument.sourceNodeAfter(iSourceNode.getStart() + iSourceNode.getLength());
        while (!iSourceNode3.equals(iSourceNode2)) {
            if (!vector.contains(iSourceNode3)) {
                if (iSourceNode3 instanceof XmlDocument.EndTagPlaceHolder) {
                    ISourceElement iSourceElement = ((XmlDocument.EndTagPlaceHolder)iSourceNode3).getElement();
                    if (!vector.contains(iSourceElement)) {
                        vector.add(iSourceElement);
                    }
                } else {
                    vector.add(iSourceNode3);
                }
            }
            iSourceNode3 = xmlDocument.sourceNodeAfter(iSourceNode3.getStart() + iSourceNode3.getLength());
        }
        return vector.toArray(new ISourceNode[0]);
    }

    public boolean check() {
        if (!this.isLocked()) {
            if (this.errorMarker_ == null) {
                this.errorMarker_ = new ScratchMarker();
                this.addMarker(this.errorMarker_);
            }
            if (this.getLength() < 1) {
                this.getDocument().removeChild(this.getParent(), this);
                this.checkSplitTag();
                return true;
            }
            if (this.getText().trim().length() < 1) {
                this.getDocument().removeChild(this.getParent(), this);
                this.checkSplitTag();
                return true;
            }
            this.consumeSiblings();
            if (this.getCurrentState().equals(TEXT_STATE) && !(this.getParent() instanceof IDTDNode) && !(this.getParent() instanceof DocumentRoot)) {
                ValueNode valueNode = new ValueNode();
                valueNode.setData(this.getText());
                valueNode.setStart(this.getStart());
                valueNode.setLength(this.getLength());
                INode iNode = this.getParent();
                int n = iNode.indexOfChild(this);
                IDocument iDocument = this.getDocument();
                iDocument.removeChild(iNode, this);
                iDocument.addChild(iNode, valueNode, n);
                this.checkSplitTag();
                return true;
            }
            ITagInfo iTagInfo = this.getTagInfo();
            if (iTagInfo != null && iTagInfo.isValid()) {
                ScratchTagMatcher scratchTagMatcher = new ScratchTagMatcher(this);
                INode iNode = scratchTagMatcher.match();
                if (iNode instanceof ISourceElement) {
                    IScratchTag iScratchTag = null;
                    iScratchTag = iTagInfo.isEndTag() ? ((IScratchable)((Object)iNode)).scratch(false, ((ISourceElement)iNode).getEndTagStart()) : ((IScratchable)((Object)iNode)).scratch(false, ((ISourceElement)iNode).getStart());
                    boolean bl = this.check();
                    if (iScratchTag != null && iScratchTag instanceof ScratchTag) {
                        ((ScratchTag)iScratchTag).check();
                    }
                    return bl;
                }
                if (iNode != null) {
                    Object object;
                    Object object2;
                    IScratchTag iScratchTag = this;
                    IScratchTag iScratchTag2 = (IScratchTag)iNode;
                    if (iTagInfo.isEndTag()) {
                        iScratchTag = iScratchTag2;
                        iScratchTag2 = this;
                    }
                    ISourceNode iSourceNode = tagConverter_.convert(iScratchTag, iScratchTag2);
                    INode iNode2 = iScratchTag.getParent();
                    IDocument iDocument = iNode2.getDocument();
                    int n = iNode2.indexOfChild(iScratchTag);
                    int n2 = -1;
                    if (!iScratchTag2.equals(iScratchTag)) {
                        n2 = iNode2.indexOfChild(iScratchTag2);
                    }
                    boolean bl = false;
                    Vector<Object> vector = new Vector<Object>();
                    int n3 = -1;
                    int n4 = -1;
                    if (iScratchTag.getParent().equals(iScratchTag2.getParent())) {
                        n3 = n + 1;
                        n4 = n2;
                    } else {
                        bl = true;
                        object2 = (XmlDocument)iDocument;
                        object = ((XmlDocument)object2).sourceNodeAfter(iScratchTag.getStart() + iScratchTag.getLength());
                        while (!object.equals(iScratchTag2)) {
                            if (!vector.contains(object)) {
                                if (object instanceof XmlDocument.EndTagPlaceHolder) {
                                    ISourceElement iSourceElement = ((XmlDocument.EndTagPlaceHolder)object).getElement();
                                    if (!vector.contains(iSourceElement)) {
                                        vector.add(iSourceElement);
                                    }
                                } else {
                                    vector.add(object);
                                }
                            }
                            object = ((XmlDocument)object2).sourceNodeAfter(object.getStart() + object.getLength());
                        }
                    }
                    object2 = null;
                    if (bl) {
                        int n5 = 0;
                        while (n5 < vector.size()) {
                            object2 = (INode)vector.elementAt(n5);
                            ((IScratchable)object2).scratch(false, -1);
                            ++n5;
                        }
                        object = this.nodesBetween(iScratchTag, iScratchTag2);
                        int n6 = 0;
                        while (n6 < ((ISourceNode[])object).length) {
                            iDocument.removeChild(object[n6].getParent(), object[n6]);
                            ++n6;
                        }
                    }
                    if (!bl) {
                        iDocument.removeChild(iNode2, iScratchTag);
                        if (!iScratchTag2.equals(iScratchTag)) {
                            iDocument.removeChild(iNode2, iScratchTag2);
                        }
                        iNode2.getDocument().addChild(iNode2, iSourceNode, n);
                        if (n4 > n3 && n3 > -1) {
                            if (!(iSourceNode instanceof IUnparsedSection)) {
                                ((XmlDocument)iNode2.getDocument()).moveNodes(iNode2, n3, n4, iSourceNode, 0);
                            } else {
                                int n7 = n3;
                                while (n7 < n4) {
                                    iNode2.getDocument().removeChild(iNode2, iNode2.childAt(n7), false);
                                    ++n7;
                                }
                            }
                        }
                    }
                    if (bl) {
                        iNode2 = iScratchTag.getParent();
                        n = iNode2.indexOfChild(iScratchTag);
                        iDocument.removeChild(iNode2, iScratchTag);
                        iDocument.removeChild(iNode2, iScratchTag2);
                        iNode2.getDocument().addChild(iNode2, iSourceNode, n);
                    }
                    this.checkSplitTag();
                    int n8 = 0;
                    while (n8 < iSourceNode.childCount()) {
                        if (iSourceNode.childAt(n8) instanceof ScratchTag) {
                            ((ScratchTag)iSourceNode.childAt(n8)).check();
                        }
                        ++n8;
                    }
                    if (iSourceNode instanceof IContextParent) {
                        ((IContextParent)((Object)iSourceNode)).checkChildren();
                    }
                    return true;
                }
            }
        }
        this.checkSplitTag();
        return false;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof ISourceNode && (n = this.getStart() - ((ISourceNode)object).getStart()) == 0) {
            n = ((ISourceNode)object).getLength() == this.getLength() ? 0 : this.getLength() - ((ISourceNode)object).getLength();
        }
        return n;
    }

    public int compareTo(INode iNode) {
        int n = -1;
        n = this.getStart() - iNode.getStart();
        if (n == 0) {
            n = iNode.getLength() == this.getLength() ? 0 : this.getLength() - iNode.getLength();
        }
        return n;
    }

    public boolean completes(ScratchTag scratchTag) {
        return false;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public IScratchTagState getCurrentState() {
        return this.currentState_;
    }

    public Object getData() {
        return this.getText();
    }

    public String getErrorMessage() {
        if (this.errorMessage_ == null) {
            this.errorMessage_ = this.getCurrentState().getDescription();
        }
        return this.errorMessage_;
    }

    public IModelToSourceMapping getMapping() {
        return this.mapping_;
    }

    public INodeClass getMatchingNodeClass() {
        ITagInfo iTagInfo = this.getTagInfo();
        if (iTagInfo.isValid()) {
            INodeClass iNodeClass = null;
            switch (iTagInfo.getType()) {
                case 7: {
                    iNodeClass = CDATA_END_CLASS;
                    break;
                }
                case 8: {
                    iNodeClass = CDATA_START_CLASS;
                    break;
                }
                case 9: {
                    iNodeClass = COMMENT_END_CLASS;
                    break;
                }
                case 10: {
                    iNodeClass = COMMENT_START_CLASS;
                    break;
                }
                case 3: {
                    iNodeClass = new MatchingScratchTagClass(null, 3, false, true);
                    break;
                }
                case 2: {
                    iNodeClass = new MatchingScratchTagClass(this, 2, true);
                    break;
                }
                case 31: {
                    iNodeClass = new MatchingScratchTagClass(null, 31, false);
                    break;
                }
                case 4: {
                    iNodeClass = new MatchingScratchTagClass(null, 4, false, true);
                    break;
                }
                case 1: {
                    iNodeClass = new MatchingScratchTagClass(this, 0, true);
                    break;
                }
                case 15: {
                    iNodeClass = new MatchingScratchTagClass(null, 11, false);
                    break;
                }
                case 11: {
                    iNodeClass = new MatchingScratchTagClass(null, 15, false);
                    break;
                }
                case 16: {
                    iNodeClass = new MatchingScratchTagClass(null, 16, false);
                    break;
                }
                case 5: {
                    iNodeClass = new MatchingScratchTagClass(null, 5, false, true);
                    break;
                }
                case 13: {
                    iNodeClass = new MatchingScratchTagClass(null, 13, false, true);
                    break;
                }
                case 12: {
                    iNodeClass = new MatchingScratchTagClass(null, 12, false, true);
                    break;
                }
                case 6: {
                    iNodeClass = new MatchingScratchTagClass(null, 6, false, true);
                    break;
                }
                case 14: {
                    iNodeClass = new MatchingScratchTagClass(null, 14, false, true);
                    break;
                }
                default: {
                    iNodeClass = new MatchingScratchTagClass(this, 1, true);
                }
            }
            return iNodeClass;
        }
        return null;
    }

    public ITagInfo getTagInfo() {
        if (this.dirty_ || this.tagInfo_ == null) {
            this.parse();
            if (this.tagInfo_ != null) {
                this.setErrorMessage(this.tagInfo_.getErrorMessage());
            }
        }
        return this.tagInfo_;
    }

    public String getText() {
        if (this.getDocument() == null) {
            return "error getting text";
        }
        String string = this.getDocument().toString();
        this.getStart();
        this.getLength();
        string.length();
        if (this.getLength() < 1) {
            return "";
        }
        if (this.getDocument() == null) {
            return "no document";
        }
        if (this.getStart() < 0 || this.getLength() < 0) {
            return "";
        }
        if (this.getStart() + this.getLength() <= this.getStart()) {
            Exception exception = new Exception();
            exception.printStackTrace();
            return this.toString();
        }
        return this.getDocument().toString().substring(this.getStart(), this.getStart() + this.getLength());
    }

    public void handleDelete(int n, int n2) {
        int n3;
        IScratchTag iScratchTag;
        INode iNode;
        int n4;
        INode iNode2;
        this.dirty_ = true;
        this.currentState_ = this.currentState_.handleDelete(this, n - this.getStart());
        this.setErrorMessage(this.currentState_.getDescription());
        this.mapping_.updateNodeLength(this, this.getLength() - 1);
        if (this.currentState_.equals(OPEN_STATE) && (iNode2 = this.getParent()) != null && (n4 = iNode2.indexOfChild(this)) < iNode2.childCount() - 1 && (iNode = iNode2.childAt(n4 + 1)) instanceof IScratchTag && (iScratchTag = (IScratchTag)iNode).getCurrentState().equals(ENDED_STATE)) {
            n3 = iScratchTag.getLength() + this.getLength();
            this.setLength(n3);
            this.setCurrentState(CLOSED_STATE);
            this.getDocument().removeChild(iNode2, iNode, false);
        }
        if (this.currentState_.equals(ENDED_STATE) && (iNode2 = this.getParent()) != null && (n4 = iNode2.indexOfChild(this)) > 0 && (iNode = iNode2.childAt(n4 - 1)) instanceof IScratchTag && (iScratchTag = (IScratchTag)iNode).getCurrentState().equals(OPEN_STATE)) {
            n3 = iScratchTag.getLength() + this.getLength();
            this.setLength(n3);
            this.setStart(iScratchTag.getStart());
            this.setCurrentState(CLOSED_STATE);
            this.getDocument().removeChild(iNode2, iNode, false);
        }
        this.check();
    }

    public void handleInsert(int n, String string) {
        this.dirty_ = true;
        this.mapping_.updateNodeLength(this, this.getLength() + 1);
        this.currentState_ = this.currentState_.handleInsert(this, n - this.getStart(), string.charAt(0));
        this.setErrorMessage(this.currentState_.getDescription());
        this.check();
    }

    private boolean isCDATAStart(String string) {
        return string.startsWith("<![CDATA[");
    }

    public boolean isLocked() {
        return this.locked_;
    }

    public boolean isValidIdentifier(String string) {
        char c = ' ';
        int n = 0;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(Character.isLetterOrDigit(c) || c == ' ' || c != ' ' && c != '<' && c != '>' && c != '{' && c != '}' && c != ';' && c != '&' && c != '@' && c != '(' && c != ')' && c != '=' && c != '\"' && c != '[' && c != ']' && c != '!')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private TagInfo parse() {
        if (!this.isLocked()) {
            if (this.dirty_) {
                this.tagInfo_ = tagChecker_.parse(this);
                if (this.tagInfo_ != null) {
                    this.setErrorMessage(this.tagInfo_.getErrorMessage());
                }
                this.dirty_ = false;
            }
            return this.tagInfo_;
        }
        return null;
    }

    public void revalidateState() {
        this.setLocked(true);
        String string = this.getText();
        int n = string.length() - 1;
        while (n >= 0) {
            this.currentState_ = this.currentState_.handleInsert(this, n, string.charAt(n));
            this.setErrorMessage(this.currentState_.getDescription());
            this.check();
            --n;
        }
        this.setLocked(false);
    }

    protected void scratchElement(ISourceElement iSourceElement) {
        IDocument iDocument = this.getDocument();
        INode iNode = iSourceElement.getParent();
        int n = iNode.indexOfChild(iSourceElement);
        ScratchTag scratchTag = new ScratchTag(this.mapping_, iDocument, (IScratchTagState)CLOSED_STATE, iSourceElement.getStart(), iSourceElement.getLength());
        ScratchTag scratchTag2 = null;
        if (iSourceElement.getEndTagStart() > -1) {
            scratchTag2 = new ScratchTag(this.mapping_, iDocument, (IScratchTagState)CLOSED_STATE, iSourceElement.getEndTagStart(), iSourceElement.getEndTagLength());
        }
        int n2 = -1;
        iDocument.removeChild(iNode, iSourceElement);
        if (scratchTag != null) {
            iDocument.addChild(iNode, scratchTag, n);
            ++n2;
        }
        int n3 = 0;
        while (n3 < iSourceElement.childCount()) {
            iDocument.addChild(iNode, iSourceElement.childAt(n3), n + n3 + 1);
            ++n2;
            ++n3;
        }
        if (scratchTag2 != null) {
            iDocument.addChild(iNode, scratchTag2, n + n2 + 1);
        }
    }

    public void setCurrentState(IScratchTagState iScratchTagState) {
        this.currentState_ = iScratchTagState;
    }

    public void setErrorMessage(String string) {
        this.errorMessage_ = string;
    }

    public void setLocked(boolean bl) {
        this.locked_ = bl;
    }

    public void setMapping(IModelToSourceMapping iModelToSourceMapping) {
        this.mapping_ = iModelToSourceMapping;
    }

    public IScratchTag split(int n, IScratchTagState iScratchTagState) {
        if (n > this.getLength() - 1 || n < 0) {
            return null;
        }
        int n2 = this.getLength() - n;
        ScratchTag scratchTag = new ScratchTag(this.mapping_, iScratchTagState, this.getStart() + n, n2);
        this.setLength(this.getLength() - n2);
        INode iNode = this.getParent();
        int n3 = iNode.indexOfChild(this);
        this.getDocument().addChild(iNode, scratchTag, n3 + 1);
        this.splitTag_ = scratchTag;
        return scratchTag;
    }

    public String toString() {
        return "\"" + this.getText() + "\" : index:" + this.getStart() + " length:" + this.getLength() + " error:" + this.getErrorMessage();
    }

    private void checkSplitTag() {
        if (this.splitTag_ != null) {
            if (this.splitTag_.getDocument() != null && this.splitTag_.getParent() != null) {
                this.splitTag_.check();
            }
            this.splitTag_ = null;
        }
    }

    public void setLength(int n) {
        super.setLength(n);
        if (this.getDocument() != null && this.getParent() != null) {
            try {
                this.getDocument().nodeChanged(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean shouldConsume(INode iNode) {
        IScratchTagState iScratchTagState;
        if (iNode instanceof IValueNode && iNode instanceof ISourceNode && !(iNode instanceof IScratchTag) && !(iNode instanceof ICDATANode)) {
            return true;
        }
        return iNode instanceof IScratchTag && (iScratchTagState = ((IScratchTag)iNode).getCurrentState()).equals(TEXT_STATE);
    }

    private void consumeSiblings() {
        boolean bl = false;
        if (this.getCurrentState().equals(OPEN_STATE) || this.getCurrentState().equals(TEXT_STATE) || this.getCurrentState().equals(ENDED_STATE)) {
            int n;
            IScratchTag iScratchTag;
            int n2;
            INode iNode = this.getParent();
            INode iNode2 = null;
            int n3 = iNode.indexOfChild(this);
            Vector<INode> vector = new Vector<INode>();
            if (this.getCurrentState().equals(ENDED_STATE)) {
                n2 = n3 - 1;
                while (n2 >= 0) {
                    iNode2 = iNode.childAt(n2);
                    if (!this.shouldConsume(iNode2)) {
                        if (!(iNode2 instanceof IScratchTag) || (iScratchTag = (IScratchTag)iNode2).getCurrentState() != OPEN_STATE) break;
                        vector.add(iNode2);
                        bl = true;
                        break;
                    }
                    vector.add(iNode2);
                    --n2;
                }
            } else {
                n2 = n3 + 1;
                while (n2 < iNode.childCount()) {
                    iNode2 = iNode.childAt(n2);
                    if (!this.shouldConsume(iNode2)) {
                        if (!(iNode2 instanceof IScratchTag) || (iScratchTag = (IScratchTag)iNode2).getCurrentState() != ENDED_STATE || this.getCurrentState() != OPEN_STATE) break;
                        vector.add(iNode2);
                        bl = true;
                        break;
                    }
                    vector.add(iNode2);
                    ++n2;
                }
            }
            if (vector.size() < 1) {
                return;
            }
            n2 = this.getCurrentState().equals(ENDED_STATE) ? 0 : 1;
            int n4 = this.getLength();
            int n5 = this.getStart();
            ISourceNode iSourceNode = null;
            int n6 = 0;
            while (n6 < vector.size()) {
                iSourceNode = (ISourceNode)vector.elementAt(n6);
                if (n2 != 0) {
                    n4 = iSourceNode.getStart() + iSourceNode.getLength() - this.getStart();
                    this.getDocument().removeChild(iNode, iSourceNode);
                    this.setLength(n4);
                } else {
                    n = this.getStart() + this.getLength();
                    n5 = iSourceNode.getStart();
                    n4 = n - n5;
                    this.getDocument().removeChild(iNode, iSourceNode);
                    this.setStart(n5);
                    this.setLength(n4);
                }
                ++n6;
            }
            ISourceNode iSourceNode2 = null;
            if (n2 != 0) {
                iSourceNode2 = ((XmlDocument)this.getDocument()).sourceNodeAfter(this.getStart() + this.getLength());
                if (iSourceNode2 != null && !bl && iSourceNode2.getStart() != this.getStart() + this.getLength()) {
                    this.setLength(iSourceNode2.getStart() - this.getStart());
                }
            } else {
                iSourceNode2 = ((XmlDocument)this.getDocument()).sourceNodeBefore(this.getStart());
                if (iSourceNode2 != null && !bl && iSourceNode2.getStart() + iSourceNode2.getLength() != this.getStart()) {
                    n = this.getStart() - (iSourceNode2.getStart() + iSourceNode2.getLength());
                    this.setStart(iSourceNode2.getStart() + iSourceNode2.getLength());
                    this.setLength(this.getLength() + n);
                }
            }
        }
        if (bl) {
            this.setCurrentState(CLOSED_STATE);
            this.dirty_ = true;
        }
    }

    public IScratchTag scratch(boolean bl, int n) {
        return this;
    }

    public boolean isDirty() {
        return this.dirty_;
    }

    public void setDirty(boolean bl) {
        this.dirty_ = bl;
    }

    public ScratchTag getSplitTag() {
        return this.splitTag_;
    }

    public void setSplitTag(ScratchTag scratchTag) {
        this.splitTag_ = scratchTag;
    }

    class ScratchMarker
    extends Marker {
        public ScratchMarker() {
            super(null, -1, -1, false);
        }

        public String getMessage() {
            return ScratchTag.this.getErrorMessage();
        }
    }

    private static class TextState
    extends ScratchTagState {
        public static final String MSG = "Text is not allowed here";

        TextState() {
        }

        public IScratchTagState handleDelete(IScratchTag iScratchTag, int n) {
            return this;
        }

        public String toString() {
            return "TextState";
        }

        public String getDescription() {
            return MSG;
        }

        public IScratchTagState handleInsert(IScratchTag iScratchTag, int n, char c) {
            if (c == '<') {
                if (n == 0) {
                    return OPEN_STATE;
                }
                iScratchTag.split(n, OPEN_STATE);
                return TEXT_STATE;
            }
            if (c == '>') {
                if (n == iScratchTag.getLength() - 1) {
                    return ENDED_STATE;
                }
                iScratchTag.split(n + 1, TEXT_STATE);
                return ENDED_STATE;
            }
            return TEXT_STATE;
        }
    }

    private static class OpenState
    extends ScratchTagState {
        public static final String MSG = "The tag does not have a closing \">\"";

        OpenState() {
        }

        public IScratchTagState handleDelete(IScratchTag iScratchTag, int n) {
            if (n == 0) {
                return TEXT_STATE;
            }
            return this;
        }

        public String toString() {
            return "OpenState";
        }

        public String getDescription() {
            return MSG;
        }

        public IScratchTagState handleInsert(IScratchTag iScratchTag, int n, char c) {
            if (c != '<' && c != '>') {
                if (n == 0) {
                    iScratchTag.split(1, OPEN_STATE);
                    return TEXT_STATE;
                }
                return OPEN_STATE;
            }
            if (c == '<') {
                if (n == 0) {
                    iScratchTag.split(1, OPEN_STATE);
                    return OPEN_STATE;
                }
                iScratchTag.split(n, OPEN_STATE);
                return OPEN_STATE;
            }
            if (c == '>') {
                if (n == 0) {
                    iScratchTag.split(1, OPEN_STATE);
                    return ENDED_STATE;
                }
                if (n == iScratchTag.getLength() - 1) {
                    return CLOSED_STATE;
                }
                iScratchTag.split(n + 1, TEXT_STATE);
                return CLOSED_STATE;
            }
            return this;
        }
    }

    private static class EndedState
    extends ScratchTagState {
        public static final String MSG = "There is not a preceding \"<\"";

        EndedState() {
        }

        public IScratchTagState handleDelete(IScratchTag iScratchTag, int n) {
            if (n == iScratchTag.getLength() - 1) {
                return TEXT_STATE;
            }
            return this;
        }

        public String toString() {
            return "EndedState";
        }

        public String getDescription() {
            return MSG;
        }

        public IScratchTagState handleInsert(IScratchTag iScratchTag, int n, char c) {
            if (c != '<' && c != '>') {
                if (n == iScratchTag.getLength() - 1) {
                    iScratchTag.split(iScratchTag.getLength() - 1, TEXT_STATE);
                    return ENDED_STATE;
                }
                return ENDED_STATE;
            }
            if (c == '<') {
                if (n == 0) {
                    return CLOSED_STATE;
                }
                if (n == iScratchTag.getLength() - 1) {
                    iScratchTag.split(n, OPEN_STATE);
                    return ENDED_STATE;
                }
                iScratchTag.split(n, CLOSED_STATE);
                return TEXT_STATE;
            }
            if (c == '>') {
                if (n == iScratchTag.getLength() - 1) {
                    iScratchTag.split(iScratchTag.getLength() - 1, ENDED_STATE);
                    return ENDED_STATE;
                }
                iScratchTag.split(n + 1, ENDED_STATE);
                return ENDED_STATE;
            }
            return this;
        }
    }

    private static class ClosedState
    extends ScratchTagState {
        public static final String MSG = "The tag is not a self-terminating tag and is unmatched";

        ClosedState() {
        }

        public IScratchTagState handleDelete(IScratchTag iScratchTag, int n) {
            if (n == 0) {
                return ENDED_STATE;
            }
            if (n == iScratchTag.getLength() - 1) {
                return OPEN_STATE;
            }
            return this;
        }

        public String getDescription() {
            return MSG;
        }

        public String toString() {
            return "ClosedState";
        }

        public IScratchTagState handleInsert(IScratchTag iScratchTag, int n, char c) {
            if (c != '<' && c != '>') {
                if (n == iScratchTag.getLength() - 1) {
                    iScratchTag.split(iScratchTag.getLength() - 1, TEXT_STATE);
                    return CLOSED_STATE;
                }
                if (n == 0) {
                    iScratchTag.split(1, CLOSED_STATE);
                    return TEXT_STATE;
                }
            }
            if (c == '<') {
                if (n == 0) {
                    iScratchTag.split(1, CLOSED_STATE);
                    return OPEN_STATE;
                }
                if (n == iScratchTag.getLength() - 1) {
                    iScratchTag.split(n, OPEN_STATE);
                    return CLOSED_STATE;
                }
                iScratchTag.split(n, CLOSED_STATE);
                return OPEN_STATE;
            }
            if (c == '>') {
                if (n == iScratchTag.getLength() - 1) {
                    iScratchTag.split(iScratchTag.getLength() - 1, ENDED_STATE);
                    return CLOSED_STATE;
                }
                if (n == 0) {
                    iScratchTag.split(1, CLOSED_STATE);
                    return ENDED_STATE;
                }
                iScratchTag.split(n + 1, ENDED_STATE);
                return CLOSED_STATE;
            }
            return this;
        }
    }
}

