/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.interfaces.INode;
import java.util.Vector;

public class SortedNodeVector {
    private Vector nodes_ = new Vector();

    public void addNode(INode iNode) {
        if (this.size() == 0) {
            this.nodes_.add(iNode);
        } else {
            this.binaryInsert(iNode, 0, this.size());
        }
    }

    public void addNode(int n, INode iNode) {
        this.nodes_.add(n, iNode);
    }

    public void removeNode(INode iNode) {
        int n = this.indexOfNode(iNode);
        if (n > -1) {
            this.nodes_.removeElementAt(n);
        }
    }

    public int indexOfNode(INode iNode) {
        if (this.size() < 1) {
            return -1;
        }
        int n = this.binaryFind(iNode, 0, this.size());
        INode iNode2 = this.nodeAtIndex(n);
        if (iNode2.equals(iNode)) {
            return n;
        }
        return -1;
    }

    public int find(INode iNode) {
        if (this.size() == 0) {
            return -1;
        }
        int n = this.binaryFind(iNode, 0, this.size());
        return n;
    }

    protected int find(int n, int n2, int n3) {
        if (this.size() == 0) {
            return -1;
        }
        return this.binaryFind(n, n2, n3, 0, this.size());
    }

    protected int binaryFind(int n, int n2, int n3, int n4, int n5) {
        if (n4 == n5 - 1) {
            INode iNode = this.nodeAtIndex(n4);
            int n6 = iNode.getStart();
            if (n6 > n + n3) {
                return n4;
            }
            if (n6 + iNode.getLength() <= n - n2) {
                return n5;
            }
            return n4;
        }
        int n7 = n4 + (n5 - n4) / 2;
        INode iNode = this.nodeAtIndex(n7);
        int n8 = iNode.getStart();
        if (n8 > n + n3) {
            return this.binaryFind(n, n3, n2, n4, n7);
        }
        if (n8 + iNode.getLength() <= n - n2 && n8 != n) {
            return this.binaryFind(n, n3, n2, n7, n5);
        }
        return n7;
    }

    protected int binaryFind(INode iNode, int n, int n2) {
        if (n == n2 - 1) {
            INode iNode2 = this.nodeAtIndex(n);
            int n3 = iNode2.compareTo(iNode);
            if (n3 >= 0) {
                return n;
            }
            return n2;
        }
        int n4 = n + (n2 - n) / 2;
        INode iNode3 = this.nodeAtIndex(n4);
        int n5 = iNode3.compareTo(iNode);
        if (n5 > 0) {
            return this.binaryFind(iNode, n, n4);
        }
        if (n5 < 0) {
            return this.binaryFind(iNode, n4, n2);
        }
        return n4;
    }

    public INode nodeAt(int n, int n2, int n3) {
        int n4 = this.find(n, n3, n2);
        if (n4 == this.size() || n4 == -1) {
            return null;
        }
        INode iNode = this.nodeAtIndex(n4);
        int n5 = iNode.getStart();
        if (n5 > n + n2) {
            return null;
        }
        int n6 = iNode.getLength();
        if (n5 + n6 > n - n3) {
            --n4;
            INode iNode2 = iNode;
            while (n4 > -1) {
                iNode2 = this.nodeAtIndex(n4);
                n5 = iNode2.getStart();
                if ((n5 + (n6 = iNode2.getLength()) <= n - n3 || n5 > n + n2) && n5 != n) break;
                iNode = iNode2;
                --n4;
            }
            return iNode;
        }
        return null;
    }

    public synchronized INode nodeAt(Class clazz, int n, int n2, int n3) {
        int n4 = this.indexOfNodeAt(n, n2, n3);
        if (n4 == -1 || n4 == this.size()) {
            return null;
        }
        int n5 = -1;
        int n6 = -1;
        INode iNode = null;
        INode iNode2 = null;
        while (n4 < this.size() && n4 > -1) {
            iNode = this.nodeAtIndex(n4);
            n5 = iNode.getStart();
            if ((n5 + (n6 = iNode.getLength()) <= n - n3 || n5 > n + n2) && n5 != n) break;
            if (clazz.isAssignableFrom(iNode.getClass())) {
                iNode2 = iNode;
                break;
            }
            --n4;
        }
        return iNode2;
    }

    public int indexOfNodeAt(int n, int n2, int n3) {
        int n4;
        int n5 = this.find(n, n3, n2);
        if (n5 == this.size() || n5 == -1) {
            return -1;
        }
        INode iNode = this.nodeAtIndex(n5);
        int n6 = iNode.getStart();
        if (n6 + (n4 = iNode.getLength()) > n - n3 || n6 == n) {
            INode iNode2 = iNode;
            while (n5 > 0) {
                if ((iNode2 = this.nodeAtIndex(--n5)).getStart() == iNode.getStart()) {
                    iNode = iNode2;
                    continue;
                }
                ++n5;
                break;
            }
            return n5;
        }
        return -1;
    }

    public INode nodeAfter(int n) {
        int n2 = this.find(n + 1, 0, 0);
        if (n2 == this.size() || n2 == -1) {
            return null;
        }
        INode iNode = this.nodeAtIndex(n2);
        int n3 = iNode.getStart();
        n2 = this.firstAt(n2, n3, 0, 0);
        return this.nodeAtIndex(n2);
    }

    public INode nodeBefore(int n) {
        INode iNode;
        int n2 = this.find(n - 1, 0, 0);
        if (n2 == -1) {
            return null;
        }
        if (n2 == this.size()) {
            if (n2 == 0) {
                return null;
            }
            --n2;
        }
        if ((iNode = this.nodeAtIndex(n2 = this.firstAt(n2, this.nodeAtIndex(n2).getStart(), 0, 0))).getStart() < n) {
            return iNode;
        }
        if (n2 == 0) {
            return null;
        }
        iNode = this.nodeAtIndex(n2 - 1);
        return this.nodeAtIndex(this.firstAt(n2 - 1, iNode.getStart(), 0, 0));
    }

    public int firstAt(int n, int n2, int n3, int n4) {
        int n5;
        if (n == -1 || n == this.size()) {
            return -1;
        }
        INode iNode = this.nodeAtIndex(n);
        int n6 = iNode.getStart();
        if (n6 + (n5 = iNode.getLength()) > n2 - n4 || n6 == n2) {
            INode iNode2 = iNode;
            int n7 = n;
            while (n7 > -1) {
                iNode2 = this.nodeAtIndex(n7);
                n6 = iNode2.getStart();
                if ((n6 + (n5 = iNode2.getLength()) <= n2 - n4 || n6 > n2 + n3) && n6 != n2) break;
                iNode = iNode2;
                n = n7--;
            }
            return n;
        }
        return -1;
    }

    protected void binaryInsert(INode iNode, int n, int n2) {
        if (n == n2 - 1) {
            if (this.nodeAtIndex(n).compareTo(iNode) < 0) {
                this.nodes_.add(n2, iNode);
            } else {
                this.nodes_.add(n, iNode);
            }
        } else {
            int n3 = n + (n2 - n) / 2;
            INode iNode2 = this.nodeAtIndex(n3);
            int n4 = iNode2.compareTo(iNode);
            if (n4 > 0) {
                this.binaryInsert(iNode, n, n3);
            } else if (n4 < 0) {
                this.binaryInsert(iNode, n3, n2);
            } else {
                this.nodes_.add(n3, iNode);
            }
        }
    }

    public INode nodeAtIndex(int n) {
        return (INode)this.nodes_.elementAt(n);
    }

    public boolean containsNode(INode iNode) {
        int n = this.indexOfNodeAt(iNode.getStart(), 0, 0);
        return n > -1 && (n = this.nodes_.indexOf(iNode, n)) > -1;
    }

    public int size() {
        return this.nodes_.size();
    }

    public void clear() {
        this.nodes_.clear();
    }

    public static void main(String[] stringArray) {
        SortedNodeVector sortedNodeVector = new SortedNodeVector();
        double d = 50.0;
        double d2 = 0.0;
        int n = 100;
        INode[] cfr_ignored_0 = new INode[n];
        int n2 = 0;
        while (n2 < n) {
            double d3 = Math.random();
            int n3 = (int)((d - d2) * d3 + d2);
            d3 = Math.random();
            int cfr_ignored_1 = (int)((d - d2) * d3 + d2);
            ValueNode valueNode = new ValueNode();
            valueNode.setData("id:" + n2);
            valueNode.setStart(n3);
            valueNode.setLength(1);
            sortedNodeVector.addNode(valueNode);
            ++n2;
        }
        n2 = 0;
        while (n2 < sortedNodeVector.size()) {
            INode iNode = sortedNodeVector.nodeAtIndex(n2);
            System.out.println(String.valueOf(n2) + " : " + sortedNodeVector.nodeAtIndex(n2) + " start:" + sortedNodeVector.nodeAtIndex(n2).getStart() + " length:" + sortedNodeVector.nodeAtIndex(n2).getLength());
            INode iNode2 = sortedNodeVector.nodeAfter(iNode.getStart());
            INode iNode3 = sortedNodeVector.nodeBefore(iNode.getStart());
            boolean bl = iNode2 == null || iNode2.getStart() > iNode.getStart();
            boolean bl2 = iNode3 == null || iNode3.getStart() < iNode.getStart();
            INode iNode4 = null;
            int n4 = sortedNodeVector.indexOfNodeAt(iNode.getStart(), 0, 0);
            if (n4 > -1) {
                iNode4 = sortedNodeVector.nodeAtIndex(n4);
            }
            System.out.println("node at (i) = " + iNode4);
            System.out.println("node at = " + sortedNodeVector.nodeAt(iNode.getStart(), 0, 0));
            System.out.println("node after=" + iNode2);
            System.out.println("node before=" + iNode3);
            System.out.println("contains=" + sortedNodeVector.containsNode(iNode));
            System.out.println("index of node=" + (n2 == sortedNodeVector.indexOfNode(iNode)));
            if (!bl || !bl2) {
                System.out.println("test failed");
            }
            ++n2;
        }
        INode iNode = null;
        while (sortedNodeVector.size() > 0) {
            iNode = sortedNodeVector.nodeAtIndex(sortedNodeVector.size() / 2);
            sortedNodeVector.removeNode(iNode);
            System.out.println("removed=" + !sortedNodeVector.containsNode(iNode));
        }
        System.out.println("done");
    }

    public Object[] toArray(Object[] objectArray) {
        return this.nodes_.toArray(objectArray);
    }
}

