/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.interfaces.IAttributeInfo;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.ITagInfo;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class TagInfo
implements ITagInfo {
    private String namespace_;
    private Hashtable attributeLookup_ = new Hashtable(1);
    private boolean valid_;
    private String name_;
    private int type_ = 0;
    private Vector attributes_ = new Vector(0);
    private String errorMessage_;
    private String data_;
    private Vector markers_ = new Vector(0);
    private Properties props_ = new Properties();

    public TagInfo(int n) {
        this.type_ = n;
    }

    public void addAttribute(IAttributeInfo iAttributeInfo) {
        this.attributeLookup_.put(iAttributeInfo.getName(), iAttributeInfo);
        this.attributes_.add(iAttributeInfo);
    }

    public IAttributeInfo attributeAt(int n) {
        return (IAttributeInfo)this.attributes_.elementAt(n);
    }

    public int attributeCount() {
        return this.attributes_.size();
    }

    public IAttributeInfo getAttribute(String string) {
        return (IAttributeInfo)this.attributeLookup_.get(string);
    }

    public void clearAttributes() {
        this.attributeLookup_.clear();
        this.attributes_.clear();
    }

    public String getData() {
        return this.data_;
    }

    public String getErrorMessage() {
        return this.errorMessage_;
    }

    public String getName() {
        switch (this.type_) {
            case 7: {
                return "<![CDATA[";
            }
            case 8: {
                return "]]>";
            }
            case 9: {
                return "<!--";
            }
            case 10: {
                return "-->";
            }
            case 31: {
                return "xml";
            }
        }
        return this.name_;
    }

    public String getProperty(String string) {
        return this.props_.getProperty(string);
    }

    public int getType() {
        return this.type_;
    }

    public boolean isEndTag() {
        return this.type_ == 8 || this.type_ == 1 || this.type_ == 10 || this.type_ == 15;
    }

    public boolean isValid() {
        return this.valid_;
    }

    public void removeAttribute(IAttributeInfo iAttributeInfo) {
        this.attributes_.remove(iAttributeInfo);
    }

    public void setData(String string) {
        this.data_ = string;
    }

    public void setErrorMessage(String string) {
        this.errorMessage_ = string;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public void setProperty(String string, String string2) {
        if (string2 != null && string != null) {
            this.props_.setProperty(string, string2);
        }
    }

    public void setType(int n) {
        this.type_ = n;
    }

    public void setValid(boolean bl) {
        this.valid_ = bl;
    }

    public boolean isSelfTerminating() {
        return this.type_ == 2 || this.type_ == 13 || this.type_ == 3 || this.type_ == 12 || this.type_ == 6 || this.type_ == 14;
    }

    public String getNamespace() {
        return this.namespace_;
    }

    public void setNamespace(String string) {
        this.namespace_ = string;
    }

    public void addMarker(IMarker iMarker) {
        this.markers_.add(iMarker);
    }

    public void removeMarker(IMarker iMarker) {
        this.markers_.remove(iMarker);
    }

    public IMarker[] getMarkers() {
        return this.markers_.toArray(new IMarker[0]);
    }
}

