/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model;

import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.DTDDeclaration;
import butterfly.xmlview.model.DocumentDeclaration;
import butterfly.xmlview.model.DocumentEvent;
import butterfly.xmlview.model.DocumentGeneratedSourceEvent;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.Marker;
import butterfly.xmlview.model.NamespacePrefixMapping;
import butterfly.xmlview.model.Node;
import butterfly.xmlview.model.PrefixMappingWarningMarker;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.SortedNodeVector;
import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.incremental.ScratchPad;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IAttributeInfo;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentSourceEvent;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.IMultiNode;
import butterfly.xmlview.model.interfaces.INamespacePrefixMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IScratchable;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.ITagInfo;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.model.validation.CompoundValidationDocument;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.IGrammarFactory;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import butterfly.xmlview.parsers.XmlViewParser;
import butterfly.xmlview.util.FileSystem;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class XmlDocument
extends AbstractValidatedDocument
implements IXmlDocument,
IModelToSourceMapping {
    private IGrammarFactory grammarFactory_;
    private boolean addIncrementally_ = false;
    private int lastAdd_ = -1;
    private boolean preserveChildren_ = false;
    private Hashtable nodePrefixes_ = new Hashtable(1);
    private Hashtable namespaces_ = new Hashtable();
    private ScratchPad scratchPad_;
    private DocumentRoot root_;
    private SortedNodeVector nodes_ = new SortedNodeVector();
    private SortedNodeVector scratchTags_ = new SortedNodeVector();
    private StringBuffer source_;
    private Hashtable prefixes_ = new Hashtable();
    public static final String DEFAULT_SCHEMA_LOCATION_ATTRIBUTE = "noNamespaceSchemaLocation";
    public static final String SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private boolean isValid_ = true;
    private boolean modelIsValid_ = false;
    private boolean loading_ = false;
    public static final String XPATH_SEPERATOR = "/";
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.XmlDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public XmlDocument() {
        super("text/xml");
        this.setDescription("Xml Document");
        this.source_ = new StringBuffer(1000);
        this.modelIsValid_ = true;
        this.scratchPad_ = new ScratchPad(this);
        this.root_ = new DocumentRoot();
        this.root_.setDocument(this);
        DocumentDeclaration documentDeclaration = new DocumentDeclaration();
        documentDeclaration.setProperty("version", "1.0");
        this.addChild(this.root_, documentDeclaration, 0, true);
    }

    public XmlDocument(String string) {
        super("text/xml");
        this.setDescription("Xml Document");
        this.source_ = new StringBuffer(string);
        this.scratchPad_ = new ScratchPad(this);
    }

    public void addChild(INode iNode, INode iNode2, int n) {
        this.addChild(iNode, iNode2, n, false);
    }

    public void addChild(INode iNode, INode iNode2, int n, boolean bl) {
        if (bl) {
            this.queueEvents();
        }
        if (bl && iNode instanceof ISourceNode && iNode2 instanceof ISourceNode) {
            ISourceNode iSourceNode;
            ISourceNode iSourceNode2;
            this.setDirty(true);
            int n2 = -1;
            if (iNode instanceof IElement && iNode instanceof ISourceElement && (iSourceNode2 = (ISourceElement)iNode).getEndTagStart() < 0) {
                this.makeChildCapable(iNode);
            }
            if (n > 0) {
                iSourceNode2 = (ISourceNode)iNode.childAt(n - 1);
                n2 = iSourceNode2 instanceof ISourceElement ? ((iSourceNode = iSourceNode2).getEndTagStart() > -1 ? iSourceNode.getEndTagStart() + iSourceNode.getEndTagLength() : iSourceNode.getStart() + iSourceNode.getLength()) : iSourceNode2.getStart() + iSourceNode2.getLength();
            }
            if (n2 < 0) {
                n2 = ((ISourceNode)iNode).getStart() + ((ISourceNode)iNode).getLength();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = this.generateSource(n2, (ISourceNode)iNode2);
            iSourceNode = new ValueNode();
            ((Node)iSourceNode).setStart(n2);
            this.shiftNodes(iSourceNode, n3 - n2);
            String string = this.source_.substring(n2, n3);
            int cfr_ignored_0 = n3 - n2;
            DocumentGeneratedSourceEvent documentGeneratedSourceEvent = new DocumentGeneratedSourceEvent(this, n2, 0, string);
            this.fireDocumentSourceEvent(documentGeneratedSourceEvent);
        }
        super.addChild(iNode, iNode2, n);
        if (bl) {
            this.tidy(iNode);
            this.unQueueEvents();
        }
        if (iNode2 instanceof DTDDeclaration && n > 0 && !(iNode instanceof DocumentRoot)) {
            ((DocumentDeclaration)iNode2).scratch(false, -1);
        }
    }

    public void makeChildCapable(INode iNode) {
        try {
            ISourceElement iSourceElement;
            if (iNode instanceof ISourceElement && (iSourceElement = (ISourceElement)iNode).getEndTagStart() < 0) {
                Object object;
                int n = iSourceElement.getStart() + iSourceElement.getLength();
                int n2 = this.source_.lastIndexOf(XPATH_SEPERATOR, n);
                String string = iSourceElement.toEndString();
                if (n2 > -1) {
                    this.source_.replace(n2, n2 + 1, " ");
                    object = new DocumentGeneratedSourceEvent(this, n2, 1, " ");
                    this.fireDocumentSourceEvent((IDocumentSourceEvent)object);
                }
                this.source_.insert(n, string);
                object = new ValueNode();
                ((Node)object).setStart(n);
                this.shiftNodes((ISourceNode)object, string.length());
                iSourceElement.setEndTagLength(string.length());
                iSourceElement.setEndTagStart(n);
                EndTagPlaceHolder endTagPlaceHolder = new EndTagPlaceHolder(iSourceElement);
                this.nodes_.addNode(endTagPlaceHolder);
                DocumentGeneratedSourceEvent documentGeneratedSourceEvent = new DocumentGeneratedSourceEvent(this, n, 0, string);
                this.fireDocumentSourceEvent(documentGeneratedSourceEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildElementStructure() {
    }

    public void childAdded(INode iNode, INode iNode2, int n) {
        this.registerNode(iNode2);
        if (!this.loading_) {
            super.childAdded(iNode, iNode2, n);
        }
    }

    public void childRemoved(INode iNode, INode iNode2, int n) {
        this.unRegisterNode(iNode2, !this.preserveChildren_);
        if (!this.loading_) {
            super.childRemoved(iNode, iNode2, n);
        }
    }

    private int generateSource(int n, ISourceNode iSourceNode) {
        ISourceElement iSourceElement;
        if (iSourceNode.childCount() > 0 && iSourceNode instanceof ISourceElement) {
            ((ISourceElement)iSourceNode).setEndTagStart(0);
        }
        String string = iSourceNode.toString();
        iSourceNode.setStart(n);
        iSourceNode.setLength(string.length());
        this.source_.insert(n, string);
        int n2 = iSourceNode.getStart() + iSourceNode.getLength();
        int n3 = 0;
        while (n3 < iSourceNode.childCount()) {
            if (iSourceNode.childAt(n3) instanceof ISourceNode) {
                ISourceNode iSourceNode2 = (ISourceNode)iSourceNode.childAt(n3);
                n2 = this.generateSource(n2, iSourceNode2);
            }
            ++n3;
        }
        if (iSourceNode instanceof ISourceElement && ((iSourceElement = (ISourceElement)iSourceNode).getEndTagStart() > -1 || iSourceElement.childCount() > 0)) {
            string = iSourceElement.toEndString();
            iSourceElement.setEndTagStart(n2);
            iSourceElement.setEndTagLength(string.length());
            this.source_.insert(n2, string);
            n2 += string.length();
        }
        return n2;
    }

    private String getChildXPath(IElement iElement) {
        String string = iElement.getName();
        IMultiNode iMultiNode = (IMultiNode)iElement.getParent();
        if (iMultiNode == null) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < iMultiNode.childCount()) {
            if (iMultiNode.childAt(n2).equals(iElement)) break;
            if (iMultiNode.childAt(n2) instanceof IElement && ((IElement)iMultiNode.childAt(n2)).getName().equals(iElement.getName())) {
                ++n;
            }
            ++n2;
        }
        return String.valueOf(string) + "[" + n + "]";
    }

    public IElementStructure getElementStructure(String string, String string2) {
        return this.getValidationDocument().getElementStructure(string, string2);
    }

    public EndTagPlaceHolder getEndTagPlaceHolder(ISourceElement iSourceElement) {
        if (iSourceElement.getEndTagStart() < 0) {
            return null;
        }
        EndTagPlaceHolder endTagPlaceHolder = (EndTagPlaceHolder)this.sourceNodeAt(iSourceElement.getEndTagStart(), 0, 0);
        if (endTagPlaceHolder == null) {
            endTagPlaceHolder = new EndTagPlaceHolder(iSourceElement);
        }
        return endTagPlaceHolder;
    }

    public INode getNode(INode iNode, String string) {
        if (!(iNode instanceof IMultiNode)) {
            return null;
        }
        return this.getNodeWithXPath((IMultiNode)iNode, string);
    }

    public INode getNode(String string) {
        return this.getNodeWithXPath(string);
    }

    public INode getNodeWithXPath(IMultiNode iMultiNode, String string) {
        if (string == null) {
            return null;
        }
        IMultiNode iMultiNode2 = iMultiNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, XPATH_SEPERATOR, false);
        String string2 = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            if (iMultiNode2 == null) {
                return null;
            }
            string2 = stringTokenizer.nextToken();
            string3 = this.getPathName(string2);
            bl = this.isTextPath(string2);
            if (bl) {
                n2 = this.getTextPathIndex(string2);
            }
            n = this.getPathIndex(string2);
            bl2 = false;
            if (string2.equals("..")) {
                iMultiNode2 = (IMultiNode)iMultiNode2.getParent();
                continue;
            }
            if (string2.equals(".")) continue;
            int n3 = 0;
            while (n3 < iMultiNode2.childCount()) {
                IElement iElement;
                if (iMultiNode2.childAt(n3) instanceof IElement && (iElement = (IElement)iMultiNode2.childAt(n3)).getName().equals(string3)) {
                    if (n == 0) {
                        if (bl) {
                            return this.getNthValueNode(iElement, n2);
                        }
                        bl2 = true;
                        iMultiNode2 = iElement;
                        break;
                    }
                    --n;
                }
                ++n3;
            }
            if (bl2) continue;
            return null;
        }
        return iMultiNode2;
    }

    public INode getNodeWithXPath(INode iNode, String string) {
        if (string == null) {
            return null;
        }
        INode iNode2 = iNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, XPATH_SEPERATOR, false);
        String string2 = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            if (iNode2 == null) {
                return null;
            }
            string2 = stringTokenizer.nextToken();
            string3 = this.getPathName(string2);
            bl = this.isTextPath(string2);
            if (bl) {
                n2 = this.getTextPathIndex(string2);
            }
            n = this.getPathIndex(string2);
            bl2 = false;
            if (string2.equals("..")) {
                iNode2 = iNode2.getParent();
                continue;
            }
            if (string2.equals(".")) continue;
            int n3 = 0;
            while (n3 < iNode2.childCount()) {
                IElement iElement;
                if (iNode2.childAt(n3) instanceof IElement && (iElement = (IElement)iNode2.childAt(n3)).getName().equals(string3)) {
                    if (n == 0) {
                        if (bl) {
                            return this.getNthValueNode(iElement, n2);
                        }
                        bl2 = true;
                        iNode2 = iElement;
                        break;
                    }
                    --n;
                }
                ++n3;
            }
            if (bl2) continue;
            return null;
        }
        return iNode2;
    }

    public INode getNodeWithXPath(String string) {
        if (string == null) {
            return null;
        }
        INode iNode = this.getRoot();
        if (!(iNode instanceof IMultiNode)) {
            return null;
        }
        IMultiNode iMultiNode = (IMultiNode)iNode;
        StringTokenizer stringTokenizer = new StringTokenizer(string, XPATH_SEPERATOR, false);
        String string2 = null;
        int n = 0;
        int n2 = 0;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            string3 = this.getPathName(string2);
            bl = this.isTextPath(string2);
            if (bl) {
                n2 = this.getTextPathIndex(string2);
            }
            n = this.getPathIndex(string2);
            bl2 = false;
            int n3 = 0;
            while (n3 < iMultiNode.childCount()) {
                IElement iElement;
                if (iMultiNode.childAt(n3) instanceof IElement && (iElement = (IElement)iMultiNode.childAt(n3)).getName().equals(string3)) {
                    if (n == 0) {
                        if (bl) {
                            return this.getNthValueNode(iElement, n2);
                        }
                        bl2 = true;
                        iMultiNode = iElement;
                        break;
                    }
                    --n;
                }
                ++n3;
            }
            if (bl2) continue;
            return null;
        }
        return iMultiNode;
    }

    private String getNodeXPath(INode iNode) {
        if (iNode instanceof IElement) {
            return this.getXPath((IElement)iNode);
        }
        if (iNode instanceof IValueNode) {
            return this.getXPath((IValueNode)iNode);
        }
        return null;
    }

    private IValueNode getNthValueNode(IMultiNode iMultiNode, int n) {
        if (iMultiNode.childCount() <= n) {
            return null;
        }
        int n2 = 0;
        while (n2 < iMultiNode.childCount()) {
            if (iMultiNode.childAt(n2) instanceof IValueNode) {
                if (n == 0) {
                    return (IValueNode)iMultiNode.childAt(n2);
                }
            } else if (iMultiNode.childAt(n2) instanceof IElement) {
                --n;
            }
            if (n < 0) {
                return null;
            }
            ++n2;
        }
        return null;
    }

    public String getPath(INode iNode) {
        return this.getNodeXPath(iNode);
    }

    public int getPathIndex(String string) {
        int n;
        int n2;
        int n3 = 0;
        if (string.indexOf("[") > -1 && (n2 = string.indexOf("[")) < (n = string.indexOf("]"))) {
            String string2 = string.substring(n2 + 1, n);
            try {
                n3 = Integer.parseInt(string2);
                return n3;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return n3;
    }

    private String getPathName(String string) {
        if (string.indexOf("[") > -1) {
            return string.substring(0, string.indexOf("["));
        }
        if (string.indexOf("::") > -1) {
            return string.substring(0, string.indexOf("::"));
        }
        return string;
    }

    public INode getRoot() {
        if (this.root_ == null) {
            this.loading_ = true;
            this.root_ = new DocumentRoot();
            this.root_.setDocument(this);
            XmlViewParser xmlViewParser = new XmlViewParser();
            try {
                System.currentTimeMillis();
                xmlViewParser.parse(this);
                this.modelIsValid_ = true;
                if (this.validationIsOn()) {
                    this.validateChildren(this.getRoot(), true);
                }
            }
            catch (Exception exception) {
                logger_.debug((Object)"Error synchronizing xml model.", (Throwable)exception);
            }
            this.loading_ = false;
        }
        return this.root_;
    }

    public ScratchPad getScratchPad() {
        return this.scratchPad_;
    }

    public ScratchTag[] getScratchTags() {
        return (ScratchTag[])this.scratchTags_.toArray(new ScratchTag[0]);
    }

    public String getSource() {
        return this.source_.toString();
    }

    public StringBuffer getSourceBuffer() {
        return this.source_;
    }

    public String getText(int n, int n2) {
        return this.source_.substring(n, n + n2);
    }

    private int getTextPathIndex(String string) {
        int n;
        int n2;
        int n3 = 0;
        if (string.indexOf("::text()") > -1) {
            string = string.substring(string.indexOf("::text()"));
        }
        if (string.indexOf("[") > -1 && (n2 = string.indexOf("[")) < (n = string.indexOf("]"))) {
            String string2 = string.substring(n2 + 1, n);
            try {
                n3 = Integer.parseInt(string2);
                return n3;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return n3;
    }

    private String getXPath(IElement iElement) {
        String string = new String("");
        while (iElement != null) {
            string = XPATH_SEPERATOR + this.getChildXPath(iElement) + string;
            INode iNode = iElement.getParent();
            while (!(iNode instanceof IElement)) {
                if ((iNode = iNode.getParent()) == null) break;
            }
            if (iNode == null) break;
            iElement = (IElement)iNode;
        }
        return string;
    }

    private String getXPath(IValueNode iValueNode) {
        String string = null;
        INode iNode = iValueNode.getParent();
        while (!(iNode instanceof IElement) && iNode != null) {
            iNode = iNode.getParent();
        }
        if (iNode == null) {
            return null;
        }
        string = this.getXPath((IElement)iNode);
        string = String.valueOf(string) + "::text()";
        return string;
    }

    public void insertString(int n, String string) {
        try {
            if (this.locked()) {
                return;
            }
            this.scratchPad_.handleInsert(n, string);
            this.modelIsValid_ = false;
            this.setDirty(true);
            super.insertString(n, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isTextPath(String string) {
        return string.indexOf("::text()") > -1;
    }

    public boolean isValid() {
        return this.isValid_;
    }

    public ISourceNode nodeAfter(int n) {
        ISourceNode iSourceNode = this.sourceNodeAfter(n);
        if (iSourceNode instanceof EndTagPlaceHolder) {
            iSourceNode = ((EndTagPlaceHolder)iSourceNode).getElement();
        }
        return iSourceNode;
    }

    public ISourceNode nodeAt(int n) {
        return this.nodeAt(n, 0, 0);
    }

    public ISourceNode nodeAt(int n, int n2, int n3) {
        ISourceNode iSourceNode = this.sourceNodeAt(n, n2, n3);
        if (iSourceNode instanceof EndTagPlaceHolder) {
            iSourceNode = ((EndTagPlaceHolder)iSourceNode).getElement();
        }
        return iSourceNode;
    }

    public INode[] sourceNodesWithin(int n, int n2) {
        int n3 = this.nodes_.indexOfNodeAt(n, 0, 0);
        INode iNode = null;
        Vector<INode> vector = new Vector<INode>();
        int n4 = this.nodes_.size();
        int n5 = -1;
        int n6 = -1;
        if (n3 > -1) {
            int n7 = n3;
            while (n7 < n4) {
                iNode = this.nodes_.nodeAtIndex(n7);
                n5 = iNode.getStart();
                n6 = iNode.getLength();
                if (n5 != n && (n5 >= n || n5 + n6 <= n) && (n5 <= n || n5 >= n + n2)) break;
                vector.add(iNode);
                ++n7;
            }
        }
        return vector.toArray(new INode[0]);
    }

    public ISourceNode nodeBefore(int n) {
        ISourceNode iSourceNode = this.sourceNodeBefore(n);
        if (iSourceNode instanceof EndTagPlaceHolder) {
            iSourceNode = ((EndTagPlaceHolder)iSourceNode).getElement();
        }
        return iSourceNode;
    }

    public ISourceNode parentOf(int n) {
        ISourceNode iSourceNode = this.sourceParent(n);
        if (iSourceNode instanceof EndTagPlaceHolder) {
            iSourceNode = ((EndTagPlaceHolder)iSourceNode).getElement();
        }
        return iSourceNode;
    }

    private int addAll(INode iNode, int n) {
        this.nodes_.addNode(n, iNode);
        if (iNode instanceof IScratchTag) {
            this.scratchTags_.addNode(iNode);
        }
        int n2 = 0;
        while (n2 < iNode.childCount()) {
            n = this.addAll(iNode.childAt(n2), n + 1);
            ++n2;
        }
        if (iNode instanceof ISourceElement && ((ISourceElement)iNode).getEndTagStart() > -1) {
            EndTagPlaceHolder endTagPlaceHolder = new EndTagPlaceHolder((ISourceElement)iNode);
            this.nodes_.addNode(++n, endTagPlaceHolder);
        }
        return n;
    }

    private void addAll(INode iNode) {
        this.nodes_.addNode(iNode);
        if (iNode instanceof IScratchTag) {
            this.scratchTags_.addNode(iNode);
        }
        int n = 0;
        while (n < iNode.childCount()) {
            this.addAll(iNode.childAt(n));
            ++n;
        }
        if (iNode instanceof ISourceElement && ((ISourceElement)iNode).getEndTagStart() > -1) {
            EndTagPlaceHolder endTagPlaceHolder = new EndTagPlaceHolder((ISourceElement)iNode);
            this.nodes_.addNode(endTagPlaceHolder);
        }
    }

    public void registerNode(INode iNode) {
        this.registerNode(iNode, false);
    }

    public void registerNode(INode iNode, boolean bl) {
        if (this.nodes_.containsNode(iNode)) {
            return;
        }
        if (bl) {
            int n = 0;
            n = this.nodes_.find(iNode);
            if (n < 0) {
                n = 0;
            }
            this.addAll(iNode, n);
        } else {
            this.addAll(iNode);
        }
        this.registerAll(iNode);
    }

    private void registerAll(INode iNode) {
        int n = 0;
        while (n < iNode.childCount()) {
            this.registerAll(iNode.childAt(n));
            ++n;
        }
        if (iNode instanceof IElement) {
            this.registerElement((IElement)iNode);
        }
        if (iNode instanceof DTDDeclaration) {
            IValidationDocument iValidationDocument = ((DTDDeclaration)iNode).getValidationDocument();
            this.addValidationDocument(null, iValidationDocument);
        }
    }

    public void removeChild(INode iNode, INode iNode2) {
        this.removeChild(iNode, iNode2, false);
    }

    public void removeChildTransition(INode iNode, INode iNode2) {
        boolean bl = this.preserveChildren_;
        this.preserveChildren_ = true;
        this.removeChild(iNode, iNode2);
        this.preserveChildren_ = bl;
    }

    public void removeChild(INode iNode, INode iNode2, boolean bl) {
        this.setDirty(true);
        if (bl && iNode instanceof ISourceNode && iNode2 instanceof ISourceNode) {
            Object object;
            int n = ((ISourceNode)iNode2).getStart();
            int n2 = n + ((ISourceNode)iNode2).getLength();
            if (iNode2 instanceof ISourceElement && (object = (ISourceElement)iNode2).getEndTagStart() > -1) {
                n2 = object.getEndTagStart() + object.getEndTagLength();
            }
            object = this.source_.substring(n, n2);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < ((String)object).length()) {
                this.source_.setCharAt(n + n3, ' ');
                stringBuffer.append(' ');
                ++n3;
            }
            super.removeChild(iNode, iNode2);
            DocumentGeneratedSourceEvent documentGeneratedSourceEvent = new DocumentGeneratedSourceEvent(this, n, n2 - n, stringBuffer.toString());
            this.fireDocumentSourceEvent(documentGeneratedSourceEvent);
        } else {
            super.removeChild(iNode, iNode2);
        }
        if (iNode2 instanceof IElement) {
            this.checkForValidationDocument((IElement)iNode2, false);
        }
        if (iNode2 instanceof DTDDeclaration) {
            this.removeValidationDocument(null);
        }
    }

    public void removeString(int n, int n2) {
        if (this.locked()) {
            return;
        }
        this.scratchPad_.handleDelete(n, n2);
        this.modelIsValid_ = false;
        this.setDirty(true);
        super.removeString(n, n2);
    }

    public ScratchTag scratchTagAfter(ISourceNode iSourceNode) {
        return (ScratchTag)this.scratchTags_.nodeAfter(iSourceNode.getStart());
    }

    public ScratchTag scratchTagAfter(int n) {
        return (ScratchTag)this.scratchTags_.nodeAfter(n);
    }

    public ScratchTag scratchTagBefore(ISourceNode iSourceNode) {
        return this.scratchTagBefore(iSourceNode.getStart());
    }

    public ScratchTag scratchTagBefore(int n) {
        return (ScratchTag)this.scratchTags_.nodeBefore(n);
    }

    private void setRoot(INode iNode) {
        int n = 0;
        while (n < this.root_.childCount()) {
            this.root_.removeChildAt(n);
            ++n;
        }
        this.addChild(this.root_, iNode, 0, false);
    }

    public void setScratchPad(ScratchPad scratchPad) {
        this.scratchPad_ = scratchPad;
    }

    public void setSource(String string) {
        this.root_ = null;
        this.nodes_.clear();
        this.source_.delete(0, this.source_.length());
        this.source_.append(string);
    }

    public void setSource(String string, boolean bl) {
        if (bl) {
            this.setSource(string);
        } else {
            int n = 0;
            int n2 = this.source_.length();
            this.source_ = new StringBuffer(string);
            DocumentGeneratedSourceEvent documentGeneratedSourceEvent = new DocumentGeneratedSourceEvent(this, n, n2, this.source_.toString());
            this.fireDocumentSourceEvent(documentGeneratedSourceEvent);
        }
    }

    public void shiftNodes(ISourceNode iSourceNode, int n) {
        int n2 = this.nodes_.find(iSourceNode);
        int n3 = this.nodes_.size();
        if (n2 < 0 || n2 >= n3) {
            return;
        }
        INode iNode = this.nodes_.nodeAtIndex(n2);
        if (iNode.equals(iSourceNode)) {
            ++n2;
        }
        int n4 = n2;
        while (n4 < n3) {
            this.nodes_.nodeAtIndex(n4).shift(n);
            ++n4;
        }
    }

    public ISourceNode sourceNodeAfter(int n) {
        return (ISourceNode)this.nodes_.nodeAfter(n);
    }

    public ISourceNode sourceNodeAt(int n, int n2, int n3) {
        return (ISourceNode)this.nodes_.nodeAt(n, n2, n3);
    }

    public ISourceNode sourceNodeAt(Class clazz, int n, int n2, int n3) {
        return (ISourceNode)this.nodes_.nodeAt(clazz, n, n2, n3);
    }

    public ISourceNode sourceNodeBefore(int n) {
        return (ISourceNode)this.nodes_.nodeBefore(n);
    }

    public ISourceNode sourceParent(int n) {
        INode iNode = null;
        iNode = this.nodeAt(n);
        if (iNode != null) {
            iNode = iNode.getParent();
        } else {
            iNode = this.nodeAfter(n);
            if (iNode instanceof EndTagPlaceHolder) {
                return ((EndTagPlaceHolder)iNode).getElement();
            }
            if (iNode != null) {
                iNode = iNode.getParent();
            }
        }
        if (iNode == null) {
            return (ISourceNode)this.getRoot();
        }
        return iNode;
    }

    public String toString() {
        return this.toXml();
    }

    public String toWellFormedXML() {
        String string = this.toXml();
        int n = 0;
        int n2 = 0;
        while (n2 < this.scratchTags_.size()) {
            INode iNode = this.scratchTags_.nodeAtIndex(n2);
            int n3 = iNode.getStart() - n;
            int n4 = n3 + iNode.getLength();
            string = string.substring(n3, n4);
            n += iNode.getLength();
            ++n2;
        }
        return string;
    }

    public String toXml() {
        return this.source_.toString();
    }

    private void unRegisterNode(INode iNode) {
        this.unRegisterNode(iNode, true);
    }

    private void unRegisterNode(INode iNode, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < iNode.childCount()) {
                this.unRegisterNode(iNode.childAt(n));
                ++n;
            }
        }
        if (iNode instanceof ISourceNode) {
            ISourceNode cfr_ignored_0 = (ISourceNode)iNode;
            this.nodes_.removeNode(iNode);
            if (iNode instanceof ScratchTag) {
                this.scratchTags_.removeNode(iNode);
            }
            if (iNode instanceof ISourceElement) {
                EndTagPlaceHolder endTagPlaceHolder = new EndTagPlaceHolder((ISourceElement)iNode);
                this.nodes_.removeNode(endTagPlaceHolder);
            }
        }
        if (iNode instanceof IElement) {
            this.unRegisterElement((IElement)iNode);
        }
    }

    public void updateModel() {
        this.buildElementStructure();
    }

    public void updateNode(INode iNode) {
        if (iNode instanceof ISourceNode) {
            this.updateNode((ISourceNode)iNode, true);
        }
        logger_.debug((Object)("Tag " + iNode + " updated"));
    }

    public void updateNode(INode iNode, boolean bl) {
        this.lock();
        this.queueEvents();
        if (bl && iNode instanceof ISourceNode) {
            ISourceElement iSourceElement;
            ISourceNode iSourceNode = (ISourceNode)iNode;
            int n = iSourceNode.getStart();
            if (n < 0) {
                return;
            }
            int n2 = iSourceNode.getStart() + iSourceNode.getLength();
            int n3 = n2 - n;
            String string = iSourceNode.toString();
            this.source_.replace(n, n2, string);
            this.updateNodeLength(iSourceNode, string.length());
            DocumentGeneratedSourceEvent documentGeneratedSourceEvent = new DocumentGeneratedSourceEvent(this, n, n3, string);
            DocumentGeneratedSourceEvent documentGeneratedSourceEvent2 = null;
            if (iSourceNode instanceof ISourceElement && (iSourceElement = (ISourceElement)iSourceNode).getEndTagStart() >= 0) {
                string = iSourceElement.toEndString();
                n3 = iSourceElement.getEndTagLength();
                this.source_.replace(iSourceElement.getEndTagStart(), iSourceElement.getEndTagStart() + iSourceElement.getEndTagLength(), string);
                EndTagPlaceHolder endTagPlaceHolder = this.getEndTagPlaceHolder((ISourceElement)iSourceNode);
                if (endTagPlaceHolder != null) {
                    this.updateNodeLength(endTagPlaceHolder, string.length());
                }
                documentGeneratedSourceEvent2 = new DocumentGeneratedSourceEvent(this, iSourceElement.getEndTagStart(), n3, string);
            }
            this.fireDocumentSourceEvent(documentGeneratedSourceEvent);
            if (documentGeneratedSourceEvent2 != null) {
                this.fireDocumentSourceEvent(documentGeneratedSourceEvent2);
            }
            this.setDirty(true);
            this.modelIsValid_ = false;
        }
        this.unQueueEvents();
        this.unlock();
        logger_.debug((Object)("Tag " + iNode + " updated"));
    }

    public void updateNodeLength(ISourceNode iSourceNode, int n) {
        int n2 = n - iSourceNode.getLength();
        this.shiftNodes(iSourceNode, n2);
        iSourceNode.setLength(n);
    }

    public void updateString(int n, String string) {
        this.removeString(n, string.length());
        this.insertString(n, string);
        this.modelIsValid_ = false;
        this.setDirty(true);
    }

    public boolean hasErrors() {
        return this.scratchTags_.size() < 1;
    }

    public IElementStructure[] getElementStructures() {
        return this.getValidationDocument().getElementStructures();
    }

    public String getPrefixForNamespace(String string) {
        return (String)this.prefixes_.get(string);
    }

    public void addNamespaceReference(String string, String string2) {
        NamespaceMapping namespaceMapping = (NamespaceMapping)this.namespaces_.get(string);
        if (namespaceMapping == null) {
            namespaceMapping = new NamespaceMapping();
            namespaceMapping.uri = string2;
            namespaceMapping.prefix = string;
            this.namespaces_.put(string, namespaceMapping);
            this.prefixes_.put(string2, string);
            IElement[] iElementArray = this.getElementsWithPrefix(string);
            IMarker[] iMarkerArray = null;
            int n = 0;
            while (n < iElementArray.length) {
                iMarkerArray = iElementArray[n].getMarkers();
                if (iMarkerArray != null) {
                    int n2 = 0;
                    while (n2 < iMarkerArray.length) {
                        if (iMarkerArray[n2].getID() == 8833212) {
                            iElementArray[n].removeMarker(iMarkerArray[n2]);
                            break;
                        }
                        ++n;
                    }
                }
                ++n;
            }
            if (this.getGrammarFactory() != null) {
                logger_.debug((Object)("Checking for builtin grammar for : " + string2));
                IValidationDocument iValidationDocument = this.getGrammarFactory().getGrammar(string2);
                if (iValidationDocument != null) {
                    logger_.debug((Object)"Found a grammar, adding it...");
                    this.addValidationDocument(string2, iValidationDocument);
                }
            }
        }
        ++namespaceMapping.referenceCount;
    }

    public void removeNamespaceReference(String string, String string2) {
        NamespaceMapping namespaceMapping = (NamespaceMapping)this.namespaces_.get(string);
        if (namespaceMapping != null) {
            --namespaceMapping.referenceCount;
            if (namespaceMapping.referenceCount <= 0) {
                this.namespaces_.remove(namespaceMapping.prefix);
                IElement[] iElementArray = this.getElementsWithPrefix(string);
                int n = 0;
                while (n < iElementArray.length) {
                    iElementArray[n].addMarker(new PrefixMappingWarningMarker("Undefined namespace prefix:" + string));
                    ++n;
                }
            }
        }
    }

    private int depth(INode iNode) {
        int n = -1;
        while (iNode != null) {
            iNode = iNode.getParent();
            ++n;
        }
        return n;
    }

    private int getLength(INode iNode) {
        int n = iNode.getLength();
        int n2 = iNode.getStart();
        if (iNode instanceof IElement) {
            IElement iElement = (IElement)iNode;
            n = iElement.getEndTagStart() + iElement.getEndTagLength() - n2;
        }
        return n;
    }

    public void generateSourceFromModel() {
    }

    public void tidy(INode iNode) {
        if (iNode instanceof DocumentRoot || iNode instanceof IScratchTag) {
            return;
        }
        int n = iNode.getStart();
        int n2 = this.getLength(iNode);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2;
        this.depth(iNode);
        String string = "  ";
        StringBuffer stringBuffer2 = new StringBuffer();
        int n4 = this.source_.lastIndexOf("\n", n);
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = n4 + 1;
        while (n5 < n) {
            if (Character.isWhitespace(this.source_.charAt(n5))) {
                stringBuffer2.append(this.source_.charAt(n5));
            } else {
                stringBuffer2.append(" ");
            }
            ++n5;
        }
        Vector<INode> vector = new Vector<INode>();
        int n6 = this.nodes_.indexOfNodeAt(n + n2, 0, 0);
        if (n6 > -1) {
            int n7 = n6;
            while (n7 < this.nodes_.size()) {
                vector.add(this.nodes_.nodeAtIndex(n7));
                ++n7;
            }
        }
        this.visitNode(n, stringBuffer, iNode, stringBuffer2, string, true);
        n3 = stringBuffer.toString().length() - n2;
        this.source_.delete(n, n + n2);
        this.source_.insert(n, stringBuffer.toString());
        INode iNode2 = null;
        int n8 = 0;
        while (n8 < vector.size()) {
            iNode2 = (INode)vector.elementAt(n8);
            iNode2.setStart(iNode2.getStart() + n3);
            ++n8;
        }
        DocumentGeneratedSourceEvent documentGeneratedSourceEvent = new DocumentGeneratedSourceEvent(this, n, n2, stringBuffer.toString());
        this.fireDocumentSourceEvent(documentGeneratedSourceEvent);
    }

    private void visitNode(int n, StringBuffer stringBuffer, INode iNode, StringBuffer stringBuffer2, String string, boolean bl) {
        ISourceElement iSourceElement;
        if (!(iNode instanceof IValueNode) && !bl) {
            stringBuffer.append(stringBuffer2);
        }
        int n2 = stringBuffer.length();
        if (!(iNode instanceof IScratchTag)) {
            stringBuffer.append(iNode.toString());
        } else {
            stringBuffer.append(((IScratchTag)iNode).getText());
        }
        if (iNode instanceof ISourceNode) {
            ISourceNode iSourceNode = (ISourceNode)iNode;
            iSourceNode.setStart(n + n2);
            iSourceNode.setLength(iNode.toString().length());
        }
        stringBuffer2.append(string);
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < iNode.childCount()) {
            if (!(iNode.childAt(n3) instanceof IValueNode)) {
                stringBuffer.append("\n");
            }
            this.visitNode(n, stringBuffer, iNode.childAt(n3), stringBuffer2, string, false);
            if (!(iNode.childAt(n3) instanceof IValueNode) && n3 == iNode.childCount() - 1) {
                bl2 = true;
            }
            ++n3;
        }
        stringBuffer2.delete(stringBuffer2.length() - string.length(), stringBuffer2.length());
        if (bl2) {
            stringBuffer.append("\n" + stringBuffer2);
        }
        n3 = stringBuffer.length();
        if (iNode instanceof ISourceElement && (iSourceElement = (ISourceElement)iNode).getEndTagStart() > -1) {
            stringBuffer.append(iSourceElement.toEndString());
            iSourceElement.setEndTagStart(n + n3);
            iSourceElement.setEndTagLength(iSourceElement.toEndString().length());
        }
    }

    public void addValidationDocument(String string, IValidationDocument iValidationDocument) {
        IValidationDocument iValidationDocument2 = this.getValidationDocument();
        if (iValidationDocument2 instanceof CompoundValidationDocument) {
            ((CompoundValidationDocument)iValidationDocument2).addValidationDocument(string, iValidationDocument);
        } else {
            CompoundValidationDocument compoundValidationDocument = new CompoundValidationDocument("text/validation");
            compoundValidationDocument.addValidationDocument(iValidationDocument2.getNamespace(), iValidationDocument2);
            compoundValidationDocument.addValidationDocument(string, iValidationDocument);
            this.setValidationDocument(compoundValidationDocument);
        }
    }

    public void checkForValidationDocument(IElement iElement, boolean bl) {
        Object object;
        IAttribute iAttribute = iElement.getAttribute(XML_SCHEMA_NAMESPACE, DEFAULT_SCHEMA_LOCATION_ATTRIBUTE);
        IAttribute iAttribute2 = iElement.getAttribute(XML_SCHEMA_NAMESPACE, SCHEMA_LOCATION_ATTRIBUTE);
        boolean bl2 = false;
        if (iAttribute != null) {
            try {
                logger_.debug((Object)("default schema added:" + iAttribute));
                object = "" + iAttribute.getData();
                if (!bl) {
                    bl2 = true;
                    this.removeValidationDocument(null);
                } else {
                    IValidationDocument iValidationDocument = this.getValidationDocumentAt((String)object, "text/xsd");
                    if (iValidationDocument != null) {
                        if (!iValidationDocument.isValid()) {
                            iElement.addMarker(new Marker("The schema at the specified URI (" + (String)object + ") contains errors", 0, 0));
                        } else {
                            bl2 = true;
                            this.addValidationDocument(null, iValidationDocument);
                        }
                    } else {
                        iElement.addMarker(new Marker("Unable to load the schema document at the specified URI", 0, 0));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                iElement.addMarker(new Marker("Unable to load the schema document at the specified URI", 0, 0));
            }
        }
        if (iAttribute2 != null) {
            object = new StringTokenizer(iAttribute2.getData());
            int n = ((StringTokenizer)object).countTokens();
            if (n < 2) {
                iElement.addMarker(new Marker("The schemaLocation attribute must specify at least one namespace and schema location pair.", 0, 0));
            }
            String string = null;
            String string2 = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                if (string2 == null) {
                    string2 = string;
                    continue;
                }
                if (bl) {
                    IValidationDocument iValidationDocument = this.getValidationDocumentAt(string, "text/xsd");
                    if (iValidationDocument != null) {
                        if (iValidationDocument.isValid()) {
                            bl2 = true;
                            this.addValidationDocument(string2, iValidationDocument);
                        } else {
                            iElement.addMarker(new Marker("The schema at the specified URI (" + string + ") contains errors", 0, 0));
                        }
                    } else {
                        iElement.addMarker(new Marker("Unable to load schema, URI:" + string, 0, 0));
                    }
                    string2 = null;
                    continue;
                }
                bl2 = true;
                this.removeValidationDocument(string2);
                string2 = null;
            }
            if (string2 != null) {
                iElement.addMarker(new Marker("Missing schema location URI for namespace:" + string2, 0, 0));
            }
            if (bl2) {
                this.validateChildren(this.getRoot(), true);
            }
            logger_.debug((Object)("schema added:" + iAttribute2));
        }
    }

    public void removeValidationDocument(String string) {
        IValidationDocument iValidationDocument = this.getValidationDocument();
        if (iValidationDocument instanceof CompoundValidationDocument && iValidationDocument != null) {
            ((CompoundValidationDocument)iValidationDocument).removeValidationDocument(string);
        }
    }

    public IValidationDocument getValidationDocumentAt(String string, String string2) {
        IValidationDocument iValidationDocument = null;
        try {
            if (this.getGrammarFactory() != null) {
                iValidationDocument = this.getGrammarFactory().getGrammar(string, this.getSourceFileName(), null, string2);
            } else {
                File file = FileSystem.resolve(this.getSourceFileName(), string);
                IDocument iDocument = FileSystem.loadDocument(file);
                if (iDocument instanceof IValidationDocument && iDocument != null) {
                    iValidationDocument = (IValidationDocument)iDocument;
                }
                if (iDocument != null) {
                    ValidationDocument validationDocument = new ValidationDocument(string2, iDocument);
                    validationDocument.getElementStructures();
                    iValidationDocument = validationDocument;
                }
            }
            return iValidationDocument;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        XmlDocument xmlDocument = new XmlDocument("<a></a>");
        INode iNode = xmlDocument.getRoot().childAt(0);
        Element element = new Element("b");
        Element element2 = new Element("c");
        element.setEndTagStart(0);
        xmlDocument.addChild(iNode, element, iNode.childCount(), true);
        xmlDocument.addChild(element, element2, 0, true);
    }

    public INode createNode(Object object) {
        if (object instanceof ITagInfo && ((ITagInfo)object).getType() == 13) {
            return this.createElement((ITagInfo)object);
        }
        return null;
    }

    public IElement createElement(ITagInfo iTagInfo) {
        IElementStructure iElementStructure;
        Element element = null;
        if (iTagInfo.getNamespace() != null) {
            String string = this.getPrefixForNamespace(iTagInfo.getNamespace());
            if (string != null) {
                element = new Element(String.valueOf(string) + ":" + iTagInfo.getName());
            } else {
                element = new Element(iTagInfo.getName());
                new Attribute("xmlns", iTagInfo.getNamespace());
            }
        } else {
            element = new Element(iTagInfo.getName());
        }
        int n = 0;
        while (n < iTagInfo.attributeCount()) {
            IAttributeInfo iAttributeInfo = iTagInfo.attributeAt(n);
            Attribute attribute = null;
            if (iAttributeInfo.getName().startsWith("xmlns:")) {
                attribute = new NamespacePrefixMapping(iTagInfo.getName(), iTagInfo.getData());
            } else {
                attribute = new Attribute(iTagInfo.getName());
                attribute.setData(iTagInfo.getData());
            }
            element.addAttribute(attribute);
            ++n;
        }
        if (this.getValidationDocument() != null && (iElementStructure = this.getValidationDocument().getElementStructure(element.getName(), element.getNameSpace())) != null) {
            iElementStructure.getDefaultContent(element);
        }
        return element;
    }

    private void registerElement(IElement iElement) {
        String string = iElement.getPrefix();
        if (string != null) {
            Vector<IElement> vector = (Vector<IElement>)this.nodePrefixes_.get(string);
            if (vector == null) {
                vector = new Vector<IElement>(1);
                this.nodePrefixes_.put(string, vector);
            }
            vector.add(iElement);
        }
        this.checkForPrefixMappings(iElement);
        if (iElement.getDefaultNamespace() != null) {
            boolean bl = false;
            if (this.getValidationDocument() instanceof CompoundValidationDocument) {
                bl = ((CompoundValidationDocument)this.getValidationDocument()).getValidationDocument(iElement.getDefaultNamespace()) == null;
            } else if (this.getValidationDocument() != null && !iElement.getDefaultNamespace().equals(this.getValidationDocument().getNamespace())) {
                bl = true;
            }
            if (bl && this.getGrammarFactory() != null) {
                IValidationDocument iValidationDocument = this.getGrammarFactory().getGrammar(iElement.getDefaultNamespace());
                this.addValidationDocument(iElement.getDefaultNamespace(), iValidationDocument);
            }
        }
        this.checkForValidationDocument(iElement, true);
    }

    private void checkForPrefixMappings(IElement iElement) {
        INamespacePrefixMapping[] iNamespacePrefixMappingArray = iElement.getPrefixMappings();
        if (iNamespacePrefixMappingArray != null) {
            int n = 0;
            while (n < iNamespacePrefixMappingArray.length) {
                this.addNamespaceReference(iNamespacePrefixMappingArray[n].getPrefix(), iNamespacePrefixMappingArray[n].getURI());
                ++n;
            }
        }
    }

    private void unRegisterElement(IElement iElement) {
        Object object;
        String string = iElement.getPrefix();
        if (string != null && (object = (Vector)this.nodePrefixes_.get(string)) != null) {
            ((Vector)object).remove(iElement);
        }
        if ((object = iElement.getPrefixMappings()) != null) {
            int n = 0;
            while (n < ((Object)object).length) {
                this.removeNamespaceReference(object[n].getPrefix(), object[n].getURI());
                ++n;
            }
        }
    }

    public IElement[] getElementsWithPrefix(String string) {
        Vector vector = (Vector)this.nodePrefixes_.get(string);
        if (vector != null) {
            return vector.toArray(new IElement[0]);
        }
        return new IElement[0];
    }

    public void addNamespace(String string, String string2) {
        this.addNamespaceReference(string, string2);
    }

    public String getNamespaceURI(String string) {
        NamespaceMapping namespaceMapping = (NamespaceMapping)this.namespaces_.get(string);
        if (namespaceMapping != null) {
            return namespaceMapping.uri;
        }
        return null;
    }

    public NamespaceMapping[] getNamespaceMappings() {
        return this.namespaces_.values().toArray(new NamespaceMapping[0]);
    }

    public void moveNodes(INode iNode, int n, int n2, INode iNode2, int n3) {
        INode[] iNodeArray = iNode.removeChildren(n, n2);
        iNode2.addChildren(n3, iNodeArray);
        this.validate(iNode2);
        DocumentEvent documentEvent = new DocumentEvent((IDocument)this, iNode, iNodeArray, n3, 6);
        documentEvent.setChangedNode(iNode2);
        this.fireDocumentEvent(documentEvent);
    }

    public boolean addingIncrementally() {
        return this.addIncrementally_;
    }

    public void setAddIncrementally(boolean bl) {
        if (this.addingIncrementally() != bl) {
            this.lastAdd_ = -1;
        }
        this.addIncrementally_ = bl;
    }

    public int length() {
        return this.source_.length();
    }

    public void nodeChanged(INode iNode) {
        if (iNode instanceof IElement) {
            this.checkForPrefixMappings((IElement)iNode);
            this.checkForValidationDocument((IElement)iNode, true);
        }
        super.nodeChanged(iNode);
    }

    public IGrammarFactory getGrammarFactory() {
        return this.grammarFactory_;
    }

    public void setGrammarFactory(IGrammarFactory iGrammarFactory) {
        this.grammarFactory_ = iGrammarFactory;
    }

    public SortedNodeVector getNodes() {
        return this.nodes_;
    }

    public class NamespaceMapping {
        public String uri;
        public String prefix;
        public int referenceCount;
    }

    public class EndTagPlaceHolder
    extends Node
    implements IScratchable {
        private ISourceElement element_;

        public EndTagPlaceHolder(ISourceElement iSourceElement) {
            this.element_ = iSourceElement;
        }

        public int getStart() {
            return this.element_.getEndTagStart();
        }

        public int getLength() {
            return this.element_.getEndTagLength();
        }

        public void setStart(int n) {
            this.element_.setEndTagStart(n);
        }

        public void setLength(int n) {
            this.element_.setEndTagLength(n);
        }

        public void shift(int n) {
            this.element_.shiftEnd(n);
        }

        public ISourceElement getElement() {
            return this.element_;
        }

        public int compareTo(Object object) {
            if (object instanceof EndTagPlaceHolder) {
                EndTagPlaceHolder endTagPlaceHolder = (EndTagPlaceHolder)object;
                if (endTagPlaceHolder.getElement().equals(this.getElement())) {
                    return 0;
                }
                if (endTagPlaceHolder.getStart() == this.getStart()) {
                    return this.getLength() - endTagPlaceHolder.getLength();
                }
                return this.getStart() - endTagPlaceHolder.getStart();
            }
            if (object instanceof ISourceNode) {
                return super.compareTo(object);
            }
            return -1;
        }

        public int compareTo(INode iNode) {
            if (iNode instanceof EndTagPlaceHolder) {
                EndTagPlaceHolder endTagPlaceHolder = (EndTagPlaceHolder)iNode;
                if (endTagPlaceHolder.getElement().equals(this.getElement())) {
                    return 0;
                }
                if (endTagPlaceHolder.getStart() == this.getStart()) {
                    return this.getLength() - endTagPlaceHolder.getLength();
                }
                return this.getStart() - endTagPlaceHolder.getStart();
            }
            return super.compareTo(iNode);
        }

        public boolean equals(Object object) {
            if (object instanceof EndTagPlaceHolder) {
                return ((EndTagPlaceHolder)object).getElement() == this.getElement();
            }
            return super.equals(object);
        }

        public String toString() {
            return "Place holder for: " + this.element_;
        }

        protected INode createNode() {
            return new EndTagPlaceHolder(this.getElement());
        }

        public IDocument getDocument() {
            return this.element_.getDocument();
        }

        public IScratchTag scratch(boolean bl, int n) {
            if (this.element_ instanceof IScratchable) {
                return ((IScratchable)((Object)this.element_)).scratch(bl, n);
            }
            return null;
        }
    }
}

