/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.incremental;

import butterfly.xmlview.model.incremental.AttributeContentModelAcceptor;
import butterfly.xmlview.model.incremental.AttributeValueAcceptor;
import butterfly.xmlview.model.incremental.WordAcceptor;
import butterfly.xmlview.model.interfaces.IAcceptor;
import java.util.Hashtable;

public class AttributeDatatypeAcceptor
extends WordAcceptor {
    public static final String[] ATTRIBUTE_TYPES = new String[]{"FIXED", "CDATA", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NMTOKEN", "NMTOKENS", "NOTATION", "FIXED"};
    public Hashtable ATTRIBUTE_TYPE_LOOKUP = null;
    protected static AttributeContentModelAcceptor contentModelChecker_ = new AttributeContentModelAcceptor();
    protected static AttributeValueAcceptor attributeValueChecker_ = new AttributeValueAcceptor();
    private String expects_ = "not yet checked";

    public AttributeDatatypeAcceptor() {
        if (this.ATTRIBUTE_TYPE_LOOKUP == null) {
            this.ATTRIBUTE_TYPE_LOOKUP = new Hashtable(ATTRIBUTE_TYPES.length);
            int n = 0;
            while (n < ATTRIBUTE_TYPES.length) {
                this.ATTRIBUTE_TYPE_LOOKUP.put(ATTRIBUTE_TYPES[n], Boolean.TRUE);
                ++n;
            }
        }
    }

    public String expects() {
        return this.expects_;
    }

    protected boolean checkChar(char c) {
        return c != '<' && c != '>' && c != '&';
    }

    protected boolean acceptableWord(StringBuffer stringBuffer) {
        String string = stringBuffer.toString().trim();
        if (string.length() < 1) {
            return false;
        }
        char c = string.charAt(0);
        if (c == '\"' || c == '\'') {
            return this.check(attributeValueChecker_, string);
        }
        if (c == '(') {
            return this.check(contentModelChecker_, string);
        }
        if (c == '#') {
            return this.ATTRIBUTE_TYPE_LOOKUP.containsKey(string.substring(1));
        }
        return Character.isLetterOrDigit(c);
    }

    private boolean check(IAcceptor iAcceptor, String string) {
        iAcceptor.reset();
        int n = 0;
        while (n < string.length()) {
            iAcceptor.accept(string.charAt(n));
            if (iAcceptor.getState() == -1) {
                this.expects_ = String.valueOf(string) + " is not a valid attribute datatype";
                return false;
            }
            ++n;
        }
        return iAcceptor.getState() == 1;
    }

    public String getDatatype() {
        return this.getWord().toString().trim();
    }
}

