/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.incremental;

import butterfly.xmlview.model.incremental.AbstractAcceptor;
import butterfly.xmlview.model.incremental.CharacterAcceptor;
import butterfly.xmlview.model.incremental.CharacterListAcceptor;
import butterfly.xmlview.model.incremental.UniversalAcceptor;
import butterfly.xmlview.model.incremental.WordAcceptor;
import butterfly.xmlview.model.interfaces.IAcceptor;
import java.util.Hashtable;

public abstract class CompoundAcceptor
extends AbstractAcceptor {
    private State currentState_;
    private State startState_;

    public CompoundAcceptor() {
        this.startState_ = this.currentState_ = this.init();
    }

    public abstract State init();

    public String expects() {
        return this.currentState_.getAcceptor().expects();
    }

    public IAcceptor accept(char c) {
        this.currentState_ = this.currentState_.accept(c);
        if (this.currentState_.getAcceptorState() == -1) {
            this.setState(-1);
        }
        if (this.currentState_ instanceof EndState) {
            this.setState(1);
        }
        return this;
    }

    public void reset() {
        this.currentState_ = this.startState_;
        this.currentState_.reset();
        super.reset();
    }

    protected class BranchingState
    extends State {
        private Hashtable nextStates_;

        public BranchingState(WordAcceptor wordAcceptor, State state, char c) {
            super((IAcceptor)wordAcceptor, state, c);
        }

        public BranchingState(WordAcceptor wordAcceptor, State state, String string) {
            super((IAcceptor)wordAcceptor, state, string);
        }

        public BranchingState(WordAcceptor wordAcceptor, State state) {
            super(wordAcceptor, state);
        }

        public void addBranch(String string, State state) {
            this.nextStates_.put(string.toLowerCase(), state);
        }

        public State getBranch(String string) {
            return (State)this.nextStates_.get(string.toLowerCase());
        }

        public State nextState() {
            String string = ((WordAcceptor)this.getAcceptor()).getWord().toString().trim();
            State state = this.getBranch(string);
            if (state == null) {
                return super.nextState();
            }
            return state;
        }
    }

    protected class EndState
    extends State {
        public EndState() {
            super((IAcceptor)new UniversalAcceptor(), null, 'a');
        }

        public State accept(char c) {
            return this;
        }

        public int getAcceptorState() {
            return 1;
        }

        public State nextState() {
            return this;
        }
    }

    protected class LoopingState
    extends State {
        private State loopTo_;
        private StringBuffer buffer_;
        private boolean looping_ = false;

        public LoopingState(IAcceptor iAcceptor, State state, State state2) {
            super(iAcceptor, state);
            this.loopTo_ = state2;
            this.buffer_ = new StringBuffer();
        }

        public State accept(char c) {
            this.buffer_.append(c);
            State state = super.accept(c);
            if (!state.equals(this)) {
                this.exit();
            }
            if (state.equals(this) && this.getAcceptorState() == -1) {
                this.looping_ = true;
                this.loop();
                this.loopTo_.reset();
                state = this.loopTo_;
                int n = 0;
                while (n < this.buffer_.length()) {
                    if ((state = state.accept(this.buffer_.charAt(n))).getAcceptorState() == -1) break;
                    ++n;
                }
                this.looping_ = false;
                this.buffer_ = new StringBuffer();
                this.getAcceptor().reset();
            }
            return state;
        }

        public void loop() {
        }

        public void exit() {
        }

        public void reset() {
            if (!this.looping_) {
                this.buffer_ = new StringBuffer();
                super.reset();
            }
        }
    }

    protected class State {
        private State nextState_;
        private IAcceptor acceptor_;
        private boolean canTransition_ = false;
        private boolean transitionOnAccept_ = false;
        private boolean ignoreWhitespace_;
        private boolean originalIgnoreWhitespace_ = this.ignoreWhitespace_ = true;
        private boolean allowForwarding_ = false;
        private CharacterAcceptor transitionAcceptor_;

        public State(IAcceptor iAcceptor, State state, char c) {
            this.nextState_ = state;
            this.acceptor_ = iAcceptor;
            this.transitionAcceptor_ = new CharacterAcceptor(c);
            this.transitionOnAccept_ = false;
        }

        public State(IAcceptor iAcceptor, State state, String string) {
            this.nextState_ = state;
            this.acceptor_ = iAcceptor;
            this.transitionAcceptor_ = new CharacterListAcceptor(string);
            this.transitionOnAccept_ = false;
        }

        public State(IAcceptor iAcceptor, State state, CharacterAcceptor characterAcceptor) {
            this.nextState_ = state;
            this.acceptor_ = iAcceptor;
            this.transitionAcceptor_ = characterAcceptor;
        }

        public State(IAcceptor iAcceptor, State state) {
            this.nextState_ = state;
            this.acceptor_ = iAcceptor;
            this.transitionOnAccept_ = true;
        }

        public void reset() {
            CompoundAcceptor.this.setState(0);
            this.ignoreWhitespace_ = this.originalIgnoreWhitespace_;
            this.acceptor_.reset();
            if (this.nextState() != null && !this.nextState().equals(this)) {
                this.nextState().reset();
            }
        }

        public boolean canTransition() {
            return this.canTransition_;
        }

        public State nextState() {
            return this.nextState_;
        }

        public IAcceptor getAcceptor() {
            return this.acceptor_;
        }

        public int getAcceptorState() {
            return this.acceptor_.getState();
        }

        public State accept(char c) {
            if (this.ignoreWhitespace_ && Character.isWhitespace(c)) {
                return this;
            }
            this.ignoreWhitespace_ = false;
            boolean bl = false;
            if (this.transitionAcceptor_ != null) {
                this.transitionAcceptor_.accept(c);
                bl = this.transitionAcceptor_.getState() == 1;
                this.transitionAcceptor_.reset();
            }
            if (bl && !this.transitionOnAccept_) {
                if (this.acceptor_.getState() == 1) {
                    return this.nextState().accept(c);
                }
                CompoundAcceptor.this.setState(-1);
                return this;
            }
            this.acceptor_.accept(c);
            if (this.transitionOnAccept_ && this.acceptor_.getState() == 1) {
                return this.nextState();
            }
            return this;
        }

        public void setNextState(State state) {
            this.nextState_ = state;
        }

        public void setIgnoreLeadingWhitespace(boolean bl) {
            this.ignoreWhitespace_ = bl;
            this.originalIgnoreWhitespace_ = bl;
        }
    }
}

