/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.incremental;

import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.DTDDeclaration;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.ICDATANode;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IScratchable;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.ITag;
import butterfly.xmlview.model.interfaces.IUnparsedSection;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class ScratchPad {
    private TreeSet scratchTags_ = new TreeSet();
    private XmlDocument document_;
    private IScratchTag cachedScratchTag_ = null;
    private boolean dirty_ = false;
    private String wellFormedSource_;
    private static Logger logger_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.incremental.ScratchPad");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public ScratchPad(XmlDocument xmlDocument) {
        this.document_ = xmlDocument;
    }

    public void handleDelete(int n, int n2) {
        logger_.debug((Object)("handling a delete at " + n + " length:" + n2));
        this.dirty_ = true;
        if (n2 > 1) {
            INode[] iNodeArray = this.document_.sourceNodesWithin(n, n2);
            if (iNodeArray.length > 2) {
                INode iNode = null;
                int n3 = iNodeArray[1].getStart();
                int n4 = iNodeArray[iNodeArray.length - 2].getStart() + iNodeArray[iNodeArray.length - 2].getLength();
                int n5 = 1;
                while (n5 < iNodeArray.length - 1) {
                    iNode = iNodeArray[n5];
                    if (iNode.getDocument() != null) {
                        System.out.println(iNode.getClass());
                        ((IScratchable)((Object)iNode)).scratch(false, iNode.getStart());
                    }
                    ++n5;
                }
                iNodeArray = this.document_.sourceNodesWithin(n, n2);
                n5 = 1;
                while (n5 < iNodeArray.length - 1) {
                    iNode = iNodeArray[n5];
                    if (iNode.getDocument() != null) {
                        this.document_.removeChild(iNode.getParent(), iNode, false);
                    }
                    ++n5;
                }
                this.document_.getSourceBuffer().delete(n3, n4);
                ValueNode valueNode = new ValueNode();
                valueNode.setStart(n3);
                this.document_.shiftNodes(valueNode, -1 * (n4 - n3));
                this.handleDelete(n, n2 - (n4 - n3));
            } else {
                int n6 = 0;
                while (n6 < n2) {
                    this.handleDelete(n, 1);
                    ++n6;
                }
            }
        } else {
            ISourceNode iSourceNode;
            long l = System.currentTimeMillis();
            logger_.debug((Object)"handling a delete");
            ISourceNode iSourceNode2 = null;
            if (this.cachedScratchTag_ != null && this.cachedScratchTag_.getStart() < n && n < this.cachedScratchTag_.getStart() + this.cachedScratchTag_.getLength() && this.cachedScratchTag_.getDocument() != null) {
                iSourceNode2 = this.cachedScratchTag_;
            }
            if (iSourceNode2 == null) {
                iSourceNode2 = this.document_.nodeAt(n, 0, 0);
            }
            StringBuffer stringBuffer = this.document_.getSourceBuffer();
            if (iSourceNode2 == null) {
                stringBuffer.delete(n, n + n2);
                ValueNode valueNode = new ValueNode();
                valueNode.setStart(n);
                valueNode.setLength(-1);
                this.document_.shiftNodes(valueNode, -1);
                return;
            }
            if (iSourceNode2 instanceof IUnparsedSection) {
                iSourceNode = iSourceNode2;
                IUnparsedSection iUnparsedSection = (IUnparsedSection)((Object)iSourceNode2);
                if (iUnparsedSection.inside(true, n)) {
                    stringBuffer.delete(n, n + n2);
                    this.document_.updateNodeLength(iSourceNode, iSourceNode.getLength() - 1);
                    iUnparsedSection.updateContents();
                    return;
                }
            }
            iSourceNode = null;
            if (iSourceNode2 instanceof ScratchTag) {
                iSourceNode = (ScratchTag)iSourceNode2;
            }
            if (iSourceNode != null) {
                logger_.debug((Object)("node search/scratch took: " + (System.currentTimeMillis() - l)));
                logger_.debug((Object)("the delete is being handled by: " + iSourceNode));
                this.cachedScratchTag_ = iSourceNode;
                stringBuffer.delete(n, n + n2);
                ((ScratchTag)iSourceNode).handleDelete(n, 1);
                System.out.println("delete took:" + (System.currentTimeMillis() - l));
            } else {
                boolean bl = iSourceNode2 != null && iSourceNode2 instanceof ISourceElement;
                if (iSourceNode2 instanceof IScratchable && !(iSourceNode2 instanceof IScratchTag)) {
                    boolean bl2 = iSourceNode2.getDocument() instanceof AbstractValidatedDocument && iSourceNode2 instanceof DTDDeclaration;
                    INode iNode = iSourceNode2.getParent();
                    if (bl2) {
                        ((AbstractValidatedDocument)iSourceNode2.getDocument()).setValidate(false);
                    }
                    ((IScratchable)((Object)iSourceNode2)).scratch(false, n);
                    this.handleDelete(n, 1);
                    if (bl2 && iNode.getDocument() != null) {
                        ((AbstractValidatedDocument)iNode.getDocument()).setValidate(true);
                        ((AbstractValidatedDocument)iNode.getDocument()).validate();
                    }
                }
            }
        }
    }

    public void handleInsert(int n, String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        logger_.debug((Object)("handling an insert at " + n + " text:" + string));
        this.dirty_ = true;
        if (string.length() > 1) {
            int n2 = 0;
            while (n2 < string.length()) {
                this.handleInsert(n + n2, string.substring(n2, n2 + 1));
                ++n2;
            }
        } else {
            String string2;
            int n3;
            int n4;
            boolean bl;
            Object object;
            Object object2;
            ISourceNode iSourceNode;
            ISourceNode iSourceNode2 = null;
            if (this.cachedScratchTag_ != null && this.cachedScratchTag_.getStart() < n && n <= this.cachedScratchTag_.getStart() + this.cachedScratchTag_.getLength() && this.cachedScratchTag_.getDocument() != null) {
                iSourceNode2 = this.cachedScratchTag_;
            }
            if (iSourceNode2 == null && (iSourceNode2 = this.document_.scratchTagBefore(n + 1)) != null && (iSourceNode2.getStart() + iSourceNode2.getLength() < n || iSourceNode2.getStart() > n)) {
                iSourceNode2 = null;
            }
            if (iSourceNode2 == null) {
                iSourceNode2 = this.document_.nodeAt(n, 0, 0);
            }
            if (iSourceNode2 instanceof IUnparsedSection) {
                iSourceNode = iSourceNode2;
                object2 = (IUnparsedSection)((Object)iSourceNode2);
                if (object2.inside(true, n)) {
                    StringBuffer stringBuffer = this.document_.getSourceBuffer();
                    stringBuffer.insert(n, string);
                    this.document_.updateNodeLength(iSourceNode, iSourceNode.getLength() + 1);
                    object2.updateContents();
                    return;
                }
            }
            if (!(!(iSourceNode2 instanceof Element) || string.equals("<") || string.equals(">") || string.equals("'") || string.equals("\""))) {
                logger_.debug((Object)"in attribute mod optimization...");
                iSourceNode = (Element)iSourceNode2;
                if (iSourceNode2.getStart() + iSourceNode2.getLength() - 2 > n && n > iSourceNode2.getStart() + 5) {
                    logger_.debug((Object)"checking to see if the attribute will be valid after modification...");
                    int n5 = n - iSourceNode2.getStart();
                    object = this.document_.getSourceBuffer().substring(iSourceNode2.getStart(), iSourceNode2.getStart() + iSourceNode2.getLength());
                    bl = false;
                    n4 = 0;
                    while ((n4 = ((String)object).indexOf("\"", n4 + 1)) > -1) {
                        if (n4 >= n5) break;
                        boolean bl2 = bl = !bl;
                    }
                    if (bl) {
                        logger_.debug((Object)"using the optimized change...");
                        n4 = ((String)object).indexOf("\"", n5);
                        int n6 = ((String)object).lastIndexOf("\"", n5 - 1);
                        String string3 = ((String)object).substring(n6 + 1, n4);
                        n3 = n5 - (n6 + 1);
                        logger_.debug((Object)("new val:\"" + string3 + "\""));
                        n4 = ((String)object).lastIndexOf("=", n6);
                        --n4;
                        while (Character.isWhitespace(((String)object).charAt(n4))) {
                            --n4;
                        }
                        n6 = n4;
                        while (!Character.isWhitespace(((String)object).charAt(n6))) {
                            --n6;
                        }
                        String string4 = ((String)object).substring(n6 + 1, n4 + 1);
                        string2 = null;
                        int n7 = string4.indexOf(":");
                        if (n7 > -1) {
                            string2 = string4.substring(0, n7);
                            string2 = this.document_.getNamespaceURI(string2);
                            string4 = string4.substring(n7 + 1);
                        }
                        logger_.debug((Object)("modifying " + string4 + ":" + string2));
                        Attribute attribute = (Attribute)((Element)iSourceNode).getAttribute(string2, string4);
                        if (attribute != null) {
                            this.document_.getSourceBuffer().insert(n, string);
                            this.document_.updateNodeLength(iSourceNode, iSourceNode2.getLength() + 1);
                            attribute.setData(String.valueOf(string3.substring(0, n3)) + string + string3.substring(n3));
                            return;
                        }
                        logger_.debug((Object)"WTF?...couldn'find the attribute being modified...bail");
                    } else {
                        logger_.debug((Object)"no go...tag needs to be scratched");
                    }
                }
            }
            if (iSourceNode2 instanceof ITag && iSourceNode2 instanceof ISourceNode && !(iSourceNode2 instanceof IScratchTag)) {
                boolean bl3 = false;
                object2 = iSourceNode2;
                if (object2.getStart() == n) {
                    bl3 = true;
                } else if (object2 instanceof ISourceElement && ((ISourceElement)object2).getEndTagStart() == n) {
                    bl3 = true;
                }
                if (bl3) {
                    object = this.document_.sourceNodeBefore(n);
                    if (object instanceof IScratchTag) {
                        iSourceNode2 = object;
                        logger_.debug((Object)"it can");
                    } else if (object instanceof IValueNode && !(object instanceof ITag)) {
                        iSourceNode2 = object;
                        logger_.debug((Object)"it can");
                    }
                }
            }
            ScratchTag scratchTag = null;
            if (iSourceNode2 instanceof ScratchTag) {
                scratchTag = (ScratchTag)iSourceNode2;
            }
            object2 = this.document_.getSourceBuffer();
            if (scratchTag != null) {
                logger_.debug((Object)("the insert is being handled by: " + scratchTag));
                this.cachedScratchTag_ = scratchTag;
                ((StringBuffer)object2).insert(n, string);
                scratchTag.handleInsert(n, string);
            } else {
                boolean bl4 = iSourceNode2 != null && iSourceNode2 instanceof IElement;
                bl = false;
                n4 = 0;
                if (Character.isWhitespace(string.charAt(0)) && iSourceNode2 == null) {
                    ((StringBuffer)object2).insert(n, string);
                    ValueNode valueNode = new ValueNode();
                    valueNode.setStart(n);
                    this.document_.shiftNodes(valueNode, 1);
                    return;
                }
                if (iSourceNode2 == null && string.charAt(0) != '<' && string.charAt(0) != '>') {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("butterfly.xmlview.model.interfaces.IValueNode");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iSourceNode2 = this.document_.sourceNodeAt(clazz, n, 0, 1);
                }
                if (iSourceNode2 instanceof IValueNode && iSourceNode2 instanceof ISourceNode && string.charAt(0) != '<' && string.charAt(0) != '>') {
                    IValueNode iValueNode = (IValueNode)((Object)iSourceNode2);
                    ((StringBuffer)object2).insert(n, string);
                    int n8 = ((ISourceNode)((Object)iValueNode)).getStart();
                    n3 = ((ISourceNode)((Object)iValueNode)).getLength();
                    int n9 = n8 + n3 + 1;
                    string2 = ((StringBuffer)object2).substring(n8, n9);
                    iValueNode.setData(string2);
                    this.document_.updateNodeLength((ISourceNode)((Object)iValueNode), n3 + 1);
                    return;
                }
                if (iSourceNode2 != null && iSourceNode2 instanceof IScratchable && !(iSourceNode2 instanceof IScratchTag)) {
                    logger_.debug((Object)("will scratch " + iSourceNode2.getStart() + "," + iSourceNode2.getLength() + " to handle the insert at:" + n));
                    ((IScratchable)((Object)iSourceNode2)).scratch(true, n);
                    this.handleInsert(n, string);
                    return;
                }
                if (n < ((StringBuffer)object2).length() && ((StringBuffer)object2).charAt(n) == '<') {
                    bl = true;
                    if (iSourceNode2 instanceof ISourceElement && ((ISourceElement)iSourceNode2).getEndTagStart() == n) {
                        n4 = 1;
                    }
                }
                if (bl4 && !bl) {
                    this.scratchElement((ISourceElement)iSourceNode2);
                    this.handleInsert(n, string);
                    return;
                }
                if (n4 != 0) {
                    this.scratchValueNode(n);
                    this.handleInsert(n, string);
                    return;
                }
                this.scratchValueNode(n);
                this.handleInsert(n, string);
                return;
            }
        }
    }

    public void registerScratchTag(ScratchTag scratchTag) {
    }

    public void scratchElement(ISourceElement iSourceElement) {
        INode iNode = iSourceElement.getParent();
        int n = iNode.indexOfChild(iSourceElement);
        ScratchTag scratchTag = new ScratchTag((IModelToSourceMapping)this.document_, (IXmlDocument)this.document_, ScratchTag.CLOSED_STATE, iSourceElement.getStart(), iSourceElement.getLength());
        ScratchTag scratchTag2 = null;
        if (iSourceElement.getEndTagStart() > -1) {
            scratchTag2 = new ScratchTag((IModelToSourceMapping)this.document_, (IXmlDocument)this.document_, ScratchTag.CLOSED_STATE, iSourceElement.getEndTagStart(), iSourceElement.getEndTagLength());
        }
        int n2 = -1;
        this.document_.removeChild(iNode, iSourceElement, false);
        if (scratchTag != null) {
            this.document_.addChild(iNode, scratchTag, n, false);
            ++n2;
        }
        int n3 = 0;
        while (n3 < iSourceElement.childCount()) {
            this.document_.addChild(iNode, iSourceElement.childAt(n3), n + n3 + 1, false);
            ++n2;
            ++n3;
        }
        if (scratchTag2 != null) {
            this.document_.addChild(iNode, scratchTag2, n + n2 + 1, false);
        }
    }

    public ScratchTag scratchValueNode(int n) {
        StringBuffer stringBuffer = this.document_.getSourceBuffer();
        ISourceNode iSourceNode = this.document_.sourceNodeAt(n, 0, 0);
        ISourceNode iSourceNode2 = this.document_.parentOf(n);
        ISourceNode iSourceNode3 = this.document_.sourceNodeBefore(n);
        ISourceNode iSourceNode4 = this.document_.sourceNodeAfter(n);
        logger_.debug((Object)("the containing node is: " + iSourceNode));
        logger_.debug((Object)("before:" + iSourceNode3));
        logger_.debug((Object)("after:" + iSourceNode4));
        logger_.debug((Object)("parent:" + iSourceNode2));
        if (iSourceNode3 instanceof DocumentRoot && iSourceNode2 instanceof DocumentRoot) {
            int n2 = this.document_.toString().length();
            if (iSourceNode4 != null) {
                n2 = iSourceNode4.getStart();
            }
            logger_.debug((Object)("nextend:" + n2));
            ScratchTag scratchTag = new ScratchTag((IModelToSourceMapping)this.document_, (IXmlDocument)this.document_, ScratchTag.TEXT_STATE, 0, n2);
            this.document_.addChild(this.document_.getRoot(), scratchTag, 0, false);
            return scratchTag;
        }
        if (iSourceNode != null) {
            logger_.debug((Object)("node start:" + iSourceNode.getStart() + " length:" + iSourceNode.getLength()));
        }
        if (iSourceNode3 != null) {
            logger_.debug((Object)("the preceding node is:" + iSourceNode3 + " start:" + iSourceNode3.getStart() + " length:" + iSourceNode3.getLength()));
        }
        if (iSourceNode4 != null) {
            logger_.debug((Object)("the following node is:" + iSourceNode4 + " start:" + iSourceNode4.getStart() + " length:" + iSourceNode4.getLength()));
        }
        logger_.debug((Object)("the parent is:" + iSourceNode2));
        if (stringBuffer.length() > n && stringBuffer.charAt(n) == '<') {
            iSourceNode4 = iSourceNode;
            iSourceNode = null;
        }
        if (iSourceNode4 != null && iSourceNode4.equals(iSourceNode)) {
            iSourceNode = iSourceNode4;
            iSourceNode4 = this.document_.sourceNodeAfter(iSourceNode4.getStart() + 1);
        }
        if (iSourceNode3 instanceof IValueNode && !(iSourceNode3 instanceof ScratchTag)) {
            iSourceNode = iSourceNode3;
            iSourceNode3 = this.document_.sourceNodeBefore(iSourceNode3.getStart());
        }
        if (iSourceNode4 instanceof XmlDocument.EndTagPlaceHolder) {
            iSourceNode2 = ((XmlDocument.EndTagPlaceHolder)iSourceNode4).getElement();
        }
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        if (iSourceNode3 == null) {
            n4 = 0;
        } else {
            n4 = iSourceNode3.getStart() + iSourceNode3.getLength();
            if (!iSourceNode3.equals(iSourceNode2)) {
                if (iSourceNode3 instanceof XmlDocument.EndTagPlaceHolder) {
                    iSourceNode3 = ((XmlDocument.EndTagPlaceHolder)iSourceNode3).getElement();
                }
                n3 = iSourceNode2.indexOfChild(iSourceNode3) + 1;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        n5 = iSourceNode4 == null ? stringBuffer.length() : iSourceNode4.getStart();
        if (iSourceNode != null) {
            this.document_.removeChild(iSourceNode2, iSourceNode, false);
        }
        if (iSourceNode != null && iSourceNode instanceof ITag) {
            n4 = iSourceNode.getStart();
            n5 = iSourceNode.getStart() + iSourceNode.getLength();
        }
        ScratchTag scratchTag = null;
        if (iSourceNode != null && iSourceNode instanceof ICDATANode) {
            scratchTag = new ScratchTag((IModelToSourceMapping)this.document_, (IXmlDocument)this.document_, ScratchTag.TEXT_STATE, n4, n5 - n4);
            this.document_.addChild(iSourceNode2, scratchTag, n3, false);
            scratchTag.revalidateState();
        } else {
            scratchTag = new ScratchTag((IModelToSourceMapping)this.document_, (IXmlDocument)this.document_, ScratchTag.TEXT_STATE, n4, n5 - n4);
            if (iSourceNode != null && iSourceNode instanceof ITag) {
                scratchTag.setCurrentState(ScratchTag.CLOSED_STATE);
            }
            scratchTag.setDocument(this.document_);
            this.document_.addChild(iSourceNode2, scratchTag, n3, false);
        }
        if (iSourceNode instanceof DTDDeclaration) {
            scratchTag.revalidateState();
        }
        return scratchTag;
    }

    protected void shiftTagPositions(int n, int n2) {
        SortedSet<ScratchTag> sortedSet = this.scratchTags_.tailSet(new ScratchTag((IModelToSourceMapping)this.document_, n, 0));
        Iterator iterator = sortedSet.iterator();
        ScratchTag scratchTag = null;
        while (iterator.hasNext()) {
            scratchTag = (ScratchTag)iterator.next();
            scratchTag.setStart(scratchTag.getStart() + n2);
        }
    }

    protected boolean updateTagLength(ScratchTag scratchTag, int n) {
        if (n < 1) {
            this.document_.removeChild(scratchTag.getParent(), scratchTag, false);
            this.document_.shiftNodes(scratchTag, 0 - scratchTag.getLength());
            scratchTag.setLength(n);
            return true;
        }
        this.document_.updateNodeLength(scratchTag, n);
        return false;
    }

    public void scratchNode(INode iNode) {
        if (iNode instanceof ISourceElement) {
            this.scratchElement((ISourceElement)iNode);
        }
        if (iNode instanceof ISourceNode) {
            this.scratchValueNode(((ISourceNode)iNode).getStart());
        }
    }
}

