/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.incremental;

import butterfly.xmlview.model.AttlistDeclaration;
import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.CDataNode;
import butterfly.xmlview.model.Comment;
import butterfly.xmlview.model.DTDDeclaration;
import butterfly.xmlview.model.DocumentDeclaration;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.ElementDeclaration;
import butterfly.xmlview.model.EntityDeclaration;
import butterfly.xmlview.model.NamespacePrefixMapping;
import butterfly.xmlview.model.Node;
import butterfly.xmlview.model.NotationDeclaration;
import butterfly.xmlview.model.ProcessingInstruction;
import butterfly.xmlview.model.interfaces.IAttributeInfo;
import butterfly.xmlview.model.interfaces.IMarker;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.ITagInfo;
import org.apache.log4j.Logger;

public class ScratchTagConverter {
    private static final Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.incremental.ScratchTagConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public ISourceNode convert(IScratchTag iScratchTag, IScratchTag iScratchTag2) {
        if (iScratchTag2 != null && iScratchTag2.equals(iScratchTag)) {
            iScratchTag2 = null;
        }
        int n = iScratchTag.getTagInfo().getType();
        Node node = null;
        switch (n) {
            case 7: {
                node = this.makeCData(iScratchTag, iScratchTag2);
                break;
            }
            case 31: {
                node = this.makeXmlDeclaration(iScratchTag, iScratchTag2);
                break;
            }
            case 8: {
                node = this.makeCData(iScratchTag, iScratchTag2);
                break;
            }
            case 5: {
                node = this.makeCData(iScratchTag, iScratchTag2);
                break;
            }
            case 3: {
                node = this.makeComment(iScratchTag, iScratchTag2);
                break;
            }
            case 9: {
                node = this.makeComment(iScratchTag, iScratchTag2);
                break;
            }
            case 10: {
                node = this.makeComment(iScratchTag, iScratchTag2);
                break;
            }
            case 0: {
                node = this.makeElement(iScratchTag, iScratchTag2);
                break;
            }
            case 1: {
                node = this.makeElement(iScratchTag, iScratchTag2);
                break;
            }
            case 2: {
                node = this.makeElement(iScratchTag, iScratchTag2);
                break;
            }
            case 4: {
                node = this.makeProcessingInstruction(iScratchTag);
                break;
            }
            case 11: {
                node = this.makeDoctypeDeclaration(iScratchTag, iScratchTag2);
                break;
            }
            case 16: {
                node = this.makeDoctypeDeclaration(iScratchTag, iScratchTag2);
                break;
            }
            case 13: {
                node = this.makeElementDeclaration(iScratchTag);
                break;
            }
            case 12: {
                node = this.makeAttributeList(iScratchTag);
                break;
            }
            case 6: {
                node = this.makeNotation(iScratchTag);
                break;
            }
            case 14: {
                node = this.makeEntity(iScratchTag);
            }
        }
        return node;
    }

    protected CDataNode makeCData(IScratchTag iScratchTag, IScratchTag iScratchTag2) {
        int n = iScratchTag.getStart();
        int n2 = 0;
        n2 = iScratchTag2 != null ? iScratchTag2.getStart() + iScratchTag2.getLength() - iScratchTag.getStart() : iScratchTag.getLength();
        CDataNode cDataNode = null;
        cDataNode = new CDataNode();
        cDataNode.setStart(n);
        cDataNode.setLength(n2);
        cDataNode.setData(iScratchTag.getMapping().getText(n, n2));
        return cDataNode;
    }

    protected DocumentDeclaration makeXmlDeclaration(IScratchTag iScratchTag, IScratchTag iScratchTag2) {
        int n = iScratchTag.getStart();
        int n2 = iScratchTag.getLength();
        DocumentDeclaration documentDeclaration = new DocumentDeclaration();
        IAttributeInfo iAttributeInfo = null;
        ITagInfo iTagInfo = iScratchTag.getTagInfo();
        int n3 = 0;
        while (n3 < iTagInfo.attributeCount()) {
            iAttributeInfo = iTagInfo.attributeAt(n3);
            documentDeclaration.setProperty(iAttributeInfo.getName(), iAttributeInfo.getValue());
            ++n3;
        }
        documentDeclaration.setStart(n);
        documentDeclaration.setLength(n2);
        return documentDeclaration;
    }

    protected Comment makeComment(IScratchTag iScratchTag, IScratchTag iScratchTag2) {
        int n = iScratchTag.getStart();
        int n2 = 0;
        n2 = iScratchTag2 != null ? iScratchTag2.getStart() + iScratchTag2.getLength() - iScratchTag.getStart() : iScratchTag.getLength();
        Comment comment = null;
        comment = new Comment(iScratchTag.getMapping().getText(n, n2));
        comment.setStart(n);
        comment.setLength(n2);
        return comment;
    }

    protected Element makeElement(IScratchTag iScratchTag, IScratchTag iScratchTag2) {
        int n = iScratchTag.getStart();
        int n2 = iScratchTag.getLength();
        int n3 = -1;
        int n4 = -1;
        if (iScratchTag2 != null) {
            n3 = iScratchTag2.getStart();
            n4 = iScratchTag2.getLength();
        }
        ITagInfo iTagInfo = iScratchTag.getTagInfo();
        Element element = new Element(iTagInfo.getName());
        element.setStart(n);
        element.setLength(n2);
        element.setEndTagLength(n4);
        element.setEndTagStart(n3);
        IAttributeInfo iAttributeInfo = null;
        int n5 = 0;
        while (n5 < iTagInfo.attributeCount()) {
            iAttributeInfo = iTagInfo.attributeAt(n5);
            Attribute attribute = null;
            if (!iAttributeInfo.getName().startsWith("xmlns:")) {
                attribute = new Attribute(element, iAttributeInfo.getName());
                attribute.setData(iAttributeInfo.getValue());
            } else {
                String string = NamespacePrefixMapping.parsePrefix(iAttributeInfo.getName());
                attribute = new NamespacePrefixMapping(string, iAttributeInfo.getValue());
            }
            element.addAttribute(attribute);
            ++n5;
        }
        IMarker[] iMarkerArray = iTagInfo.getMarkers();
        int n6 = 0;
        while (n6 < iMarkerArray.length) {
            element.addMarker(iMarkerArray[n6]);
            ++n6;
        }
        return element;
    }

    protected ProcessingInstruction makeProcessingInstruction(IScratchTag iScratchTag) {
        int n = iScratchTag.getStart();
        int n2 = iScratchTag.getLength();
        ProcessingInstruction processingInstruction = new ProcessingInstruction();
        processingInstruction.setTarget(iScratchTag.getTagInfo().getName());
        processingInstruction.setStart(n);
        processingInstruction.setLength(n2);
        processingInstruction.setValue(iScratchTag.getTagInfo().getData());
        return processingInstruction;
    }

    protected DTDDeclaration makeDoctypeDeclaration(IScratchTag iScratchTag, IScratchTag iScratchTag2) {
        ITagInfo iTagInfo = iScratchTag.getTagInfo();
        DTDDeclaration dTDDeclaration = null;
        String string = iTagInfo.getProperty("SYSTEM");
        String string2 = iTagInfo.getProperty("PUBLIC");
        if (string != null && string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string2 != null && string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        dTDDeclaration = new DTDDeclaration(iTagInfo.getProperty("DOCTYPE"), string2, string);
        int n = iScratchTag.getStart();
        int n2 = iScratchTag.getText().indexOf("[") + 1;
        if (n2 == 0) {
            dTDDeclaration.setStart(n);
            dTDDeclaration.setLength(iScratchTag.getText().length());
        } else {
            int n3 = -1;
            int n4 = -1;
            if (iScratchTag2 != null && !iScratchTag2.equals(iScratchTag)) {
                n3 = iScratchTag2.getStart();
                n4 = iScratchTag2.getLength();
            } else {
                n3 = n + iScratchTag.getText().lastIndexOf("]>");
                n4 = 2;
            }
            dTDDeclaration.setStart(n);
            dTDDeclaration.setLength(n2);
            dTDDeclaration.setEndTagStart(n3);
            dTDDeclaration.setEndTagLength(n4);
        }
        return dTDDeclaration;
    }

    protected ElementDeclaration makeElementDeclaration(IScratchTag iScratchTag) {
        int n = iScratchTag.getStart();
        int n2 = iScratchTag.getLength();
        String string = iScratchTag.getTagInfo().getProperty("ELEMENT");
        String string2 = iScratchTag.getTagInfo().getProperty("CONTENT_MODEL");
        ElementDeclaration elementDeclaration = new ElementDeclaration(string, string2);
        elementDeclaration.setStart(n);
        elementDeclaration.setLength(n2);
        return elementDeclaration;
    }

    protected NotationDeclaration makeNotation(IScratchTag iScratchTag) {
        iScratchTag.getStart();
        iScratchTag.getLength();
        ITagInfo iTagInfo = iScratchTag.getTagInfo();
        NotationDeclaration notationDeclaration = new NotationDeclaration(iTagInfo.getName(), iTagInfo.getProperty("IDENTIFIER_TYPE"), iTagInfo.getProperty("IDENTIFIER"), iTagInfo.getProperty("HELPER"));
        notationDeclaration.setStart(iScratchTag.getStart());
        notationDeclaration.setLength(iScratchTag.getLength());
        logger_.debug((Object)("converted to:" + notationDeclaration));
        return notationDeclaration;
    }

    protected EntityDeclaration makeEntity(IScratchTag iScratchTag) {
        iScratchTag.getStart();
        iScratchTag.getLength();
        ITagInfo iTagInfo = iScratchTag.getTagInfo();
        EntityDeclaration entityDeclaration = new EntityDeclaration();
        entityDeclaration.setName(iTagInfo.getName());
        entityDeclaration.setParameterEntity(iTagInfo.getProperty("PARAMETER_ENTITY") != null);
        entityDeclaration.setHelper(iTagInfo.getProperty("HELPER"));
        entityDeclaration.setCharCode(iTagInfo.getProperty("CHARCODE"));
        entityDeclaration.setIdentifier(iTagInfo.getProperty("IDENTIFIER"));
        entityDeclaration.setIdentifierType(iTagInfo.getProperty("IDENTIFIER_TYPE"));
        entityDeclaration.setStart(iScratchTag.getStart());
        entityDeclaration.setLength(iScratchTag.getLength());
        logger_.debug((Object)("converted to:" + entityDeclaration));
        return entityDeclaration;
    }

    protected AttlistDeclaration makeAttributeList(IScratchTag iScratchTag) {
        iScratchTag.getStart();
        iScratchTag.getLength();
        ITagInfo iTagInfo = iScratchTag.getTagInfo();
        AttlistDeclaration attlistDeclaration = new AttlistDeclaration(iTagInfo.getName());
        int n = 0;
        while (n < iTagInfo.attributeCount()) {
            attlistDeclaration.addAttribute(iTagInfo.attributeAt(n));
            ++n;
        }
        attlistDeclaration.setStart(iScratchTag.getStart());
        attlistDeclaration.setLength(iScratchTag.getLength());
        logger_.debug((Object)("converted to:" + attlistDeclaration));
        return attlistDeclaration;
    }
}

