/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.incremental;

import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.incremental.MatchingElementBreakClass;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.INodeClass;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.ISourceNode;
import org.apache.log4j.Logger;

public class ScratchTagMatcher {
    private IScratchTag scratchTag_;
    private INodeClass matchingNodeClass_;
    private INodeClass breakingClass_;
    private boolean matchBackwards_ = false;
    private boolean matchAcrossParents_ = false;
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.incremental.ScratchTagMatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public ScratchTagMatcher() {
    }

    public ScratchTagMatcher(IScratchTag iScratchTag) {
        this.scratchTag_ = iScratchTag;
        this.matchingNodeClass_ = iScratchTag.getMatchingNodeClass();
        this.breakingClass_ = new MatchingElementBreakClass(iScratchTag);
        int n = iScratchTag.getTagInfo().getType();
        if (n == 8 || n == 10 || n == 1 || n == 15) {
            this.matchBackwards_ = true;
        }
        if (n == 8 || n == 7 || n == 10 || n == 9) {
            this.matchAcrossParents_ = true;
            ((MatchingElementBreakClass)this.breakingClass_).setAcceptsSiblingsOnly(false);
        }
    }

    public INodeClass getMatchingNodeClass() {
        return this.matchingNodeClass_;
    }

    public IScratchTag getScratchTag() {
        return this.scratchTag_;
    }

    public INode match() {
        if (this.matchingNodeClass_.accepts(this.scratchTag_)) {
            return this.scratchTag_;
        }
        ISourceNode iSourceNode = this.next(this.scratchTag_);
        while (iSourceNode != null) {
            if (this.matchingNodeClass_.accepts(iSourceNode)) {
                return iSourceNode;
            }
            if (this.breakingClass_ != null && this.breakingClass_.accepts(iSourceNode)) {
                return null;
            }
            iSourceNode = this.next(iSourceNode);
        }
        INode iNode = this.scratchTag_.getParent();
        if (this.matchingNodeClass_.accepts(iNode)) {
            return iNode;
        }
        return iSourceNode;
    }

    protected ISourceNode next(ISourceNode iSourceNode) {
        if (this.matchAcrossParents_) {
            XmlDocument xmlDocument = (XmlDocument)this.scratchTag_.getDocument();
            ScratchTag scratchTag = null;
            scratchTag = !this.matchBackwards_ ? xmlDocument.scratchTagAfter(iSourceNode.getStart() + iSourceNode.getLength()) : xmlDocument.scratchTagBefore(iSourceNode);
            return scratchTag;
        }
        INode iNode = this.scratchTag_.getParent();
        if (!this.matchBackwards_) {
            int n = iNode.indexOfChild(iSourceNode);
            if (n < iNode.childCount() - 1) {
                ++n;
            } else {
                return null;
            }
            INode iNode2 = null;
            while (n < iNode.childCount()) {
                iNode2 = iNode.childAt(n);
                if (iNode2 instanceof IScratchTag) {
                    return (IScratchTag)iNode2;
                }
                ++n;
            }
        } else {
            int n = iNode.indexOfChild(iSourceNode);
            if (n > 0) {
                --n;
            } else {
                return null;
            }
            INode iNode3 = null;
            while (n >= 0) {
                iNode3 = iNode.childAt(n);
                if (iNode3 instanceof IScratchTag) {
                    return (IScratchTag)iNode3;
                }
                --n;
            }
        }
        return null;
    }

    public void setMatchBackwards(boolean bl) {
        this.matchBackwards_ = bl;
    }

    public void setMatchingNodeClass(INodeClass iNodeClass) {
        this.matchingNodeClass_ = iNodeClass;
    }

    public void setScratchTag(IScratchTag iScratchTag) {
        this.scratchTag_ = iScratchTag;
    }
}

