/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.incremental;

import butterfly.xmlview.model.AttributeInfo;
import butterfly.xmlview.model.AttributeParser;
import butterfly.xmlview.model.DocumentRoot;
import butterfly.xmlview.model.PrefixMappingWarningMarker;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.TagInfo;
import butterfly.xmlview.model.incremental.AttlistAcceptor;
import butterfly.xmlview.model.incremental.DoctypeAcceptor;
import butterfly.xmlview.model.incremental.EntityDeclarationAcceptor;
import butterfly.xmlview.model.incremental.NotationAcceptor;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTagState;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class StatelessScratchTagParser {
    private static final Logger logger_;
    static int START_STATE;
    static int OPEN_PAREN_STATE;
    static int CLOSE_PAREN_STATE;
    static int NO_CM_STATE;
    static int TYPE_STATE;
    static int QUANTIFIER_STATE;
    static int COMMA_STATE;
    static int ERROR_STATE;
    static int OR_STATE;
    static int OPEN_PAREN_TYPE;
    static int CLOSE_PAREN_TYPE;
    static int COMMA_TYPE;
    static int QUANTIFIER_TYPE;
    static int ALPHA_TYPE;
    static int ALPHA_NUMERIC_TYPE;
    static int OR_TYPE;
    private static int[][] cmStates_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.incremental.StatelessScratchTagParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        START_STATE = 0;
        OPEN_PAREN_STATE = 1;
        CLOSE_PAREN_STATE = 7;
        NO_CM_STATE = 2;
        TYPE_STATE = 3;
        QUANTIFIER_STATE = 4;
        COMMA_STATE = 5;
        ERROR_STATE = 6;
        OR_STATE = 8;
        OPEN_PAREN_TYPE = 0;
        CLOSE_PAREN_TYPE = 1;
        COMMA_TYPE = 2;
        QUANTIFIER_TYPE = 3;
        ALPHA_TYPE = 4;
        ALPHA_NUMERIC_TYPE = 5;
        OR_TYPE = 6;
    }

    protected boolean isCDATAStart(String string) {
        return string.startsWith("<![CDATA[");
    }

    protected boolean isValidIdentifier(String string) {
        char c = ' ';
        int n = 0;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(Character.isLetterOrDigit(c) || c == ' ' || c != ' ' && c != '<' && c != '>' && c != '{' && c != '}' && c != ';' && c != '&' && c != '@' && c != '(' && c != ')' && c != '=' && c != '\"' && c != '[' && c != ']' && c != '!')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized TagInfo parse(ScratchTag scratchTag) {
        String string = scratchTag.getText();
        IScratchTagState iScratchTagState = scratchTag.getCurrentState();
        TagInfo tagInfo = null;
        if (scratchTag.isLocked()) {
            tagInfo = null;
            return null;
        }
        if (string.startsWith("<?xml ")) {
            tagInfo = new TagInfo(31);
            if (scratchTag.getCurrentState() == ScratchTag.CLOSED_STATE) {
                return this.parseXmlDeclaration(scratchTag);
            }
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("Missing \"?>\"");
            return tagInfo;
        }
        if (string.startsWith("<!--")) {
            tagInfo = new TagInfo(9);
            if (string.endsWith("-->")) {
                tagInfo.setValid(true);
                tagInfo.setType(3);
                return tagInfo;
            }
            tagInfo.setValid(true);
            tagInfo.setErrorMessage("The comment does not have a matching \"-->\"");
            return tagInfo;
        }
        if (this.isCDATAStart(string)) {
            if (string.endsWith("]]>")) {
                tagInfo = new TagInfo(5);
                tagInfo.setValid(true);
                return tagInfo;
            }
            tagInfo = new TagInfo(5);
            tagInfo.setType(7);
            tagInfo.setErrorMessage("The CDATA section does not have an ending \"]]>\"");
            tagInfo.setValid(true);
            return tagInfo;
        }
        if (string.endsWith("]]>")) {
            tagInfo = new TagInfo(5);
            tagInfo.setType(8);
            tagInfo.setValid(true);
            return tagInfo;
        }
        if (string.trim().equals("]>")) {
            tagInfo = new TagInfo(15);
            tagInfo.setValid(true);
            tagInfo.setErrorMessage("There is not a matching \"<!DOCTYPE\"");
            return tagInfo;
        }
        if (string.endsWith("-->")) {
            tagInfo = new TagInfo(10);
            tagInfo.setValid(true);
            tagInfo.setErrorMessage("The comment end mark does not have a matching \"<!--\"");
            return tagInfo;
        }
        if (scratchTag.getParent() instanceof IDTDNode && !string.startsWith("<!--") && !string.startsWith("<![CDATA")) {
            return this.parseDTD(scratchTag);
        }
        if (string.startsWith("<!")) {
            if (string.startsWith("<!DOCTYPE")) {
                if (scratchTag.getParent() instanceof DocumentRoot) {
                    if (((DocumentRoot)scratchTag.getParent()).hasDTD()) {
                        TagInfo tagInfo2 = new TagInfo(16);
                        tagInfo2.setValid(false);
                        tagInfo2.setErrorMessage("A DTD is already declared for this document");
                        return tagInfo2;
                    }
                    IElement iElement = ((DocumentRoot)scratchTag.getParent()).firstElement();
                    if (iElement != null) {
                        int n = scratchTag.getParent().indexOfChild(iElement);
                        int n2 = scratchTag.getParent().indexOfChild(scratchTag);
                        if (n2 > n) {
                            TagInfo tagInfo3 = new TagInfo(16);
                            tagInfo3.setValid(false);
                            tagInfo3.setErrorMessage("A DTD must be declared before the root element of a document");
                            return tagInfo3;
                        }
                    }
                    return this.parseDoctype(scratchTag);
                }
                TagInfo tagInfo4 = new TagInfo(16);
                tagInfo4.setValid(false);
                tagInfo4.setErrorMessage("A DTD must be declared before the root element of a document");
                return tagInfo4;
            }
            if (iScratchTagState == ScratchTag.TEXT_STATE) {
                tagInfo = null;
                return tagInfo;
            }
        }
        if (!iScratchTagState.equals(ScratchTag.CLOSED_STATE)) {
            tagInfo = null;
            return tagInfo;
        }
        if (string.toLowerCase().startsWith("<?xml")) {
            return this.parseXmlDeclaration(scratchTag);
        }
        String string2 = string;
        string2 = string2.substring(1, string2.length() - 1);
        string2 = string2.trim();
        if (string.trim().startsWith("<!--")) {
            tagInfo = new TagInfo(3);
            tagInfo.setValid(true);
            if (!string.trim().endsWith("-->")) {
                tagInfo.setValid(false);
                tagInfo.setErrorMessage("Comments must end with \"-->\"");
            }
            return tagInfo;
        }
        tagInfo = null;
        if (string2.length() < 1) {
            tagInfo = new TagInfo(0);
            tagInfo.setErrorMessage("The tag's name is invalid.");
            tagInfo.setValid(false);
            return tagInfo;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " =\"'/?[", true);
        String string3 = stringTokenizer.nextToken();
        tagInfo = new TagInfo(0);
        tagInfo.setValid(true);
        if (string3.equals("/")) {
            tagInfo.setType(1);
            if (!stringTokenizer.hasMoreTokens()) {
                tagInfo.setErrorMessage("The tag's name is invalid.");
                tagInfo.setValid(false);
                return tagInfo;
            }
            string3 = stringTokenizer.nextToken();
        }
        if (string3.equals("?")) {
            tagInfo.setType(4);
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (!this.isValidIdentifier(string3)) {
                    tagInfo.setErrorMessage("The name of the processing instruction's target is invalid.");
                    tagInfo.setValid(false);
                    return tagInfo;
                }
                tagInfo.setName(string3);
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    bl = string3.equals("?");
                }
                if (!bl) {
                    tagInfo.setErrorMessage("The processing instruction must end with \"?>\". '" + string3 + "'");
                    tagInfo.setValid(false);
                    return tagInfo;
                }
                tagInfo.setData(stringBuffer.toString());
                return tagInfo;
            }
            tagInfo.setErrorMessage("The processing instruction must begin with the name of the target.");
            tagInfo.setValid(false);
            return tagInfo;
        }
        if (!string3.equals("!")) {
            String string4;
            int n;
            if (!this.isValidIdentifier(string3)) {
                tagInfo.setErrorMessage("The tag's name is invalid.");
                tagInfo.setValid(false);
                return tagInfo;
            }
            tagInfo.setName(string3.trim());
            int n3 = 0;
            int n4 = 6;
            int n5 = 5;
            int n6 = 1;
            int n7 = 2;
            int n8 = 4;
            int n9 = n5;
            Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            AttributeInfo attributeInfo = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (n9 != n4 && n9 != n5 && string3.trim().length() < 1) continue;
                if (n9 == n3) {
                    if (string3.equals("/")) {
                        if (tagInfo.getType() != 1) {
                            tagInfo.setType(2);
                            n9 = n8;
                            continue;
                        }
                        tagInfo.setErrorMessage("Unexpected \"/\" encountered");
                        tagInfo.setValid(false);
                        return tagInfo;
                    }
                    if (!this.isValidIdentifier(string3)) {
                        tagInfo.setErrorMessage("Invalid attribute name: " + string3);
                        tagInfo.setValid(false);
                        return tagInfo;
                    }
                    attributeInfo = new AttributeInfo();
                    attributeInfo.name = string3;
                    n9 = n6;
                    continue;
                }
                if (n9 == n6) {
                    if (!string3.equals("=")) {
                        tagInfo.setErrorMessage("Missing \"=\" after attribute name");
                        tagInfo.setValid(false);
                        return tagInfo;
                    }
                    n9 = n7;
                    continue;
                }
                if (n9 == n7) {
                    if (string3.equals("\"") || string3.equals("'")) {
                        if (string3.equals("'")) {
                            bl = true;
                        }
                        n9 = n4;
                        continue;
                    }
                    tagInfo.setErrorMessage("Missing \"\"\" after the attribute named: " + attributeInfo.name);
                    tagInfo.setValid(false);
                    return tagInfo;
                }
                if (n9 == n4) {
                    if (string3.equals("\"") || bl && string3.equals("'")) {
                        String string5;
                        if (bl && string3.equals("\"")) {
                            string5 = "\"";
                            if (!bl) {
                                string5 = "'";
                            }
                            tagInfo.setErrorMessage("Unexpected \"" + string5 + "\" after the attribute named: " + attributeInfo.name);
                            tagInfo.setValid(false);
                            return tagInfo;
                        }
                        bl = false;
                        n9 = n5;
                        attributeInfo.value = stringBuffer.toString();
                        stringBuffer.delete(0, stringBuffer.length());
                        if (attributeInfo.name.startsWith("xmlns:")) {
                            string5 = "default";
                            int n10 = attributeInfo.name.indexOf(58);
                            if (n10 > -1) {
                                string5 = attributeInfo.name.substring(n10 + 1);
                            }
                            hashtable.put(string5, attributeInfo.value);
                        }
                        if (tagInfo.getAttribute(attributeInfo.getName()) != null) {
                            tagInfo.setErrorMessage("Duplicate attribute declaration:" + attributeInfo.getName());
                            tagInfo.setValid(false);
                            return tagInfo;
                        }
                        tagInfo.addAttribute(attributeInfo);
                        attributeInfo = null;
                        continue;
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                if (n9 == n5) {
                    if (string3.equals("/")) {
                        if (tagInfo.getType() != 1) {
                            tagInfo.setType(2);
                            n9 = n8;
                            continue;
                        }
                        tagInfo.setErrorMessage("Unexpected \"/\" encountered");
                        tagInfo.setValid(false);
                        return tagInfo;
                    }
                    if (string3.equals(" ") || string3.equals("\n") || string3.trim().length() < 1) {
                        n9 = n3;
                        continue;
                    }
                    tagInfo.setErrorMessage("Unexpected text: \"" + string3 + "\"");
                    tagInfo.setValid(false);
                    return tagInfo;
                }
                if (n9 != n8) continue;
                tagInfo.setErrorMessage("Nothing expected after \"/\"");
                tagInfo.setValid(false);
                return tagInfo;
            }
            if (n9 == n4) {
                tagInfo.setErrorMessage("Unmatched \"\"\" after the attribute: " + attributeInfo.name);
                tagInfo.setValid(false);
                return tagInfo;
            }
            if (n9 == n7) {
                tagInfo.setErrorMessage("Missing value for the attribute: " + attributeInfo.name);
                tagInfo.setValid(false);
                return tagInfo;
            }
            if (n9 == n6) {
                tagInfo.setErrorMessage("Missing \"=\" after the attribute: " + attributeInfo.name);
                tagInfo.setValid(false);
                return tagInfo;
            }
            if (string.trim().endsWith("/>")) {
                tagInfo.setType(2);
            }
            if (!tagInfo.isEndTag() && (n = tagInfo.getName().indexOf(58)) > -1 && hashtable.get(string4 = tagInfo.getName().substring(0, n)) == null) {
                INode iNode = scratchTag.getParent();
                if (iNode instanceof IElement) {
                    String string6 = ((IElement)iNode).resolvePrefix(string4);
                    if (string6 == null) {
                        String string7 = "Undefined namespace prefix:" + string4;
                        tagInfo.addMarker(new PrefixMappingWarningMarker(string7));
                    }
                } else {
                    String string8 = "Undefined namespace prefix:" + string4;
                    tagInfo.addMarker(new PrefixMappingWarningMarker(string8));
                }
            }
            return tagInfo;
        }
        return tagInfo;
    }

    public ParseResult parseAttribute(StringTokenizer stringTokenizer) {
        ParseResult parseResult = new ParseResult();
        int n = stringTokenizer.countTokens();
        if (n < 1) {
            parseResult.valid = false;
            parseResult.value = "No attribute name specified";
            return parseResult;
        }
        if (n < 2) {
            parseResult.valid = false;
            parseResult.value = "No attribute type specified";
            return parseResult;
        }
        if (n < 3) {
            parseResult.valid = false;
            parseResult.value = "No default value for the attribute specified";
            return parseResult;
        }
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith("(") && !string2.endsWith(")")) {
            boolean bl = false;
            while (stringTokenizer.countTokens() > 1) {
                if (!(string2 = String.valueOf(string2) + stringTokenizer.nextToken()).endsWith(")")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                parseResult.valid = false;
                parseResult.value = "Missing \")\" after attribute type";
                return parseResult;
            }
        }
        String string3 = stringTokenizer.nextToken();
        Attribute attribute = new Attribute();
        if (!this.isValidIdentifier(string)) {
            parseResult.valid = false;
            parseResult.value = String.valueOf(string) + " is not a valid attribute name";
            return parseResult;
        }
        attribute.name = string;
        attribute.type = string2;
        if (string3.equals("#FIXED")) {
            if (stringTokenizer.hasMoreTokens()) {
                attribute.fixed = true;
                string3 = stringTokenizer.nextToken();
            } else {
                parseResult.valid = false;
                parseResult.value = "#FIXED must be followed by a value";
                return parseResult;
            }
        }
        if (!(string3.equals("#REQUIRED") || string3.equals("#IMPLIED") || string3.equals("#FIXED"))) {
            if (string3.startsWith("\"")) {
                if (!string3.endsWith("\"")) {
                    parseResult.valid = false;
                    parseResult.value = "Missing \"\"\" after the attribute's default value";
                    return parseResult;
                }
            } else {
                parseResult.valid = false;
                parseResult.value = "Missing \"\"\" before the attribute's default value";
                return parseResult;
            }
        }
        attribute.defaultvalue = string3;
        parseResult.valid = true;
        parseResult.data = attribute;
        return parseResult;
    }

    public TagInfo parseNotationDeclaration(ScratchTag scratchTag) {
        TagInfo tagInfo = new TagInfo(6);
        NotationAcceptor notationAcceptor = new NotationAcceptor();
        String string = scratchTag.getText();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            notationAcceptor.accept(c);
            if (notationAcceptor.getState() == -1) {
                tagInfo.setValid(false);
                break;
            }
            ++n;
        }
        tagInfo.setValid(notationAcceptor.getState() == 1);
        if (tagInfo.isValid()) {
            tagInfo.setName(notationAcceptor.getName());
            tagInfo.setProperty("IDENTIFIER", notationAcceptor.getIdentifier());
            tagInfo.setProperty("IDENTIFIER_TYPE", notationAcceptor.getIdentifierType());
            tagInfo.setProperty("HELPER", notationAcceptor.getHelper());
        }
        return tagInfo;
    }

    public TagInfo parseAttributeListDeclaration(ScratchTag scratchTag) {
        TagInfo tagInfo = new TagInfo(12);
        AttlistAcceptor attlistAcceptor = new AttlistAcceptor();
        String string = scratchTag.getText();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            attlistAcceptor.accept(c);
            if (attlistAcceptor.getState() == -1) {
                tagInfo.setValid(false);
                break;
            }
            ++n;
        }
        tagInfo.setValid(attlistAcceptor.getState() == 1);
        if (tagInfo.isValid()) {
            String string2 = attlistAcceptor.getElementName();
            AttributeInfo[] attributeInfoArray = attlistAcceptor.getAttributes();
            tagInfo.setName(string2);
            int n2 = 0;
            while (n2 < attributeInfoArray.length) {
                tagInfo.addAttribute(attributeInfoArray[n2]);
                ++n2;
            }
        }
        return tagInfo;
    }

    public static int[][] getCMStates() {
        if (cmStates_ == null) {
            int[][] nArray = new int[9][7];
            nArray[StatelessScratchTagParser.START_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = OPEN_PAREN_STATE;
            nArray[StatelessScratchTagParser.START_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.START_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.START_STATE][StatelessScratchTagParser.COMMA_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.START_STATE][StatelessScratchTagParser.OR_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.START_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OPEN_PAREN_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = OPEN_PAREN_STATE;
            nArray[StatelessScratchTagParser.OPEN_PAREN_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = CLOSE_PAREN_STATE;
            nArray[StatelessScratchTagParser.OPEN_PAREN_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OPEN_PAREN_STATE][StatelessScratchTagParser.COMMA_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OPEN_PAREN_STATE][StatelessScratchTagParser.OR_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OPEN_PAREN_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = TYPE_STATE;
            nArray[StatelessScratchTagParser.CLOSE_PAREN_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.CLOSE_PAREN_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = CLOSE_PAREN_STATE;
            nArray[StatelessScratchTagParser.CLOSE_PAREN_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = QUANTIFIER_STATE;
            nArray[StatelessScratchTagParser.CLOSE_PAREN_STATE][StatelessScratchTagParser.COMMA_TYPE] = COMMA_STATE;
            nArray[StatelessScratchTagParser.CLOSE_PAREN_STATE][StatelessScratchTagParser.OR_TYPE] = OR_STATE;
            nArray[StatelessScratchTagParser.CLOSE_PAREN_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.TYPE_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.TYPE_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = CLOSE_PAREN_STATE;
            nArray[StatelessScratchTagParser.TYPE_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = QUANTIFIER_STATE;
            nArray[StatelessScratchTagParser.TYPE_STATE][StatelessScratchTagParser.COMMA_TYPE] = COMMA_STATE;
            nArray[StatelessScratchTagParser.TYPE_STATE][StatelessScratchTagParser.OR_TYPE] = OR_STATE;
            nArray[StatelessScratchTagParser.TYPE_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = TYPE_STATE;
            nArray[StatelessScratchTagParser.OR_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = OPEN_PAREN_STATE;
            nArray[StatelessScratchTagParser.OR_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OR_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OR_STATE][StatelessScratchTagParser.COMMA_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OR_STATE][StatelessScratchTagParser.OR_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.OR_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = TYPE_STATE;
            nArray[StatelessScratchTagParser.COMMA_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = OPEN_PAREN_STATE;
            nArray[StatelessScratchTagParser.COMMA_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.COMMA_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.COMMA_STATE][StatelessScratchTagParser.COMMA_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.COMMA_STATE][StatelessScratchTagParser.OR_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.COMMA_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = TYPE_STATE;
            nArray[StatelessScratchTagParser.QUANTIFIER_STATE][StatelessScratchTagParser.OPEN_PAREN_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.QUANTIFIER_STATE][StatelessScratchTagParser.CLOSE_PAREN_TYPE] = CLOSE_PAREN_STATE;
            nArray[StatelessScratchTagParser.QUANTIFIER_STATE][StatelessScratchTagParser.QUANTIFIER_TYPE] = ERROR_STATE;
            nArray[StatelessScratchTagParser.QUANTIFIER_STATE][StatelessScratchTagParser.COMMA_TYPE] = COMMA_STATE;
            nArray[StatelessScratchTagParser.QUANTIFIER_STATE][StatelessScratchTagParser.OR_TYPE] = OR_STATE;
            nArray[StatelessScratchTagParser.QUANTIFIER_STATE][StatelessScratchTagParser.ALPHA_NUMERIC_TYPE] = ERROR_STATE;
            cmStates_ = nArray;
        }
        return cmStates_;
    }

    protected ParseResult parseCM(StringTokenizer stringTokenizer) {
        ParseResult parseResult = new ParseResult();
        parseResult.valid = true;
        StringBuffer stringBuffer = new StringBuffer();
        int[][] nArray = StatelessScratchTagParser.getCMStates();
        if (stringTokenizer.hasMoreTokens()) {
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = START_STATE;
            int n2 = 0;
            int n3 = -1;
            block0: while (stringTokenizer.hasMoreTokens() && !bl2) {
                string = stringTokenizer.nextToken();
                if (string.equals("EMPTY")) {
                    parseResult.valid = true;
                    parseResult.value = "EMPTY";
                    return parseResult;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, "(),|?*+>", true);
                while (stringTokenizer2.hasMoreTokens()) {
                    string = stringTokenizer2.nextToken();
                    n3 = this.getCMType(string);
                    if (string.equals(">") && !bl) {
                        bl = true;
                        continue block0;
                    }
                    if (bl && string.equals(">")) {
                        parseResult.valid = false;
                        parseResult.value = "Unexpected \">\" inside content model";
                        bl2 = true;
                        continue block0;
                    }
                    stringBuffer.append(string);
                    if (n3 == OPEN_PAREN_TYPE) {
                        ++n2;
                    } else if (n3 == CLOSE_PAREN_TYPE) {
                        --n2;
                    } else if (n3 == -1) {
                        parseResult.value = "Unexpected \"" + string + "\"";
                        bl2 = true;
                        continue block0;
                    }
                    n = nArray[n][n3];
                    if (n != ERROR_STATE) continue;
                    parseResult.valid = false;
                    parseResult.value = "Unexpected \"" + string + "\"";
                    bl2 = true;
                    continue block0;
                }
            }
            boolean bl3 = parseResult.valid = parseResult.valid && n2 == 0 && (n == CLOSE_PAREN_STATE || n == QUANTIFIER_STATE);
            if (n2 > 0) {
                parseResult.value = "Unmatched \"(\"";
            }
            if (n2 < 0) {
                parseResult.value = "Unmatched \")\"";
            }
            if (parseResult.valid) {
                parseResult.value = stringBuffer.toString();
            }
            return parseResult;
        }
        parseResult.valid = false;
        parseResult.value = "No content model";
        return parseResult;
    }

    public int getCMType(String string) {
        char c = string.charAt(0);
        if (Character.isLetterOrDigit(c) || c == '#') {
            return ALPHA_NUMERIC_TYPE;
        }
        if (c == '(') {
            return OPEN_PAREN_TYPE;
        }
        if (c == ')') {
            return CLOSE_PAREN_TYPE;
        }
        if (c == ',') {
            return COMMA_TYPE;
        }
        if (c == '|') {
            return OR_TYPE;
        }
        if (c == '?' || c == '*' || c == '+') {
            return QUANTIFIER_TYPE;
        }
        return -1;
    }

    public TagInfo parseXmlDeclaration(ScratchTag scratchTag) {
        TagInfo tagInfo = new TagInfo(31);
        tagInfo.setName("xml");
        tagInfo.setValid(true);
        String string = scratchTag.getText();
        int n = string.indexOf("xml") + 3;
        int n2 = scratchTag.getText().lastIndexOf("?");
        tagInfo.setData(string);
        INode iNode = scratchTag.getParent();
        if (!iNode.getDocument().getRoot().equals(iNode) || iNode.indexOfChild(scratchTag) != 0) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("The XML declaration must be at the begining of an XML document.");
            return tagInfo;
        }
        String string2 = scratchTag.getText().substring(n, n2);
        AttributeParser attributeParser = new AttributeParser(string2);
        AttributeInfo[] attributeInfoArray = attributeParser.parse();
        String string3 = null;
        int n3 = 0;
        while (n3 < attributeInfoArray.length) {
            boolean bl = false;
            if (attributeInfoArray[n3].valid) {
                if (attributeInfoArray[n3].name.equalsIgnoreCase("version") || attributeInfoArray[n3].name.equalsIgnoreCase("standalone") || attributeInfoArray[n3].name.equalsIgnoreCase("encoding")) {
                    bl = true;
                    tagInfo.addAttribute(attributeInfoArray[n3]);
                } else {
                    bl = false;
                    string3 = "The attribute " + attributeInfoArray[n3].name + " is not allowed in the XML declaration.";
                }
            } else {
                string3 = attributeInfoArray[n3].name;
            }
            if (!bl) {
                tagInfo.setValid(false);
                tagInfo.setErrorMessage(string3);
            }
            ++n3;
        }
        return tagInfo;
    }

    public TagInfo parseDoctype(ScratchTag scratchTag) {
        String string = scratchTag.getText();
        if (scratchTag.getCurrentState() == ScratchTag.CLOSED_STATE && string.indexOf("[") < 0) {
            logger_.debug((Object)"Checking closed doctype");
            TagInfo tagInfo = new TagInfo(16);
            DoctypeAcceptor doctypeAcceptor = new DoctypeAcceptor();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                doctypeAcceptor.accept(c);
                if (doctypeAcceptor.getState() == -1) {
                    tagInfo.setValid(false);
                    tagInfo.setErrorMessage("The DOCTYPE declaration contains errors");
                    logger_.debug((Object)"invalid doctype");
                    return tagInfo;
                }
                ++n;
            }
            if (doctypeAcceptor.getState() == 1) {
                tagInfo.setProperty("DOCTYPE", doctypeAcceptor.getName());
                tagInfo.setName("<!DOCTYPE");
                tagInfo.setProperty("SYSTEM", doctypeAcceptor.getSystemID());
                tagInfo.setProperty("PUBLIC", doctypeAcceptor.getPublicID1());
                tagInfo.setValid(true);
                logger_.debug((Object)"valid doctype");
                return tagInfo;
            }
            tagInfo.setErrorMessage("The DOCTYPE declaration is incomplete");
            tagInfo.setValid(false);
            logger_.debug((Object)"incomplete doctype");
            return tagInfo;
        }
        int n = string.indexOf("<!DOCTYPE");
        String string2 = string.substring(n += 9);
        Tokenizer tokenizer = new Tokenizer(string2, " [\">", true);
        TagInfo tagInfo = new TagInfo(11);
        tagInfo.setErrorMessage("A DOCTYPE declaration must end with \"]>\"");
        if (string.endsWith("]>") || string.indexOf("]") < 0 && string.indexOf("[") < 0) {
            tagInfo.setType(16);
            tagInfo.setErrorMessage("The DOCTYPE declaration contains errors");
        }
        tagInfo.setName("<!DOCTYPE");
        if (!tokenizer.hasMoreTokens()) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("A document type declaration must specify a valid type");
            return tagInfo;
        }
        String string3 = tokenizer.nextToken();
        if (string3.trim().length() < 1) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("A document type declaration must specify a valid type");
            return tagInfo;
        }
        if (!this.isValidIdentifier(string3)) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("A document type declaration must specify a valid type");
            return tagInfo;
        }
        tagInfo.setProperty("DOCTYPE", string3.trim());
        ParseResult parseResult = null;
        if (tokenizer.hasMoreTokens()) {
            string3 = tokenizer.nextToken();
            if (string3.trim().equals("SYSTEM")) {
                tokenizer.push(string3.trim());
                parseResult = this.parseSystem(tokenizer);
                System.out.println("pval" + parseResult.value);
                if (!parseResult.valid) {
                    tagInfo.setValid(false);
                    tagInfo.setErrorMessage(parseResult.value);
                    return tagInfo;
                }
                tagInfo.setProperty("SYSTEM", parseResult.value);
                if (tokenizer.hasMoreTokens()) {
                    string3 = tokenizer.nextToken();
                }
            } else {
                System.out.println("Found :" + string3 + " instead of SYSTEM");
            }
            if (string3.trim().equals("PUBLIC")) {
                tokenizer.push(string3.trim());
                parseResult = this.parsePublic(tokenizer);
                if (!parseResult.valid) {
                    tagInfo.setValid(false);
                    tagInfo.setErrorMessage(parseResult.value);
                    return tagInfo;
                }
                tagInfo.setProperty("PUBLIC", parseResult.value);
                if (tokenizer.hasMoreTokens()) {
                    string3 = tokenizer.nextToken();
                }
            }
        }
        if (!string3.equals("[") && (string.indexOf("]") > -1 || string.indexOf("SYSTEM") < 0 && string.indexOf("PUBLIC") < 0)) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("Missing \"[\" after DOCTYPE declaration");
            return tagInfo;
        }
        if (!string3.equals(">") && !string3.equals("[")) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("Unexpected \"" + string3 + "\"");
            return tagInfo;
        }
        tagInfo.setValid(true);
        return tagInfo;
    }

    protected TagInfo parseDTD(ScratchTag scratchTag) {
        logger_.debug((Object)"parseDTD()");
        if (!scratchTag.getText().startsWith("<!")) {
            TagInfo tagInfo = new TagInfo(17);
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("Tags within a DTD must start with \"<!\"");
            return tagInfo;
        }
        if (scratchTag.getCurrentState() != ScratchTag.CLOSED_STATE) {
            TagInfo tagInfo = new TagInfo(17);
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("Tags within a DTD must end with \">\"");
            return tagInfo;
        }
        if (scratchTag.getText().startsWith("<!NOTATION")) {
            logger_.debug((Object)"parsing a !NOTATION");
            return this.parseNotationDeclaration(scratchTag);
        }
        if (scratchTag.getText().startsWith("<!ELEMENT")) {
            logger_.debug((Object)"parsing an !ELEMENT");
            return this.parseElementDeclaration(scratchTag);
        }
        if (scratchTag.getText().startsWith("<!ATTLIST")) {
            logger_.debug((Object)"parsing an !ATTLIST");
            return this.parseAttributeListDeclaration(scratchTag);
        }
        if (scratchTag.getText().startsWith("<!ENTITY")) {
            logger_.debug((Object)"parsing an !ENTITY");
            return this.parseEntity(scratchTag);
        }
        TagInfo tagInfo = new TagInfo(17);
        tagInfo.setValid(false);
        tagInfo.setErrorMessage("This is not a valid DTD element");
        return tagInfo;
    }

    protected TagInfo parseEntity(ScratchTag scratchTag) {
        String string = scratchTag.getText();
        EntityDeclarationAcceptor entityDeclarationAcceptor = new EntityDeclarationAcceptor();
        TagInfo tagInfo = new TagInfo(14);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            entityDeclarationAcceptor.accept(c);
            if (entityDeclarationAcceptor.getState() == -1) {
                tagInfo.setValid(false);
                break;
            }
            ++n;
        }
        tagInfo.setValid(entityDeclarationAcceptor.getState() == 1);
        if (tagInfo.isValid()) {
            tagInfo.setName(entityDeclarationAcceptor.getName());
            if (entityDeclarationAcceptor.isParameterEntity()) {
                tagInfo.setProperty("PARAMETER_ENTITY", "true");
            }
            if (entityDeclarationAcceptor.getCharcode() != null) {
                tagInfo.setProperty("CHARCODE", entityDeclarationAcceptor.getCharcode());
            }
            if (entityDeclarationAcceptor.getIdentifierType() != null) {
                tagInfo.setProperty("IDENTIFIER_TYPE", entityDeclarationAcceptor.getIdentifierType());
                tagInfo.setProperty("IDENTIFIER", entityDeclarationAcceptor.getIdentifier());
            }
            if (entityDeclarationAcceptor.getHelper() != null) {
                tagInfo.setProperty("HELPER", entityDeclarationAcceptor.getHelper());
            }
            if (entityDeclarationAcceptor.getCharcode() != null && (entityDeclarationAcceptor.getHelper() != null || entityDeclarationAcceptor.getIdentifierType() != null)) {
                tagInfo.setValid(false);
                tagInfo.setErrorMessage("Nothing is permitted after the character code in an Entity declaration");
            }
        }
        return tagInfo;
    }

    public TagInfo parseElementDeclaration(ScratchTag scratchTag) {
        String string;
        String string2 = scratchTag.getText();
        int n = string2.indexOf("<!ELEMENT");
        String string3 = string2.substring(n += 9);
        Tokenizer tokenizer = new Tokenizer(string3, " [>", true);
        TagInfo tagInfo = new TagInfo(13);
        tagInfo.setName("<!ELEMENT");
        if (!tokenizer.hasMoreTokens()) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("An ELEMENT declaration must specify a valid element name");
        }
        if ((string = tokenizer.nextToken()).trim().length() < 1) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("An ELEMENT declaration must specify a valid element name");
            return tagInfo;
        }
        if (!this.isValidIdentifier(string)) {
            tagInfo.setValid(false);
            tagInfo.setErrorMessage("An ELEMENT declaration must specify a valid element name");
            return tagInfo;
        }
        tagInfo.setProperty("ELEMENT", string.trim());
        ParseResult parseResult = null;
        logger_.debug((Object)"parsing the content model");
        if (tokenizer.hasMoreTokens()) {
            parseResult = this.parseCM(tokenizer);
            logger_.debug((Object)("content model is valid:" + parseResult.valid));
            if (!parseResult.valid) {
                tagInfo.setErrorMessage("An ELEMENT declaration must specify a valid content model. ERROR:" + parseResult.value);
                tagInfo.setValid(false);
                return tagInfo;
            }
        } else {
            tagInfo.setErrorMessage("An ELEMENT declaration must specify a content model");
            tagInfo.setValid(false);
            return tagInfo;
        }
        tagInfo.setProperty("CONTENT_MODEL", parseResult.value);
        if (tokenizer.hasMoreTokens() && !(string = tokenizer.nextToken()).equals(">")) {
            tagInfo.setErrorMessage("Unexpected \"" + string + "\"");
            tagInfo.setValid(false);
        }
        tagInfo.setValid(true);
        return tagInfo;
    }

    protected ParseResult parseName(StringTokenizer stringTokenizer) {
        ParseResult parseResult = new ParseResult();
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.trim().length() < 1) {
                parseResult.valid = false;
                parseResult.value = "A valid identifier was not specified";
            } else if (string.equals("SYSTEM") || string.equals("PUBLIC")) {
                parseResult.valid = false;
                parseResult.value = String.valueOf(string) + " is not a valid identifier";
            } else {
                parseResult.value = string.trim();
            }
        } else {
            parseResult.valid = false;
            parseResult.value = "A valid identifier was not specified";
        }
        return parseResult;
    }

    protected ParseResult parseLocation(StringTokenizer stringTokenizer) {
        ParseResult parseResult = new ParseResult();
        parseResult.valid = false;
        parseResult.value = "Missing \"\"\"";
        String string = null;
        String string2 = "";
        if (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).equals("\"")) {
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string.equals("\"")) {
                    parseResult.valid = true;
                    parseResult.value = string2;
                    return parseResult;
                }
                string2 = String.valueOf(string2) + string;
            }
        }
        return parseResult;
    }

    protected ParseResult parsePublic(StringTokenizer stringTokenizer) {
        ParseResult parseResult = new ParseResult();
        String string = null;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!string.equals("PUBLIC")) {
                parseResult.valid = false;
                parseResult.value = "PUBLIC expected instead of " + string;
                return parseResult;
            }
        } else {
            parseResult.valid = false;
            parseResult.value = "PUBLIC expected";
            return parseResult;
        }
        return this.parseLocation(stringTokenizer);
    }

    protected ParseResult parseSystem(StringTokenizer stringTokenizer) {
        ParseResult parseResult = new ParseResult();
        String string = null;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!string.equals("SYSTEM")) {
                parseResult.valid = false;
                parseResult.value = "SYSTEM expected instead of " + string;
                return parseResult;
            }
        } else {
            parseResult.valid = false;
            parseResult.value = "SYSTEM expected";
            return parseResult;
        }
        return this.parseLocation(stringTokenizer);
    }

    protected ParseResult parseType(StringTokenizer stringTokenizer) {
        return null;
    }

    protected class ParseResult {
        public boolean valid = true;
        public boolean empty = false;
        public String value;
        public Object data;

        protected ParseResult() {
        }
    }

    protected class Attribute {
        public String name;
        public String type;
        public String defaultvalue;
        public boolean fixed;

        protected Attribute() {
        }
    }

    protected class AttributeToken
    extends Attribute {
        public String errorMsg;
        public boolean valid = true;

        protected AttributeToken() {
        }
    }

    protected class AttributeTokenizer {
        private StringTokenizer tokenizer_;
        private int index_ = 0;
        private int max_ = -1;
        private String src_ = null;
        private String end_ = ">";

        public AttributeTokenizer(String string, String string2) {
            this(string);
            this.end_ = string2;
        }

        public AttributeTokenizer(String string) {
            this.src_ = string;
            this.tokenizer_ = new StringTokenizer(this.src_, "=\"", true);
        }

        public AttributeToken nextToken() {
            return null;
        }
    }

    protected class AttributeMatcher {
        public static final String ATTRIBUTE_PATTERN = "[ ]*[\\w]*=\\\"[^<^>^\\\"]*\\\"";
        private Pattern pattern_ = Pattern.compile("[ ]*[\\w]*=\\\"[^<^>^\\\"]*\\\"");
        private Matcher matcher_;

        public AttributeMatcher(String string) {
            this.matcher_ = this.pattern_.matcher(string);
        }
    }

    protected class Tokenizer
    extends StringTokenizer {
        public String token_;
        public Stack stk_ = new Stack();
        public boolean ignoreWhitespace_ = true;

        public Tokenizer(String string, String string2, boolean bl) {
            super(string, string2, bl);
        }

        public String nextToken() {
            this.token_ = this.stk_.size() > 0 ? (String)this.stk_.pop() : super.nextToken();
            if (this.ignoreWhitespace_ && this.token_.trim().length() < 1) {
                if (this.hasMoreTokens()) {
                    return this.nextToken();
                }
                return this.token_;
            }
            return this.token_.trim();
        }

        public void push(String string) {
            this.stk_.push(string);
        }
    }
}

