/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.AbstractDocument;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeStructure;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IValidationError;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CompoundValidationDocument
extends AbstractDocument
implements IValidationDocument {
    public static final String NO_NAMESPACE = "nonamespace";
    private static final Logger logger_;
    private INodeStructure[] nodeStructures_;
    private IElementStructure[] structures_ = null;
    private Vector validationDocuments_;
    private IValidationDocument defaultValidationDocument_;
    private Hashtable validationDocumentLookup_ = new Hashtable(3);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.validation.CompoundValidationDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public CompoundValidationDocument(String string) {
        super(string);
        this.validationDocuments_ = new Vector();
    }

    public void addValidationDocument(String string, IValidationDocument iValidationDocument) {
        if (string == null) {
            string = NO_NAMESPACE;
        }
        if (this.validationDocumentLookup_.contains(string)) {
            IValidationDocument iValidationDocument2 = (IValidationDocument)this.validationDocumentLookup_.get(string);
            this.validationDocuments_.remove(iValidationDocument2);
        }
        if (iValidationDocument != null) {
            this.validationDocumentLookup_.put(string, iValidationDocument);
            this.validationDocuments_.add(iValidationDocument);
        }
    }

    public void removeValidationDocument(String string) {
        IValidationDocument iValidationDocument;
        if (string == null) {
            string = NO_NAMESPACE;
        }
        if ((iValidationDocument = (IValidationDocument)this.validationDocumentLookup_.get(string)) != null) {
            this.validationDocuments_.remove(iValidationDocument);
            this.validationDocumentLookup_.remove(string);
            if (this.defaultValidationDocument_ == iValidationDocument) {
                this.defaultValidationDocument_ = null;
            }
        }
    }

    protected void buildElementStructures() {
        IElementStructure[] iElementStructureArray = new IElementStructure[]{};
        int n = 0;
        while (n < this.validationDocuments_.size()) {
            IElementStructure[] iElementStructureArray2 = ((IValidationDocument)this.validationDocuments_.elementAt(n)).getElementStructures();
            IElementStructure[] iElementStructureArray3 = new IElementStructure[iElementStructureArray2.length + iElementStructureArray.length];
            System.arraycopy(iElementStructureArray, 0, iElementStructureArray3, 0, iElementStructureArray.length);
            System.arraycopy(iElementStructureArray2, 0, iElementStructureArray3, iElementStructureArray.length, iElementStructureArray2.length);
            iElementStructureArray = iElementStructureArray3;
            ++n;
        }
        this.structures_ = iElementStructureArray;
    }

    protected void buildNodeStructures() {
        INodeStructure[] iNodeStructureArray = new INodeStructure[]{};
        int n = 0;
        while (n < this.validationDocuments_.size()) {
            INodeStructure[] iNodeStructureArray2 = ((IValidationDocument)this.validationDocuments_.elementAt(n)).getNodeStructures();
            INodeStructure[] iNodeStructureArray3 = new INodeStructure[iNodeStructureArray2.length + iNodeStructureArray.length];
            System.arraycopy(iNodeStructureArray, 0, iNodeStructureArray3, 0, iNodeStructureArray.length);
            System.arraycopy(iNodeStructureArray2, 0, iNodeStructureArray3, iNodeStructureArray.length, iNodeStructureArray2.length);
            iNodeStructureArray = iNodeStructureArray3;
            ++n;
        }
        this.nodeStructures_ = iNodeStructureArray;
    }

    public boolean isLocal() {
        return false;
    }

    public IElementStructure[] getElementStructures() {
        this.buildElementStructures();
        return this.structures_;
    }

    public IElementStructure[] getElementStructures(String string) {
        IValidationDocument iValidationDocument;
        this.buildElementStructures();
        if (string == null) {
            string = NO_NAMESPACE;
        }
        if ((iValidationDocument = (IValidationDocument)this.validationDocumentLookup_.get(string)) != null) {
            return iValidationDocument.getElementStructures();
        }
        return null;
    }

    public INodeStructure[] getNodeStructures() {
        this.buildNodeStructures();
        return this.nodeStructures_;
    }

    public IElementStructure getElementStructure(String string, String string2) {
        String string3 = string2;
        IValidationDocument iValidationDocument = this.getValidationDocument(string2);
        if (iValidationDocument != null) {
            IElementStructure iElementStructure = iValidationDocument.getElementStructure(string, null);
            if (iElementStructure == null) {
                iElementStructure = iValidationDocument.getElementStructure(string, string3);
            }
            if (iElementStructure == null && this.defaultValidationDocument_ != null) {
                return this.defaultValidationDocument_.getElementStructure(string, string3);
            }
            if (iElementStructure != null) {
                iElementStructure.setNamespace(string3);
            }
            return iElementStructure;
        }
        if (this.defaultValidationDocument_ != null) {
            return this.defaultValidationDocument_.getElementStructure(string, string3);
        }
        return null;
    }

    public INodeStructure getNodeStructure(INode iNode) {
        if (iNode instanceof IElement) {
            IElement iElement = (IElement)iNode;
            return this.getElementStructure(iElement.getLocalName(), iElement.getNameSpace());
        }
        return null;
    }

    public IValidationError[] validate(IDocument iDocument) {
        return null;
    }

    public INode getRoot() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public IValidationDocument getDefaultValidationDocument() {
        return this.defaultValidationDocument_;
    }

    public void setDefaultValidationDocument(IValidationDocument iValidationDocument) {
        this.defaultValidationDocument_ = iValidationDocument;
    }

    public IValidationDocument getValidationDocument(String string) {
        if (string == null) {
            string = NO_NAMESPACE;
        }
        IValidationDocument iValidationDocument = (IValidationDocument)this.validationDocumentLookup_.get(string);
        return iValidationDocument;
    }
}

