/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IOccurrence;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.validation.NodeValidationError;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeValidationError;
import butterfly.xmlview.model.validation.interfaces.INodeValidator;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.xni.QName;

public class DTDElementStructure
implements IElementStructure,
INodeValidator {
    private XMLElementDecl elementDeclaration_;
    private XMLAttributeDecl[] attributes_;
    private Hashtable subelements_;
    private IElementStructure[] elementIndex_;
    private static final Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.validation.DTDElementStructure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public INodeValidationError[] validateAttributes(IElement iElement) {
        INodeValidationError[] iNodeValidationErrorArray = null;
        if (this.attributes_ != null) {
            String string = null;
            IAttribute iAttribute = null;
            int n = 0;
            while (n < this.attributes_.length) {
                string = this.attributes_[n].name.localpart;
                iAttribute = iElement.getAttribute(string);
                if (iAttribute == null && this.attributes_[n].simpleType.defaultType == 2) {
                    NodeValidationError nodeValidationError = new NodeValidationError();
                    nodeValidationError.invalidNode = iElement;
                    nodeValidationError.validationContext = iElement;
                    nodeValidationError.errorMessage = "The required attribute \"" + string + "\" is missing";
                    iNodeValidationErrorArray = new INodeValidationError[]{nodeValidationError};
                    return iNodeValidationErrorArray;
                }
                ++n;
            }
        }
        return iNodeValidationErrorArray;
    }

    public INodeValidationError[] validate(INode iNode) {
        logger_.debug((Object)("DTDElementStructure.validate: " + iNode));
        QName[] qNameArray = this.getQNames(iNode, 0, iNode.childCount());
        if (this.elementDeclaration_ == null) {
            return null;
        }
        if (this.elementDeclaration_.contentModelValidator == null) {
            return null;
        }
        int n = this.elementDeclaration_.contentModelValidator.validate(qNameArray, 0, qNameArray.length);
        if (n == iNode.childCount()) {
            IElementStructure[] iElementStructureArray = this.allowedElementsAt((IElement)iNode, iNode.childCount());
            if (iElementStructureArray != null) {
                String string = "One or more required children are missing. Expected one of:(";
                int n2 = 0;
                while (n2 < iElementStructureArray.length) {
                    IElementStructure iElementStructure = iElementStructureArray[n2];
                    string = iElementStructure.getNamespace() != null ? String.valueOf(string) + "\"" + iElementStructure.getNamespace() + "\":" + iElementStructure.getName() : String.valueOf(string) + iElementStructure.getName();
                    if (n2 < iElementStructureArray.length - 1) {
                        string = String.valueOf(string) + ",";
                    }
                    ++n2;
                }
                string = String.valueOf(string) + ")";
                NodeValidationError nodeValidationError = new NodeValidationError();
                nodeValidationError.validationContext = iNode;
                nodeValidationError.invalidNode = iNode;
                nodeValidationError.errorMessage = string;
                return new NodeValidationError[]{nodeValidationError};
            }
        } else if (n >= 0 && n < iNode.childCount()) {
            NodeValidationError nodeValidationError = new NodeValidationError();
            nodeValidationError.errorMessage = iNode.childAt(n) + " is not allowed here. Expected one of the following:(";
            IElementStructure[] iElementStructureArray = this.allowedElementsAt((IElement)iNode, n);
            if (iElementStructureArray != null) {
                int n3 = 0;
                while (n3 < iElementStructureArray.length) {
                    if (iElementStructureArray[n3] != null) {
                        nodeValidationError.errorMessage = String.valueOf(nodeValidationError.errorMessage) + iElementStructureArray[n3].getName();
                        if (n3 < iElementStructureArray.length - 1) {
                            nodeValidationError.errorMessage = String.valueOf(nodeValidationError.errorMessage) + " | ";
                        }
                    }
                    ++n3;
                }
            }
            nodeValidationError.errorMessage = String.valueOf(nodeValidationError.errorMessage) + ")";
            nodeValidationError.invalidNode = iNode.childAt(n);
            nodeValidationError.validationContext = iNode;
            INodeValidationError[] iNodeValidationErrorArray = new NodeValidationError[]{nodeValidationError};
            return iNodeValidationErrorArray;
        }
        return this.validateAttributes((IElement)iNode);
    }

    public DTDElementStructure(XMLElementDecl xMLElementDecl, XMLAttributeDecl[] xMLAttributeDeclArray, Hashtable hashtable) {
        this.attributes_ = xMLAttributeDeclArray;
        this.elementDeclaration_ = xMLElementDecl;
        this.setSubelements(hashtable);
    }

    public IElementStructure[] allowedElementsAt(IElement iElement, int n) {
        QName[] qNameArray = this.getQNames(iElement, 0, n);
        QName[] qNameArray2 = this.elementDeclaration_.contentModelValidator.whatCanGoNext(qNameArray, 0, qNameArray.length);
        if (qNameArray2 == null) {
            return new IElementStructure[0];
        }
        IElementStructure[] iElementStructureArray = new IElementStructure[qNameArray2.length];
        int n2 = 0;
        while (n2 < iElementStructureArray.length) {
            iElementStructureArray[n2] = (IElementStructure)this.subelements_.get(qNameArray2[n2]);
            ++n2;
        }
        return iElementStructureArray;
    }

    protected QName[] getQNames(INode iNode, int n, int n2) {
        Vector<QName> vector = new Vector<QName>();
        INode iNode2 = null;
        int n3 = n;
        while (n3 < n2) {
            if (n3 >= iNode.childCount()) break;
            iNode2 = iNode.childAt(n3);
            if (iNode2 instanceof IValueNode) {
                vector.add(new QName(null, null, null, null));
            } else if (iNode2 instanceof IElement) {
                IElement iElement = (IElement)iNode2;
                vector.add(new QName(iElement.getPrefix(), iElement.getLocalName(), iElement.getName(), iElement.getNameSpace()));
            }
            ++n3;
        }
        return vector.toArray(new QName[0]);
    }

    public IOccurrence getOccurrence(IElementStructure iElementStructure) {
        return null;
    }

    public String attributeAt(int n) {
        return this.attributes_[n].name.rawname;
    }

    public int attributeCount() {
        return this.attributes_.length;
    }

    public String getName() {
        return this.elementDeclaration_.name.localpart;
    }

    public String getNamespace() {
        return this.elementDeclaration_.name.uri;
    }

    public IElementStructure subElementAt(int n) {
        return this.elementIndex_[n];
    }

    public int subElementCount() {
        if (this.subelements_ == null) {
            return 0;
        }
        return this.subelements_.size();
    }

    public void getDefaultContent(IElement iElement) {
        boolean bl = false;
        int n = 0;
        while (n < this.attributes_.length) {
            XMLAttributeDecl cfr_ignored_0 = this.attributes_[n];
            if (this.attributes_[n].simpleType.defaultType != 0 && this.attributes_[n].simpleType.defaultType != 3) {
                Attribute attribute = new Attribute(this.attributes_[n].name.localpart, "" + this.attributes_[n].simpleType.name);
                iElement.addAttribute(attribute);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            iElement.getDocument().updateNode(iElement, true);
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        hashtable.put(String.valueOf(iElement.getNameSpace()) + iElement.getLocalName(), Boolean.TRUE);
        int n2 = 0;
        while (n2 < 20) {
            IElementStructure[] iElementStructureArray = this.allowedElementsAt(iElement, n2);
            if (iElementStructureArray != null && iElementStructureArray.length > 0) {
                if (iElementStructureArray[0] == null || hashtable.get(String.valueOf(iElementStructureArray[0].getNamespace()) + iElementStructureArray[0].getName()) != null) break;
                Element element = new Element(iElementStructureArray[0].getName());
                iElement.getDocument().addChild(iElement, element, iElement.childCount(), true);
                ((DTDElementStructure)iElementStructureArray[0]).getDefaultContent(element, hashtable);
            }
            ++n2;
        }
    }

    public void getDefaultContent(IElement iElement, Hashtable hashtable) {
        Object object;
        boolean bl = false;
        int n = 0;
        while (n < this.attributes_.length) {
            XMLAttributeDecl cfr_ignored_0 = this.attributes_[n];
            if (this.attributes_[n].simpleType.defaultType != 0) {
                object = new Attribute(this.attributes_[n].name.localpart, "" + this.attributes_[n].simpleType.name);
                iElement.addAttribute((IAttribute)object);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            iElement.getDocument().updateNode(iElement, true);
        }
        hashtable.put(String.valueOf(iElement.getNameSpace()) + iElement.getLocalName(), Boolean.TRUE);
        n = 0;
        while (n < 20) {
            object = this.allowedElementsAt(iElement, n);
            if (object != null && ((IElementStructure[])object).length > 0 && object[0] != null && hashtable.get(String.valueOf(object[0].getNamespace()) + object[0].getName()) == null) {
                Element element = new Element(object[0].getName());
                iElement.getDocument().addChild(iElement, element, iElement.childCount(), true);
                if (((IElementStructure[])object).length <= 0) break;
                ((DTDElementStructure)object[0]).getDefaultContent(element, hashtable);
            }
            ++n;
        }
    }

    public INodeValidator getValidator() {
        return this;
    }

    public Hashtable getSubelements() {
        return this.subelements_;
    }

    public void setSubelements(Hashtable hashtable) {
        this.elementIndex_ = hashtable != null ? hashtable.values().toArray(new IElementStructure[0]) : new IElementStructure[0];
        this.subelements_ = hashtable;
    }

    public String toString() {
        String string = "DTDElementStructure: " + this.elementDeclaration_.name + "\nAllowedSubElements:(";
        int n = 0;
        while (n < this.subElementCount()) {
            string = String.valueOf(string) + this.subElementAt(n).getName();
            if (n < this.subElementCount() - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n;
        }
        string = String.valueOf(string) + ")\nAllowedAttributes:(";
        n = 0;
        while (n < this.attributeCount()) {
            string = String.valueOf(string) + this.attributeAt(n);
            if (n < this.attributeCount() - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n;
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public void setNamespace(String string) {
    }
}

