/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.validation.DTDElementStructure;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeValidationError;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;

public class DTDParser {
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final int BIG_PRIME = 2039;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;

    public XMLElementDecl[] getElementDeclerations(DTDGrammar dTDGrammar) {
        Vector<XMLElementDecl> vector = new Vector<XMLElementDecl>();
        int n = dTDGrammar.getFirstElementDeclIndex();
        while (n > -1) {
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            dTDGrammar.getElementDecl(n, xMLElementDecl);
            vector.add(xMLElementDecl);
            n = dTDGrammar.getNextElementDeclIndex(n);
        }
        return vector.toArray(new XMLElementDecl[0]);
    }

    public Hashtable getElementStructures(DTDGrammar dTDGrammar) {
        Hashtable<QName, XMLElementDecl> hashtable = new Hashtable<QName, XMLElementDecl>();
        XMLElementDecl[] xMLElementDeclArray = this.getElementDeclerations(dTDGrammar);
        int n = 0;
        while (n < xMLElementDeclArray.length) {
            if (xMLElementDeclArray[n] != null && xMLElementDeclArray[n].name != null && xMLElementDeclArray[n].name != null && xMLElementDeclArray[n].name.localpart != null) {
                hashtable.put(xMLElementDeclArray[n].name, xMLElementDeclArray[n]);
            }
            ++n;
        }
        Hashtable hashtable2 = new Hashtable();
        int n2 = 0;
        while (n2 < xMLElementDeclArray.length) {
            if (xMLElementDeclArray[n2] != null && xMLElementDeclArray[n2].name != null && xMLElementDeclArray[n2].name.localpart != null) {
                this.getElementStructure(dTDGrammar, xMLElementDeclArray[n2], hashtable, hashtable2, true);
            }
            ++n2;
        }
        return hashtable2;
    }

    protected IElementStructure getElementStructure(DTDGrammar dTDGrammar, XMLElementDecl xMLElementDecl, Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        if (xMLElementDecl == null) {
            return null;
        }
        DTDElementStructure dTDElementStructure = (DTDElementStructure)hashtable2.get(xMLElementDecl.name);
        if (dTDElementStructure == null) {
            dTDElementStructure = new DTDElementStructure(xMLElementDecl, this.getAttributeDeclarations(dTDGrammar, xMLElementDecl), null);
            hashtable2.put(xMLElementDecl.name, dTDElementStructure);
        }
        if (dTDElementStructure.getSubelements() == null && bl && xMLElementDecl.contentModelValidator != null) {
            QName[] qNameArray = xMLElementDecl.contentModelValidator.getAllowedSubElements();
            Hashtable<QName, IElementStructure> hashtable3 = new Hashtable<QName, IElementStructure>();
            int n = 0;
            while (n < qNameArray.length) {
                XMLElementDecl xMLElementDecl2;
                if (qNameArray[n].rawname != null && (xMLElementDecl2 = (XMLElementDecl)hashtable.get(qNameArray[n])) != null) {
                    IElementStructure iElementStructure = this.getElementStructure(dTDGrammar, xMLElementDecl2, hashtable, hashtable2, false);
                    hashtable3.put(qNameArray[n], iElementStructure);
                }
                ++n;
            }
            dTDElementStructure.setSubelements(hashtable3);
        }
        return dTDElementStructure;
    }

    public XMLAttributeDecl[] getAttributeDeclarations(DTDGrammar dTDGrammar, XMLElementDecl xMLElementDecl) {
        Vector<XMLAttributeDecl> vector = new Vector<XMLAttributeDecl>();
        int n = dTDGrammar.getElementDeclIndex(xMLElementDecl.name);
        int n2 = dTDGrammar.getFirstAttributeDeclIndex(n);
        while (n2 > -1) {
            XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
            dTDGrammar.getAttributeDecl(n2, xMLAttributeDecl);
            n2 = dTDGrammar.getNextAttributeDeclIndex(n2);
            vector.add(xMLAttributeDecl);
        }
        return vector.toArray(new XMLAttributeDecl[0]);
    }

    public void parse(String string, String string2) {
        SymbolTable symbolTable = new SymbolTable(2039);
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser(symbolTable);
        XMLGrammarPoolImpl xMLGrammarPoolImpl = new XMLGrammarPoolImpl();
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/TR/REC-xml", null);
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xMLGrammarPreparser.setProperty(GRAMMAR_POOL, (Object)xMLGrammarPoolImpl);
        xMLGrammarPreparser.setFeature(NAMESPACES_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(VALIDATION_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        try {
            Grammar grammar = xMLGrammarPreparser.preparseGrammar("http://www.w3.org/TR/REC-xml", DTDParser.stringToXIS(string));
            System.out.println("grammar:" + grammar);
            DTDGrammar dTDGrammar = (DTDGrammar)grammar;
            String string3 = "jules";
            this.scanContentModel(dTDGrammar, string3, "(xform,date)");
            dTDGrammar.elementDecl(string3, "(xform,date)", null);
            Hashtable hashtable = this.getElementStructures(dTDGrammar);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                DTDElementStructure dTDElementStructure = (DTDElementStructure)hashtable.get(enumeration.nextElement());
                System.out.println("\n\n" + dTDElementStructure);
                if (!dTDElementStructure.getName().equals("jules")) continue;
                QName[] qNameArray = new QName[]{new QName(null, "xform", "xform", null), new QName(null, "date", "date", null)};
                Element element = new Element("jules");
                element.addChild(new Element("xform"));
                element.addChild(new Element("date2"));
                INodeValidationError[] iNodeValidationErrorArray = dTDElementStructure.validate(element);
                if (iNodeValidationErrorArray == null) continue;
                int n = 0;
                while (n < iNodeValidationErrorArray.length) {
                    System.out.println(iNodeValidationErrorArray[n].getErrorMessage());
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void scanContentModel(DTDGrammar dTDGrammar, String string, String string2) {
        dTDGrammar.startContentModel(string, null);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*?|()+,", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.length() > 1) {
                if (string3.equals("#ANY")) {
                    dTDGrammar.any(null);
                    continue;
                }
                if (string3.equals("#PCDATA")) {
                    dTDGrammar.pcdata(null);
                    continue;
                }
                System.out.println("element:" + string3 + ":");
                String cfr_ignored_0 = "" + string3;
                dTDGrammar.element("null", null);
                continue;
            }
            char c = string3.charAt(0);
            if (c == '(') {
                System.out.println("(");
                dTDGrammar.startGroup(null);
                continue;
            }
            if (c == ')') {
                System.out.println(")");
                dTDGrammar.endGroup(null);
                continue;
            }
            if (c == ',') {
                dTDGrammar.separator((short)1, null);
                continue;
            }
            if (c == '|') {
                dTDGrammar.separator((short)0, null);
                continue;
            }
            if (c == '*') {
                dTDGrammar.occurrence((short)3, null);
                continue;
            }
            if (c == '+') {
                dTDGrammar.occurrence((short)4, null);
                continue;
            }
            if (c != '?') continue;
            dTDGrammar.occurrence((short)2, null);
        }
        dTDGrammar.endContentModel(null);
    }

    public Hashtable buildElementStructure(XMLInputSource xMLInputSource) {
        SymbolTable symbolTable = new SymbolTable(2039);
        XMLGrammarPreparser xMLGrammarPreparser = new XMLGrammarPreparser(symbolTable);
        XMLGrammarPoolImpl xMLGrammarPoolImpl = new XMLGrammarPoolImpl();
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/TR/REC-xml", null);
        xMLGrammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        xMLGrammarPreparser.setProperty(GRAMMAR_POOL, (Object)xMLGrammarPoolImpl);
        xMLGrammarPreparser.setFeature(NAMESPACES_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(VALIDATION_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        xMLGrammarPreparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        try {
            Grammar grammar = xMLGrammarPreparser.preparseGrammar("http://www.w3.org/TR/REC-xml", xMLInputSource);
            DTDGrammar dTDGrammar = (DTDGrammar)grammar;
            Hashtable hashtable = this.getElementStructures(dTDGrammar);
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    private static XMLInputSource stringToXIS(String string) {
        return new XMLInputSource(null, string, null);
    }

    public static void main(String[] stringArray) {
        DTDParser dTDParser = new DTDParser();
        try {
            File file = new File(stringArray[0]);
            if (!file.exists()) {
                System.out.println("File not found.");
            }
        }
        catch (Exception exception) {
            System.out.println("File not found.");
        }
        dTDParser.parse(stringArray[0], stringArray[1]);
    }

    class Name {
        public String name;
        public String namespace;

        Name() {
        }
    }
}

