/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.ElementStructure;
import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentEvent;
import butterfly.xmlview.model.interfaces.IDocumentListener;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.validation.AbstractValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeStructure;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class GenericValidationDocument
extends AbstractValidationDocument
implements IDocumentListener {
    private IDocument xmlDocument_;
    private Hashtable elementStructure_ = new Hashtable(19);

    public GenericValidationDocument(IDocument iDocument) {
        super("text/dtd");
        this.xmlDocument_ = iDocument;
        if (iDocument != null) {
            this.xmlDocument_.addDocumentListener(this);
            this.visitNode(this.xmlDocument_.getRoot());
        }
    }

    public IElementStructure getElementStructure(String string, String string2) {
        return (IElementStructure)this.elementStructure_.get(this.getKey(string, string2));
    }

    public INode getRoot() {
        return null;
    }

    public void handleDocumentEvent(IDocumentEvent iDocumentEvent) {
        if (iDocumentEvent.getType() == 3) {
            System.out.println("indexing new node:" + iDocumentEvent.getChangedNode());
            this.visitNode(iDocumentEvent.getChangedNode());
            if (iDocumentEvent.getChangedNode() instanceof IElement && iDocumentEvent.getChangedNode().getParent() instanceof IElement) {
                IElement iElement = (IElement)iDocumentEvent.getChangedNode();
                IElement iElement2 = (IElement)iDocumentEvent.getChangedNode().getParent();
                ElementStructure elementStructure = (ElementStructure)this.getElementStructure(iElement2.getLocalName(), iElement2.getNameSpace());
                if (elementStructure != null) {
                    ElementStructure elementStructure2 = (ElementStructure)this.getElementStructure(((IElement)iDocumentEvent.getChangedNode()).getLocalName(), ((IElement)iDocumentEvent.getChangedNode()).getNameSpace());
                    int n = 0;
                    while (n < iElement.attributeCount()) {
                        if (!elementStructure2.hasAttribute(iElement.attributeAt(n).getName())) {
                            elementStructure2.addAttribute(iElement.attributeAt(n).getName());
                            if (iElement.attributeAt(n).getData().equals("default__")) {
                                elementStructure2.addToDefaultContent(iElement.attributeAt(n).getName());
                            }
                        }
                        ++n;
                    }
                    elementStructure.addSubElement(elementStructure2);
                }
            }
        }
        iDocumentEvent.getType();
    }

    private void visitNode(INode iNode) {
        if (iNode instanceof IElement) {
            this.visitElement((IElement)iNode);
        } else {
            int n = 0;
            while (n < iNode.childCount()) {
                this.visitNode(iNode.childAt(n));
                ++n;
            }
        }
    }

    private void visitElement(IElement iElement) {
        Object object;
        MarkedElementStructure markedElementStructure = (MarkedElementStructure)this.getElementStructure(iElement.getLocalName(), iElement.getNameSpace());
        if (markedElementStructure == null) {
            markedElementStructure = new MarkedElementStructure(iElement);
        }
        ++markedElementStructure.referenceCount;
        this.elementStructure_.put(this.getKey(iElement.getLocalName(), iElement.getNameSpace()), markedElementStructure);
        IElement iElement2 = null;
        int n = 0;
        while (n < iElement.childCount()) {
            this.visitNode(iElement.childAt(n));
            if (iElement.childAt(n) instanceof IElement) {
                iElement2 = (IElement)iElement.childAt(n);
                object = (MarkedElementStructure)this.getElementStructure(iElement2.getLocalName(), iElement2.getNameSpace());
                markedElementStructure.addSubElement((IElementStructure)object);
            }
            ++n;
        }
        IAttribute iAttribute = iElement.getAttribute("default__elements");
        if (iAttribute != null) {
            object = markedElementStructure.getNamespace();
            String string = iAttribute.getData();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                ElementStructure elementStructure = (ElementStructure)this.getElementStructure(stringTokenizer.nextToken(), (String)object);
                if (elementStructure == null) continue;
                markedElementStructure.addToDefaultContent(elementStructure);
            }
        }
    }

    public INodeStructure getNodeStructure(INode iNode) {
        if (iNode instanceof IElement) {
            IElement iElement = (IElement)iNode;
            return this.getElementStructure(iElement.getLocalName(), iElement.getNameSpace());
        }
        return null;
    }

    public IElementStructure[] getElementStructures() {
        return this.elementStructure_.values().toArray(new IElementStructure[0]);
    }

    public INodeStructure[] getNodeStructures() {
        return this.getElementStructures();
    }

    public String getKey(String string, String string2) {
        return String.valueOf(string2) + ":" + string;
    }

    class MarkedElementStructure
    extends ElementStructure {
        public int referenceCount = 0;

        public MarkedElementStructure(IElement iElement) {
            super(iElement);
        }

        public MarkedElementStructure(String string, String string2) {
            super(string, string2);
        }
    }
}

