/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IOccurrence;
import butterfly.xmlview.model.validation.AbstractValidationDocument;
import butterfly.xmlview.model.validation.GenericValidationDocument;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeStructure;
import butterfly.xmlview.model.validation.interfaces.INodeValidator;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import java.util.Hashtable;

public class HybridValidationDocument
extends AbstractValidationDocument {
    private IValidationDocument validationDocument_;
    private IValidationDocument templateDocument_;
    private Hashtable elementStructure_;

    public HybridValidationDocument(XmlDocument xmlDocument, IValidationDocument iValidationDocument) {
        super("text/xsd");
        this.templateDocument_ = new GenericValidationDocument(xmlDocument);
        this.validationDocument_ = iValidationDocument;
        this.elementStructure_ = new Hashtable(xmlDocument.getElementStructures().length);
        this.buildElementStructures();
    }

    public HybridValidationDocument(IValidationDocument iValidationDocument, IValidationDocument iValidationDocument2) {
        super("text/xsd");
        this.templateDocument_ = iValidationDocument;
        this.validationDocument_ = iValidationDocument2;
        this.elementStructure_ = new Hashtable(iValidationDocument.getElementStructures().length);
        this.buildElementStructures();
    }

    private void buildElementStructures() {
        IElementStructure[] iElementStructureArray = this.templateDocument_.getElementStructures();
        int n = 0;
        while (n < iElementStructureArray.length) {
            IElementStructure iElementStructure = this.validationDocument_.getElementStructure(iElementStructureArray[n].getName(), this.getNamespace());
            if (iElementStructure == null) {
                iElementStructure = this.validationDocument_.getElementStructure(iElementStructureArray[n].getName(), null);
            }
            HybridElementStructure hybridElementStructure = new HybridElementStructure(iElementStructureArray[n], iElementStructure);
            this.addElementStructure(hybridElementStructure);
            ++n;
        }
    }

    public IElementStructure getElementStructure(String string, String string2) {
        return (IElementStructure)this.elementStructure_.get(this.getKey(string, string2));
    }

    public INode getRoot() {
        return null;
    }

    public INodeStructure getNodeStructure(INode iNode) {
        if (iNode instanceof IElement) {
            IElement iElement = (IElement)iNode;
            return this.getElementStructure(iElement.getLocalName(), iElement.getNameSpace());
        }
        return null;
    }

    public IElementStructure[] getElementStructures() {
        return this.elementStructure_.values().toArray(new IElementStructure[0]);
    }

    public INodeStructure[] getNodeStructures() {
        return this.getElementStructures();
    }

    public void addElementStructure(IElementStructure iElementStructure) {
        this.elementStructure_.put(this.getKey(iElementStructure.getName(), iElementStructure.getNamespace()), iElementStructure);
    }

    public String getKey(String string, String string2) {
        return String.valueOf(string2) + ":" + string;
    }

    class HybridElementStructure
    implements IElementStructure {
        private IElementStructure validationStructure_;
        private IElementStructure templateStructure_;
        private String namespace_;

        public IElementStructure[] allowedElementsAt(IElement iElement, int n) {
            return this.templateStructure_.allowedElementsAt(iElement, n);
        }

        public String attributeAt(int n) {
            return this.templateStructure_.attributeAt(n);
        }

        public int attributeCount() {
            return this.templateStructure_.attributeCount();
        }

        public void getDefaultContent(IElement iElement) {
            this.templateStructure_.getDefaultContent(iElement);
        }

        public String getName() {
            return this.templateStructure_.getName();
        }

        public String getNamespace() {
            return this.namespace_;
        }

        public IOccurrence getOccurrence(IElementStructure iElementStructure) {
            return this.templateStructure_.getOccurrence(iElementStructure);
        }

        public INodeValidator getValidator() {
            return this.validationStructure_.getValidator();
        }

        public IElementStructure subElementAt(int n) {
            return this.templateStructure_.subElementAt(n);
        }

        public int subElementCount() {
            return this.templateStructure_.subElementCount();
        }

        public String toString() {
            return this.templateStructure_.toString();
        }

        public HybridElementStructure(IElementStructure iElementStructure, IElementStructure iElementStructure2) {
            this.templateStructure_ = iElementStructure;
            this.validationStructure_ = iElementStructure2;
        }

        public void setNamespace(String string) {
            this.namespace_ = string;
            this.templateStructure_.setNamespace(string);
            this.validationStructure_.setNamespace(string);
        }
    }
}

