/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.validation.AbstractValidationDocument;
import butterfly.xmlview.model.validation.DefaultNodeStructure;
import butterfly.xmlview.model.validation.XmlStructureBuilder;
import butterfly.xmlview.model.validation.interfaces.IElementStructure;
import butterfly.xmlview.model.validation.interfaces.INodeStructure;
import butterfly.xmlview.model.validation.interfaces.IValidationDocument;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ValidationDocument
extends AbstractValidationDocument
implements IValidationDocument {
    private IDocument sourceDocument_;
    private Hashtable elementStructure_;
    private URL URL_;
    private static Logger logger_;
    public static final DefaultNodeStructure DEFAULT_NODE_STRUCTURE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.validation.ValidationDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        DEFAULT_NODE_STRUCTURE = new DefaultNodeStructure();
    }

    public ValidationDocument(String string, IDocument iDocument) {
        super(string);
        this.sourceDocument_ = iDocument;
    }

    public ValidationDocument(String string, IDocument iDocument, IElementStructure[] iElementStructureArray) {
        super(string);
        this.sourceDocument_ = iDocument;
        this.setElementStructures(iElementStructureArray);
    }

    public INode getRoot() {
        return this.sourceDocument_.getRoot();
    }

    public IDocument getSourceDocument() {
        return this.sourceDocument_;
    }

    public URL getURL() {
        return this.URL_;
    }

    public boolean isLocal() {
        if (this.getURL() == null) {
            return true;
        }
        if (this.getURL().toExternalForm().toLowerCase().startsWith("file")) {
            return true;
        }
        return this.getURL().toExternalForm().toLowerCase().startsWith("c:");
    }

    private void load() {
        this.getURL();
    }

    public void setSourceDocument(IDocument iDocument) {
        this.sourceDocument_ = iDocument;
    }

    public void setURL(URL uRL) {
        this.URL_ = uRL;
    }

    public String toString() {
        if (this.getSourceDocument() == null) {
            this.load();
        }
        return "" + this.sourceDocument_;
    }

    public IElementStructure getElementStructure(String string, String string2) {
        if (this.elementStructure_ == null) {
            this.buildElementStructure();
        }
        return (IElementStructure)this.elementStructure_.get(this.getKey(string, string2));
    }

    private void buildElementStructure() {
        if (this.toString() == null) {
            return;
        }
        try {
            XmlStructureBuilder xmlStructureBuilder = new XmlStructureBuilder();
            IElementStructure[] iElementStructureArray = new IElementStructure[]{};
            try {
                iElementStructureArray = xmlStructureBuilder.buildElementStructure(this.toString(), this.getSourceFileName(), this.getContentType().equals("text/dtd"));
            }
            catch (Exception exception) {
                this.setValid(false);
            }
            if (iElementStructureArray != null) {
                this.elementStructure_ = new Hashtable(iElementStructureArray.length);
                int n = 0;
                while (n < iElementStructureArray.length) {
                    this.elementStructure_.put(this.getKey(iElementStructureArray[n].getName(), iElementStructureArray[n].getNamespace()), iElementStructureArray[n]);
                    ++n;
                }
            } else {
                this.elementStructure_ = new Hashtable(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setValid(false);
        }
    }

    public void setElementStructures(IElementStructure[] iElementStructureArray) {
        if (iElementStructureArray != null) {
            this.elementStructure_ = new Hashtable(iElementStructureArray.length);
            int n = 0;
            while (n < iElementStructureArray.length) {
                this.elementStructure_.put(this.getKey(iElementStructureArray[n].getName(), iElementStructureArray[n].getNamespace()), iElementStructureArray[n]);
                ++n;
            }
        } else {
            this.elementStructure_ = new Hashtable(0);
        }
    }

    public String getKey(String string, String string2) {
        return "" + string2 + ":" + string;
    }

    public INodeStructure getNodeStructure(INode iNode) {
        if (iNode instanceof IElement) {
            IElement iElement = (IElement)iNode;
            return this.getElementStructure(iElement.getLocalName(), iElement.getNameSpace());
        }
        return DEFAULT_NODE_STRUCTURE;
    }

    public IElementStructure[] getElementStructures() {
        if (this.elementStructure_ == null) {
            this.buildElementStructure();
        }
        return this.elementStructure_.values().toArray(new IElementStructure[0]);
    }

    public INodeStructure[] getNodeStructures() {
        return this.getElementStructures();
    }
}

