/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.model.validation;

import butterfly.xmlview.model.interfaces.IAttribute;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.IElement;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.IScratchTag;
import butterfly.xmlview.model.interfaces.IValueNode;
import butterfly.xmlview.model.validation.NodeValidationError;
import butterfly.xmlview.model.validation.XSElementStructure;
import butterfly.xmlview.model.validation.interfaces.IElementValidator;
import butterfly.xmlview.model.validation.interfaces.INodeValidationError;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.psvi.XSAttributeUse;
import org.apache.xerces.impl.xs.psvi.XSObject;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.xni.QName;

public class XSElementValidator
implements IElementValidator {
    private XSElementStructure element_;
    private XSCMValidator validator_;
    private QName qName_;
    private boolean mixed_ = false;
    private XSAttributeUse[] attributes_;
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.model.validation.XSElementValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public XSElementValidator(XSElementStructure xSElementStructure, XSAttributeUse[] xSAttributeUseArray) {
        this.element_ = xSElementStructure;
        this.attributes_ = xSAttributeUseArray;
    }

    public INodeValidationError[] validateAttributes(IElement iElement) {
        INodeValidationError[] iNodeValidationErrorArray = null;
        if (this.attributes_ != null) {
            String string = null;
            IAttribute iAttribute = null;
            int n = 0;
            while (n < this.attributes_.length) {
                string = this.attributes_[n].getAttrDeclaration().getName();
                iAttribute = iElement.getAttribute(string);
                if (iAttribute == null && this.attributes_[n].getRequired()) {
                    NodeValidationError nodeValidationError = new NodeValidationError();
                    nodeValidationError.errorMessage = "The required attribute \"" + string + "\" is missing";
                    nodeValidationError.validationContext = iElement;
                    nodeValidationError.invalidNode = iElement;
                    iNodeValidationErrorArray = new INodeValidationError[]{nodeValidationError};
                    return iNodeValidationErrorArray;
                }
                ++n;
            }
        }
        return iNodeValidationErrorArray;
    }

    public INodeValidationError[] validate(IElement iElement) {
        XSTypeDefinition xSTypeDefinition = this.element_.getDeclaration().getTypeDefinition();
        if (xSTypeDefinition instanceof XSComplexTypeDecl) {
            if (this.validator_ == null) {
                this.mixed_ = ((XSComplexTypeDecl)xSTypeDefinition).getContentType() == 3;
                this.validator_ = ((XSComplexTypeDecl)xSTypeDefinition).getContentModel(new CMBuilder(new CMNodeFactory()));
            }
            return this.validate(this.validator_, iElement);
        }
        return null;
    }

    protected String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n > -1) {
            return string.trim().substring(0, n);
        }
        return null;
    }

    protected String getLocalName(String string) {
        int n = string.indexOf(58);
        if (n > -1) {
            return string.trim().substring(n + 1);
        }
        return string;
    }

    protected INodeValidationError[] validate(XSCMValidator xSCMValidator, IElement iElement) {
        INodeValidationError[] iNodeValidationErrorArray;
        int[] nArray;
        if (xSCMValidator == null) {
            return null;
        }
        int[] nArray2 = nArray = xSCMValidator.startContentModel();
        int n = 0;
        while (n < iElement.childCount()) {
            iNodeValidationErrorArray = iElement.childAt(n);
            if (!(iNodeValidationErrorArray instanceof IDTDNode)) {
                INodeValidationError[] iNodeValidationErrorArray2;
                Object object;
                if (iNodeValidationErrorArray instanceof IValueNode && !this.mixed_ && !(iNodeValidationErrorArray instanceof IScratchTag)) {
                    object = new NodeValidationError();
                    ((NodeValidationError)object).validationContext = iElement;
                    ((NodeValidationError)object).errorMessage = "Only elements with MIXED content may contain text";
                    ((NodeValidationError)object).invalidNode = iNodeValidationErrorArray;
                    iNodeValidationErrorArray2 = new NodeValidationError[]{object};
                    return iNodeValidationErrorArray2;
                }
                if (iNodeValidationErrorArray instanceof IElement) {
                    object = (IElement)iNodeValidationErrorArray;
                    iNodeValidationErrorArray2 = object.getNameSpace();
                    if (this.element_.getNamespace() != null) {
                        if (iNodeValidationErrorArray2 != null && this.element_.getNamespace().equals(iNodeValidationErrorArray2)) {
                            iNodeValidationErrorArray2 = this.element_.getDeclaration().getNamespace();
                        } else if (iNodeValidationErrorArray2 == null) {
                            iNodeValidationErrorArray2 = "''";
                        }
                    }
                    QName qName = new QName(this.getPrefix(object.getName()), this.getLocalName(object.getName()), object.getName(), (String)iNodeValidationErrorArray2);
                    logger_.debug((Object)("qname: " + qName + " : " + object.getNameSpace()));
                    xSCMValidator.oneTransition(qName, nArray, this.element_.getSubstitutionGroupHandler());
                    if (nArray[0] == -1 || nArray[0] == -2) {
                        NodeValidationError nodeValidationError = new NodeValidationError();
                        nodeValidationError.errorMessage = "" + object.getName() + " is not allowed here. Expected one of:" + this.xsObjectVectorToString(xSCMValidator.whatCanGoHere(nArray2));
                        nodeValidationError.invalidNode = iNodeValidationErrorArray;
                        nodeValidationError.validationContext = iElement;
                        INodeValidationError[] iNodeValidationErrorArray3 = new NodeValidationError[]{nodeValidationError};
                        return iNodeValidationErrorArray3;
                    }
                    nArray2 = nArray;
                }
            }
            ++n;
        }
        if (!xSCMValidator.endContentModel(nArray)) {
            NodeValidationError nodeValidationError = new NodeValidationError();
            nodeValidationError.errorMessage = "One or more required children are missing. Expected one of:" + this.xsObjectVectorToString(xSCMValidator.whatCanGoHere(nArray2));
            nodeValidationError.invalidNode = iElement;
            nodeValidationError.validationContext = iElement;
            iNodeValidationErrorArray = new NodeValidationError[]{nodeValidationError};
            return iNodeValidationErrorArray;
        }
        INodeValidationError[] iNodeValidationErrorArray4 = this.validateAttributes(iElement);
        return iNodeValidationErrorArray4;
    }

    public String xsObjectVectorToString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(((XSObject)vector.elementAt(n)).getName());
            if (n < vector.size() - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public INodeValidationError[] validate(INode iNode) {
        if (iNode instanceof IElement) {
            return this.validate((IElement)iNode);
        }
        return null;
    }

    public QName getQName() {
        if (this.qName_ != null) {
            this.qName_ = new QName(this.getPrefix(this.element_.getName()), this.getLocalName(this.element_.getName()), this.element_.getName(), this.element_.getNamespace());
        }
        return this.qName_;
    }
}

