/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.parsers;

import butterfly.xmlview.model.Attribute;
import butterfly.xmlview.model.AttributeDeclaration;
import butterfly.xmlview.model.CDataNode;
import butterfly.xmlview.model.Comment;
import butterfly.xmlview.model.DTDDeclaration;
import butterfly.xmlview.model.Element;
import butterfly.xmlview.model.ElementDeclaration;
import butterfly.xmlview.model.NamespacePrefixMapping;
import butterfly.xmlview.model.ProcessingInstruction;
import butterfly.xmlview.model.SortedNodeVector;
import butterfly.xmlview.model.ValueNode;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.interfaces.IDTDNode;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.model.interfaces.IXmlDocument;
import butterfly.xmlview.model.validation.DTDDocument;
import butterfly.xmlview.model.validation.ValidationDocument;
import butterfly.xmlview.parsers.LocatorTranslator;
import butterfly.xmlview.parsers.SourceElementPosition;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XmlViewLaxContentHandler
implements ContentHandler,
LexicalHandler,
DeclHandler {
    private Locator locator_;
    private Vector prefixes_;
    private boolean inCdata_ = false;
    private LocatorTranslator locationTranslator_;
    private DTDDeclaration currentDTD_;
    private CDataNode currentCData_;
    private INode docRoot_;
    private Element root_;
    private Element current_;
    private ValueNode currentValueNode_;
    private IXmlDocument document_;
    private INode currentNode_;
    private INode lastParsedNode_;
    private Stack unendedElements_;
    private Attribute prefixMapping_;
    private Hashtable endedElements_;
    private String currentNamespace_;
    private ValidationDocument validationDocument_;
    private static Logger logger_;
    private StringBuffer charBuffer_;
    private boolean updateDocumentOnTheFly_ = false;
    private SortedNodeVector nodes_;
    public static final String SCHEMA_LOCATION_ATTRIBUTE = "noNamespaceSchemaLocation";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.parsers.XmlViewLaxContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public void attachAttributes(Element element, Attributes attributes) {
        int n = 0;
        while (n < attributes.getLength()) {
            if (attributes.getLocalName(n).equals("xmlns")) {
                element.setNameSpace(attributes.getValue(n));
            }
            Attribute attribute = new Attribute(element, attributes.getQName(n));
            attribute.setData(attributes.getValue(n));
            element.addAttribute(attribute);
            ++n;
        }
        if (this.document_ instanceof XmlDocument) {
            ((XmlDocument)this.document_).checkForValidationDocument(element, true);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        AttributeDeclaration attributeDeclaration = new AttributeDeclaration(string, string2, string3, string4, string5);
        this.currentDTD_.addChild(attributeDeclaration);
        this.currentNode_ = attributeDeclaration;
        this.lastParsedNode_ = attributeDeclaration;
        this.setTagPosition(attributeDeclaration);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getTextPosition();
        if (this.currentValueNode_ == null) {
            this.currentValueNode_ = new ValueNode();
            this.currentValueNode_.setStart(sourceElementPosition.getStart());
        }
        if (this.currentValueNode_.getData() != null) {
            this.currentValueNode_.setData("" + this.currentValueNode_.getData() + new String(cArray, n, n2));
        } else {
            this.currentValueNode_.setData(new String(cArray, n, n2));
        }
        this.currentValueNode_.setLength(this.currentValueNode_.toString().length());
        this.lastParsedNode_ = this.currentValueNode_;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        String string = new String(cArray, n, n2);
        Comment comment = new Comment(string);
        this.lastParsedNode_ = comment;
        this.setTagPosition(comment);
        if (this.currentNode_ != null && !(this.currentNode_ instanceof IDTDNode)) {
            this.currentNode_.addChild(comment);
        } else if (this.currentNode_ instanceof IDTDNode) {
            this.currentDTD_.addChild(comment);
        } else {
            this.docRoot_.addChild(comment);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        ElementDeclaration elementDeclaration = new ElementDeclaration(string, string2);
        this.currentDTD_.addChild(elementDeclaration);
        this.currentNode_ = elementDeclaration;
        this.lastParsedNode_ = elementDeclaration;
        this.setTagPosition(elementDeclaration);
    }

    public void endCDATA() throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        if (this.currentValueNode_ != null) {
            SourceElementPosition sourceElementPosition = this.locationTranslator_.getElementPosition();
            int n = this.document_.toString().lastIndexOf(">", sourceElementPosition.getStart());
            this.currentCData_.setLength(n + 1 - this.currentCData_.getStart());
            this.currentCData_.setData(this.currentValueNode_.getData());
            this.current_.addChild(this.currentCData_);
            this.currentNode_ = this.currentCData_;
            this.charBuffer_ = null;
            this.currentValueNode_ = null;
            this.currentCData_ = null;
        }
        this.inCdata_ = false;
        this.lastParsedNode_ = this.currentCData_;
    }

    public void endDocument() throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        if (!this.updateDocumentOnTheFly_) {
            this.docRoot_.setDocument(this.document_);
            int n = 0;
            while (n < this.docRoot_.childCount()) {
                ((XmlDocument)this.document_).registerNode(this.docRoot_.childAt(n), true);
                ++n;
            }
        }
    }

    public void endDTD() throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getPosition("]", ">");
        this.currentDTD_.setEndTagStart(sourceElementPosition.getStart());
        this.currentDTD_.setEndTagLength(2);
        DTDDocument dTDDocument = new DTDDocument(this.currentDTD_.getName(), this.currentDTD_.getPublicID(), this.currentDTD_.getSystemID());
        if (this.currentDTD_.getSystemID() == null && this.currentDTD_.getPublicID() == null) {
            dTDDocument.setText(this.currentDTD_.toXml());
        }
        this.validationDocument_ = dTDDocument;
        this.currentNode_ = this.docRoot_;
        this.current_ = null;
        this.lastParsedNode_ = this.currentDTD_;
        this.docRoot_.addChild(this.currentDTD_);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getElementPosition();
        this.current_.setEndTagStart(sourceElementPosition.getStart());
        this.current_.setEndTagLength(sourceElementPosition.getLength());
        if (sourceElementPosition.getLength() < 4) {
            this.current_.setEndTagStart(-1);
        }
        this.lastParsedNode_ = this.current_;
        if (this.currentValueNode_ != null && this.currentValueNode_.getData() != null) {
            if (this.currentValueNode_.toString().trim().length() > 0) {
                this.current_.addChild(this.currentValueNode_);
            }
            this.currentValueNode_ = null;
        }
        if (!this.current_.equals(this.root_)) {
            this.current_ = (Element)this.current_.getParent();
            this.currentNode_ = this.current_;
        }
        if (this.unendedElements_.size() > 0) {
            OpenElement openElement = (OpenElement)this.unendedElements_.pop();
            this.endedElements_.put(this.current_, openElement);
        }
    }

    public void endEntity(String string) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
    }

    public void endPrefixMapping(String string) {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
    }

    public INode getCurrentNode() {
        return this.currentNode_;
    }

    public IXmlDocument getDocument() {
        return this.document_;
    }

    public Locator getDocumentLocator() {
        return this.locator_;
    }

    public OpenElement getLastOpenElement() {
        if (this.unendedElements_.size() > 0) {
            return (OpenElement)this.unendedElements_.peek();
        }
        return null;
    }

    public INode getLastParsedNode() {
        return this.lastParsedNode_;
    }

    public LocatorTranslator getLocationTranslator() {
        return this.locationTranslator_;
    }

    public INode getRoot() {
        return this.docRoot_;
    }

    public Stack getUnendedElements() {
        return this.unendedElements_;
    }

    public ValidationDocument getValidationDocument() {
        return this.validationDocument_;
    }

    public void handleInvalidXml(String string) {
        ValueNode valueNode = new ValueNode();
        valueNode.setData(string);
        OpenElement openElement = (OpenElement)this.unendedElements_.pop();
        if (openElement != null) {
            openElement.getElement().addChild(valueNode);
        } else {
            this.current_.addChild(valueNode);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        new String(cArray, n, n2);
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        ProcessingInstruction processingInstruction = new ProcessingInstruction();
        processingInstruction.setTarget(string);
        processingInstruction.setValue(string2);
        this.setTagPosition(processingInstruction);
        if (this.current_ == null) {
            this.currentNode_ = processingInstruction;
            this.docRoot_.addChild(processingInstruction);
        } else {
            this.current_.addChild(processingInstruction);
        }
        this.lastParsedNode_ = processingInstruction;
    }

    public void setDocument(IXmlDocument iXmlDocument) {
        this.document_ = iXmlDocument;
    }

    public void setDocument(XmlDocument xmlDocument) {
        this.document_ = xmlDocument;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    public void setLastParsedNode(INode iNode) {
        this.lastParsedNode_ = iNode;
    }

    public void setLocationTranslator(LocatorTranslator locatorTranslator) {
        this.locationTranslator_ = locatorTranslator;
    }

    public void setPosition(ISourceNode iSourceNode) {
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getTextPosition();
        iSourceNode.setStart(sourceElementPosition.getStart() + 1);
        iSourceNode.setLength(sourceElementPosition.getLength() - 1);
    }

    public void setRoot(Element element) {
        this.root_ = element;
    }

    public void setTagPosition(ISourceNode iSourceNode) {
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getElementPosition();
        iSourceNode.setStart(sourceElementPosition.getStart());
        iSourceNode.setLength(sourceElementPosition.getLength());
    }

    public void skippedEntity(String string) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
    }

    public void startCDATA() throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        this.inCdata_ = true;
        this.currentCData_ = new CDataNode();
        this.currentNode_ = this.currentCData_;
        this.setTagPosition(this.currentCData_);
    }

    public void startDocument() throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        this.locationTranslator_.getTextPosition();
        this.root_ = null;
        this.current_ = null;
        this.validationDocument_ = null;
        this.prefixes_ = new Vector();
        this.docRoot_ = this.document_.getRoot();
        if (!this.updateDocumentOnTheFly_) {
            this.docRoot_.setDocument(null);
        }
        this.unendedElements_ = new Stack();
        this.endedElements_ = new Hashtable();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        this.currentDTD_ = new DTDDeclaration(string, string2, string3);
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getPosition("<", "[");
        this.currentDTD_.setStart(sourceElementPosition.getStart());
        this.currentDTD_.setLength(sourceElementPosition.getLength());
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
        Element element = new Element(string3);
        SourceElementPosition sourceElementPosition = this.locationTranslator_.getElementPosition();
        element.setStart(sourceElementPosition.getStart());
        element.setLength(sourceElementPosition.getLength());
        this.attachAttributes(element, attributes);
        this.lastParsedNode_ = element;
        if (this.currentValueNode_ != null && this.currentValueNode_.getData() != null) {
            this.currentValueNode_.setLength(this.currentValueNode_.toString().length());
            if (this.currentValueNode_.toString().trim().length() > 0) {
                this.current_.addChild(this.currentValueNode_);
            }
            this.currentValueNode_ = null;
        }
        if (this.root_ == null) {
            this.current_ = this.root_ = element;
            this.docRoot_.addChild(this.root_);
        } else {
            this.current_.addChild(element);
            this.current_ = element;
        }
        this.attachNamespacePrefixes(this.current_);
        this.currentNode_ = this.current_;
        if (this.locator_ != null) {
            this.unendedElements_.push(new OpenElement(element, this.locator_.getColumnNumber(), this.locator_.getLineNumber()));
        }
    }

    public void startEntity(String string) throws SAXException {
        this.locationTranslator_.locatorChanged(this.locator_);
    }

    public void startPrefixMapping(String string, String string2) {
        this.prefixMapping_ = new NamespacePrefixMapping(string, string2);
        if (string != null && string.length() < 1) {
            this.prefixMapping_.setParent(null);
            this.prefixMapping_.setName("xmlns");
        }
        this.prefixMapping_.setData(string2);
        this.prefixes_.add(this.prefixMapping_);
    }

    protected void attachNamespacePrefixes(Element element) {
        if (this.prefixes_ != null) {
            NamespacePrefixMapping namespacePrefixMapping = null;
            int n = 0;
            while (n < this.prefixes_.size()) {
                namespacePrefixMapping = (NamespacePrefixMapping)this.prefixes_.elementAt(n);
                element.addAttribute(namespacePrefixMapping);
                this.document_.addNamespace(namespacePrefixMapping.getPrefix(), namespacePrefixMapping.getURI());
                ++n;
            }
            this.prefixes_.clear();
        }
    }

    public void setUpdateDocumentOnTheFly(boolean bl) {
        this.updateDocumentOnTheFly_ = bl;
    }

    public class OpenElement
    extends ElementLocation {
        public OpenElement(Element element, int n, int n2) {
            super(element, n, n2);
        }
    }

    public class ElementLocation {
        private int column_;
        private int line_;
        private Element element_;

        public ElementLocation(Element element, int n, int n2) {
            this.element_ = element;
            this.column_ = n;
            this.line_ = n2;
        }

        public int getLineNumber() {
            return this.line_;
        }

        public int getColumnNumber() {
            return this.column_;
        }

        public Element getElement() {
            return this.element_;
        }
    }
}

