/*
 * Decompiled with CFR 0.152.
 */
package butterfly.xmlview.parsers;

import butterfly.xmlview.model.AbstractValidatedDocument;
import butterfly.xmlview.model.ScratchTag;
import butterfly.xmlview.model.XmlDocument;
import butterfly.xmlview.model.incremental.ScratchPad;
import butterfly.xmlview.model.interfaces.IDocument;
import butterfly.xmlview.model.interfaces.IDocumentDeclaration;
import butterfly.xmlview.model.interfaces.IModelToSourceMapping;
import butterfly.xmlview.model.interfaces.INode;
import butterfly.xmlview.model.interfaces.ISourceElement;
import butterfly.xmlview.model.interfaces.ISourceNode;
import butterfly.xmlview.parsers.XmlViewLaxContentHandler;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlViewLaxErrorHandler
implements ErrorHandler {
    private XmlViewLaxContentHandler handler_;
    private String xml_;
    private int line_;
    private int column_;
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("butterfly.xmlview.parsers.XmlViewLaxErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    XmlViewLaxErrorHandler() {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.parseInvalidXml();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.parseInvalidXml();
    }

    public XmlViewLaxContentHandler getHandler() {
        return this.handler_;
    }

    public String getXml() {
        return this.xml_;
    }

    public void handleUnrecoverableError() {
        this.parseInvalidXml();
    }

    private void parseInvalidXml() {
        try {
            INode iNode;
            Object object;
            logger_.debug((Object)"attempting to parse the invalid xml...");
            ISourceNode iSourceNode = (ISourceNode)this.handler_.getLastParsedNode();
            int n = 0;
            if (iSourceNode != null) {
                n = iSourceNode instanceof ISourceElement ? ((object = (ISourceElement)iSourceNode).getEndTagStart() > -1 ? object.getEndTagStart() + object.getEndTagLength() : iSourceNode.getStart() + iSourceNode.getLength()) : iSourceNode.getStart() + iSourceNode.getLength();
            }
            logger_.debug((Object)("taking a leap of faith...from:" + n));
            object = (XmlDocument)this.handler_.getDocument();
            INode iNode2 = ((XmlDocument)object).getRoot();
            iNode2.setDocument((IDocument)object);
            int n2 = 0;
            while (n2 < iNode2.childCount()) {
                ((XmlDocument)object).registerNode(iNode2.childAt(n2), true);
                ++n2;
            }
            ((AbstractValidatedDocument)object).setValidate(false);
            ScratchPad scratchPad = ((XmlDocument)object).getScratchPad();
            Stack stack = this.handler_.getUnendedElements();
            while (stack.size() > 0) {
                iNode = ((XmlViewLaxContentHandler.OpenElement)stack.pop()).getElement();
                scratchPad.scratchElement((ISourceElement)iNode);
            }
            if (iNode2.childCount() > 0 && iNode2.childAt(0) instanceof IDocumentDeclaration && (iNode = iNode2.childAt(0)).getStart() + iNode.getLength() > n) {
                n = iNode.getStart() + iNode.getLength();
            }
            iNode = new ScratchTag((IModelToSourceMapping)object, ScratchTag.TEXT_STATE, n, ((XmlDocument)object).getSourceBuffer().length() - n);
            ((XmlDocument)object).addChild(((XmlDocument)object).getRoot(), iNode, ((XmlDocument)object).getRoot().childCount(), false);
            ((ScratchTag)iNode).revalidateState();
            ((AbstractValidatedDocument)object).setValidate(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setHandler(XmlViewLaxContentHandler xmlViewLaxContentHandler) {
        this.handler_ = xmlViewLaxContentHandler;
    }

    public void setXml(String string) {
        this.xml_ = string;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.parseInvalidXml();
    }
}

