/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.functions.ConstructorFunction;
import org.apache.commons.jxpath.functions.MethodFunction;
import org.apache.commons.jxpath.functions.Types;

public class ClassFunctions
implements Functions {
    private Class functionClass;
    private String namespace;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public ClassFunctions(Class functionClass, String namespace) {
        this.functionClass = functionClass;
        this.namespace = namespace;
    }

    public Set getUsedNamespaces() {
        return Collections.singleton(this.namespace);
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if (!namespace.equals(this.namespace)) {
            return null;
        }
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        if (name.equals("new")) {
            Constructor constructor = Types.lookupConstructor(this.functionClass, parameters);
            if (constructor != null) {
                return new ConstructorFunction(constructor);
            }
        } else {
            Method method = Types.lookupStaticMethod(this.functionClass, name, parameters);
            if (method != null) {
                return new MethodFunction(method);
            }
            method = Types.lookupMethod(this.functionClass, name, parameters);
            if (method != null) {
                return new MethodFunction(method);
            }
        }
        return null;
    }
}

