/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.util.List;
import java.util.Locale;
import org.apache.commons.jxpath.BasicVariables;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;

public abstract class JXPathContext {
    protected JXPathContext parentContext;
    protected Object contextBean;
    protected Variables vars;
    protected Functions functions;
    protected Locale locale;
    protected boolean lenient = false;

    public static JXPathContext newContext(Object contextBean) {
        return JXPathContextFactory.newInstance().newContext(null, contextBean);
    }

    public static JXPathContext newContext(JXPathContext parentContext, Object contextBean) {
        return JXPathContextFactory.newInstance().newContext(parentContext, contextBean);
    }

    protected JXPathContext(JXPathContext parentContext, Object contextBean) {
        this.parentContext = parentContext;
        this.contextBean = contextBean;
    }

    public JXPathContext getParentContext() {
        return this.parentContext;
    }

    public Object getContextBean() {
        return this.contextBean;
    }

    public void setVariables(Variables vars) {
        this.vars = vars;
    }

    public Variables getVariables() {
        if (this.vars == null) {
            this.vars = new BasicVariables();
        }
        return this.vars;
    }

    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Functions getFunctions() {
        return this.functions;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public abstract Object getValue(String var1);

    public abstract Object getValue(String var1, Class var2);

    public abstract void setValue(String var1, Object var2);

    public abstract List eval(String var1);

    public abstract Pointer locateValue(String var1);

    public abstract List locate(String var1);
}

