/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.jxpath.Container;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLDocumentContainer
implements Container {
    private Node document;
    private URL xmlURL;
    private Source source;

    public XMLDocumentContainer(URL xmlURL) {
        this.xmlURL = xmlURL;
    }

    public XMLDocumentContainer(Source source) {
        this.source = source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue() {
        if (this.document != null) return this.document;
        try {
            InputStream stream = null;
            try {
                if (this.xmlURL != null) {
                    stream = this.xmlURL.openStream();
                    this.source = new StreamSource(stream);
                }
                DOMResult result = new DOMResult();
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.transform(this.source, result);
                this.document = (Document)result.getNode();
                Object var5_5 = null;
                if (stream == null) return this.document;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return this.document;
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot read XML from: " + (this.xmlURL != null ? this.xmlURL.toString() : this.source.getSystemId()) + "\n" + ex);
        }
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }
}

