/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.functions;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.functions.Types;

public class MethodFunction
implements Function {
    private Method method;

    public MethodFunction(Method method) {
        this.method = method;
    }

    public Object invoke(Object[] parameters) {
        try {
            Object[] args;
            Object target;
            if (Modifier.isStatic(this.method.getModifiers())) {
                target = null;
                if (parameters == null) {
                    args = null;
                } else {
                    Class<?>[] types = this.method.getParameterTypes();
                    args = new Object[parameters.length];
                    int i = 0;
                    while (i < args.length) {
                        args[i] = Types.convert(parameters[i], types[i]);
                        ++i;
                    }
                }
            } else {
                target = Types.convert(parameters[0], this.method.getDeclaringClass());
                Class<?>[] types = this.method.getParameterTypes();
                args = new Object[parameters.length - 1];
                int i = 0;
                while (i < args.length) {
                    args[i] = Types.convert(parameters[i + 1], types[i]);
                    ++i;
                }
            }
            return this.method.invoke(target, args);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot invoke " + this.method + ": " + exception);
        }
    }
}

