/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.functions.ConstructorFunction;
import org.apache.commons.jxpath.functions.MethodFunction;
import org.apache.commons.jxpath.functions.Types;

public class PackageFunctions
implements Functions {
    private String classPrefix;
    private String namespace;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static /* synthetic */ Class class$java$lang$Object;

    public PackageFunctions(String classPrefix, String namespace) {
        this.classPrefix = classPrefix;
        this.namespace = namespace;
    }

    public Set getUsedNamespaces() {
        return Collections.singleton(this.namespace);
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        Class<?> functionClass;
        String fullName;
        int inx;
        if (namespace == null && this.namespace != null || namespace != null && !namespace.equals(this.namespace)) {
            return null;
        }
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        if (parameters.length >= 1) {
            Method method;
            Object target = parameters[0];
            if (target != null && target instanceof ExpressionContext) {
                target = ((ExpressionContext)target).getContextNodePointer().getValue();
            }
            if (target != null && (method = Types.lookupMethod(class$java$lang$Object == null ? (class$java$lang$Object = PackageFunctions.class$("java.lang.Object")) : class$java$lang$Object, name, parameters)) != null) {
                return new MethodFunction(method);
            }
        }
        if ((inx = (fullName = this.classPrefix + name).lastIndexOf(46)) == -1) {
            return null;
        }
        String className = fullName.substring(0, inx);
        String methodName = fullName.substring(inx + 1);
        try {
            functionClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Class not found: " + ex);
        }
        if (methodName.endsWith("new")) {
            Constructor constructor = Types.lookupConstructor(functionClass, parameters);
            if (constructor != null) {
                return new ConstructorFunction(constructor);
            }
        } else {
            Method method = Types.lookupStaticMethod(functionClass, methodName, parameters);
            if (method != null) {
                return new MethodFunction(method);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

