/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Pointer;

public class Types {
    public static final int NO_MATCH = 0;
    public static final int APPROXIMATE_MATCH = 1;
    public static final int EXACT_MATCH = 2;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static Constructor lookupConstructor(Class targetClass, Object[] parameters) {
        boolean tryExact = true;
        int count = parameters.length;
        Class[] types = new Class[count];
        int i = 0;
        while (i < count) {
            Object param = parameters[i];
            if (param != null) {
                types[i] = param.getClass();
            } else {
                types[i] = null;
                tryExact = false;
            }
            ++i;
        }
        Constructor<Object> constructor = null;
        if (tryExact) {
            try {
                constructor = targetClass.getConstructor(types);
                if (constructor != null) {
                    return constructor;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Constructor<?>[] constructors = targetClass.getConstructors();
        int i2 = 0;
        while (i2 < constructors.length) {
            int match = Types.matchParameterTypes(constructors[i2].getParameterTypes(), parameters);
            if (match != 0) {
                if (match > currentMatch) {
                    constructor = constructors[i2];
                    currentMatch = match;
                    ambiguous = false;
                } else if (match == currentMatch) {
                    ambiguous = true;
                }
            }
            ++i2;
        }
        if (ambiguous) {
            throw new RuntimeException("Ambigous constructor " + Arrays.asList(parameters));
        }
        return constructor;
    }

    public static Method lookupStaticMethod(Class targetClass, String name, Object[] parameters) {
        boolean tryExact = true;
        int count = parameters.length;
        Class[] types = new Class[count];
        int i = 0;
        while (i < count) {
            Object param = parameters[i];
            if (param != null) {
                types[i] = param.getClass();
            } else {
                types[i] = null;
                tryExact = false;
            }
            ++i;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Method[] methods = targetClass.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            int match;
            if (Modifier.isStatic(methods[i2].getModifiers()) && methods[i2].getName().equals(name) && (match = Types.matchParameterTypes(methods[i2].getParameterTypes(), parameters)) != 0) {
                if (match > currentMatch) {
                    method = methods[i2];
                    currentMatch = match;
                    ambiguous = false;
                } else if (match == currentMatch) {
                    ambiguous = true;
                }
            }
            ++i2;
        }
        if (ambiguous) {
            throw new RuntimeException("Ambigous method call: " + name);
        }
        return method;
    }

    public static Method lookupMethod(Class targetClass, String name, Object[] parameters) {
        if (parameters.length < 1 || parameters[0] == null) {
            return null;
        }
        if (Types.matchType(targetClass, parameters[0]) == 0) {
            return null;
        }
        targetClass = Types.convert(parameters[0], targetClass).getClass();
        boolean tryExact = true;
        int count = parameters.length - 1;
        Class[] types = new Class[count];
        Object[] arguments = new Object[count];
        int i = 0;
        while (i < count) {
            Object param;
            arguments[i] = param = parameters[i + 1];
            if (param != null) {
                types[i] = param.getClass();
            } else {
                types[i] = null;
                tryExact = false;
            }
            ++i;
        }
        Method method = null;
        if (tryExact) {
            try {
                method = targetClass.getMethod(name, types);
                if (method != null && !Modifier.isStatic(method.getModifiers())) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        int currentMatch = 0;
        boolean ambiguous = false;
        Method[] methods = targetClass.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            int match;
            if (!Modifier.isStatic(methods[i2].getModifiers()) && methods[i2].getName().equals(name) && (match = Types.matchParameterTypes(methods[i2].getParameterTypes(), arguments)) != 0) {
                if (match > currentMatch) {
                    method = methods[i2];
                    currentMatch = match;
                    ambiguous = false;
                } else if (match == currentMatch) {
                    ambiguous = true;
                }
            }
            ++i2;
        }
        if (ambiguous) {
            throw new RuntimeException("Ambigous method call: " + name);
        }
        return method;
    }

    public static int matchParameterTypes(Class[] types, Object[] parameters) {
        if (types.length != parameters.length) {
            return 0;
        }
        int totalMatch = 2;
        int i = 0;
        while (i < types.length) {
            int match = Types.matchType(types[i], parameters[i]);
            if (match == 0) {
                return 0;
            }
            if (match < totalMatch) {
                totalMatch = match;
            }
            ++i;
        }
        return totalMatch;
    }

    public static int matchType(Class expected, Object object) {
        if (object == null) {
            return 1;
        }
        Class<?> actual = object.getClass();
        if (expected.equals(actual)) {
            return 2;
        }
        if (expected.isAssignableFrom(actual)) {
            return 2;
        }
        if (Types.canConvert(object, expected)) {
            return 1;
        }
        return 0;
    }

    public static boolean canConvert(Object object, Class toType) {
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType)) {
            return true;
        }
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        if (toType == (class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE || (class$java$lang$Number == null ? (class$java$lang$Number = Types.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
                return true;
            }
        } else if (object instanceof Number) {
            if (toType.isPrimitive() || (class$java$lang$Number == null ? (class$java$lang$Number = Types.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
                return true;
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return true;
            }
        } else if (object instanceof String) {
            if (toType.isPrimitive()) {
                return true;
            }
        } else if (object instanceof ExpressionContext) {
            if ((class$java$util$Collection == null ? (class$java$util$Collection = Types.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
                return true;
            }
            Object value = ((ExpressionContext)object).getContextNodePointer().getValue();
            return Types.canConvert(value, toType);
        }
        return false;
    }

    public static Object convert(Object object, Class toType) {
        if (object == null) {
            return null;
        }
        if (object instanceof ExpressionContext) {
            if ((class$java$util$Collection == null ? (class$java$util$Collection = Types.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(toType)) {
                List list = ((ExpressionContext)object).getContextNodeList();
                AbstractCollection result = new ArrayList();
                if (toType == (class$java$util$List == null ? (class$java$util$List = Types.class$("java.util.List")) : class$java$util$List) || toType == (class$java$util$ArrayList == null ? (class$java$util$ArrayList = Types.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                    result = new ArrayList();
                } else if (toType == (class$java$util$Vector == null ? (class$java$util$Vector = Types.class$("java.util.Vector")) : class$java$util$Vector)) {
                    result = new Vector();
                } else if (toType == (class$java$util$Set == null ? (class$java$util$Set = Types.class$("java.util.Set")) : class$java$util$Set) || toType == (class$java$util$HashSet == null ? (class$java$util$HashSet = Types.class$("java.util.HashSet")) : class$java$util$HashSet)) {
                    result = new HashSet();
                }
                int count = list.size();
                int i = 0;
                while (i < count) {
                    Pointer ptr = (Pointer)list.get(i);
                    result.add(ptr.getValue());
                    ++i;
                }
                return result;
            }
            Object value = ((ExpressionContext)object).getContextNodePointer().getValue();
            return Types.convert(value, toType);
        }
        Class<?> fromType = object.getClass();
        if (fromType.equals(toType) || toType.isAssignableFrom(fromType)) {
            return object;
        }
        if (toType == (class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String)) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            if (toType == Boolean.TYPE) {
                return object;
            }
            boolean value = (Boolean)object;
            return Types.allocateNumber(toType, value ? 1.0 : 0.0);
        }
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            if (toType == Boolean.TYPE || toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Types.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return value == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (toType.isPrimitive() || (class$java$lang$Number == null ? (class$java$lang$Number = Types.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(toType)) {
                return Types.allocateNumber(toType, value);
            }
        } else if (object instanceof Character) {
            if (toType == Character.TYPE) {
                return object;
            }
        } else if (object instanceof String) {
            if (toType == Boolean.TYPE || toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Types.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return new Boolean((String)object);
            }
            if (toType == Character.TYPE || toType == (class$java$lang$Character == null ? (class$java$lang$Character = Types.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Character(((String)object).charAt(0));
            }
            if (toType == Byte.TYPE || toType == (class$java$lang$Byte == null ? (class$java$lang$Byte = Types.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte((String)object);
            }
            if (toType == Short.TYPE || toType == (class$java$lang$Short == null ? (class$java$lang$Short = Types.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short((String)object);
            }
            if (toType == Integer.TYPE || toType == (class$java$lang$Integer == null ? (class$java$lang$Integer = Types.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer((String)object);
            }
            if (toType == Long.TYPE || toType == (class$java$lang$Long == null ? (class$java$lang$Long = Types.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long((String)object);
            }
            if (toType == Float.TYPE || toType == (class$java$lang$Float == null ? (class$java$lang$Float = Types.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float((String)object);
            }
            if (toType == Double.TYPE || toType == (class$java$lang$Double == null ? (class$java$lang$Double = Types.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double((String)object);
            }
        }
        return object;
    }

    private static Number allocateNumber(Class type, double value) {
        if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Types.class$("java.lang.Byte")) : class$java$lang$Byte) || type == Byte.TYPE) {
            return new Byte((byte)value);
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = Types.class$("java.lang.Short")) : class$java$lang$Short) || type == Short.TYPE) {
            return new Short((short)value);
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Types.class$("java.lang.Integer")) : class$java$lang$Integer) || type == Integer.TYPE) {
            return new Integer((int)value);
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = Types.class$("java.lang.Long")) : class$java$lang$Long) || type == Long.TYPE) {
            return new Long((long)value);
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = Types.class$("java.lang.Float")) : class$java$lang$Float) || type == Float.TYPE) {
            return new Float((float)value);
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = Types.class$("java.lang.Double")) : class$java$lang$Double) || type == Double.TYPE) {
            return new Double(value);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

