/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.axes.AncestorContext;
import org.apache.commons.jxpath.ri.axes.AttributeContext;
import org.apache.commons.jxpath.ri.axes.ChildContext;
import org.apache.commons.jxpath.ri.axes.DescendantContext;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.NamespaceContext;
import org.apache.commons.jxpath.ri.axes.ParentContext;
import org.apache.commons.jxpath.ri.axes.PrecedingOrFollowingContext;
import org.apache.commons.jxpath.ri.axes.PredicateContext;
import org.apache.commons.jxpath.ri.axes.RootContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.axes.UnionContext;
import org.apache.commons.jxpath.ri.compiler.Constant;
import org.apache.commons.jxpath.ri.compiler.CoreFunction;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.ExpressionPath;
import org.apache.commons.jxpath.ri.compiler.ExtensionFunction;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.compiler.VariableReference;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.NullPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.pointers.PropertyPointer;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public abstract class EvalContext
implements ExpressionContext {
    protected EvalContext parentContext;
    protected RootContext rootContext;
    protected int position = 0;
    private boolean startedSetIteration = false;
    protected static Double ZERO = new Double(0.0);
    protected static Double ONE = new Double(1.0);
    protected static Double NaN = new Double(Double.NaN);
    private static final Object FAILURE = new Object();

    public EvalContext(EvalContext parentContext) {
        this.parentContext = parentContext;
    }

    public RootContext getRootContext() {
        if (this.rootContext == null) {
            this.rootContext = this.parentContext.getRootContext();
        }
        return this.rootContext;
    }

    protected void reset() {
        this.position = 0;
    }

    public int getCurrentPosition() {
        return this.position;
    }

    public Pointer getContextNodePointer() {
        if (this.position == 0) {
            while (this.nextSet()) {
                if (!this.next()) continue;
                return this.getCurrentNodePointer();
            }
            return null;
        }
        return this.getCurrentNodePointer();
    }

    /*
     * Unable to fully structure code
     */
    public List getContextNodeList() {
        list = new ArrayList<NodePointer>();
        ** GOTO lbl7
        {
            list.add(this.getCurrentNodePointer());
            do {
                if (this.next()) continue block0;
lbl7:
                // 2 sources

            } while (this.nextSet());
        }
        return list;
    }

    public abstract NodePointer getCurrentNodePointer();

    /*
     * Unable to fully structure code
     */
    public boolean nextSet() {
        this.setPosition(0);
        if (!this.startedSetIteration) {
            this.startedSetIteration = true;
            while (this.parentContext.nextSet()) {
                if (!this.parentContext.next()) continue;
                return true;
            }
            return false;
        }
        if (!this.parentContext.next()) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (!this.parentContext.next()) continue;
            return true;
lbl13:
            // 2 sources

            ** while (this.parentContext.nextSet())
        }
lbl14:
        // 1 sources

        return false;
    }

    public abstract boolean next();

    public boolean setPosition(int position) {
        this.position = position;
        return true;
    }

    protected EvalContext getVariable(QName variableName) {
        return this.getRootContext().getVariableContext(variableName);
    }

    public Object eval(Expression expression) {
        return this.eval(expression, true);
    }

    public Object eval(Expression expression, boolean firstMatch) {
        Object value = null;
        switch (expression.getEvaluationMode()) {
            case 0: 
            case 2: {
                value = this.evalExpression(expression, firstMatch);
                break;
            }
            case 1: {
                RootContext root = this.getRootContext();
                int id = expression.getID();
                if (id == -1) {
                    value = this.evalExpression(expression, firstMatch);
                    id = root.setRegisteredValue(value);
                    expression.setID(id);
                    break;
                }
                value = root.getRegisteredValue(id);
            }
        }
        return value;
    }

    private Object evalExpression(Expression expression, boolean firstMatch) {
        int op = expression.getExpressionTypeCode();
        switch (op) {
            case 5: {
                return ((Constant)expression).getValue();
            }
            case 19: {
                return this.union(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 9: {
                return this.minus(((CoreOperation)expression).getArg1());
            }
            case 1: {
                return this.sum(((CoreOperation)expression).getArguments());
            }
            case 2: {
                return this.minus(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 3: {
                return this.mult(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 4: {
                return this.div(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 10: {
                return this.mod(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 11: {
                return this.lt(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 12: {
                return this.gt(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 13: {
                return this.lte(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 14: {
                return this.gte(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 15: {
                return this.eq(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 16: {
                return this.ne(((CoreOperation)expression).getArg1(), ((CoreOperation)expression).getArg2());
            }
            case 7: {
                return this.and(((CoreOperation)expression).getArguments());
            }
            case 8: {
                return this.or(((CoreOperation)expression).getArguments());
            }
            case 17: {
                return this.getVariable(((VariableReference)expression).getVariableName());
            }
            case 22: {
                return this.coreFunction((CoreFunction)expression);
            }
            case 20: {
                return this.path((LocationPath)expression, firstMatch);
            }
            case 21: {
                return this.expressionPath(((ExpressionPath)expression).getExpression(), ((ExpressionPath)expression).getPredicates(), ((ExpressionPath)expression).getSteps(), firstMatch);
            }
            case 18: {
                return this.function(((ExtensionFunction)expression).getFunctionName(), ((ExtensionFunction)expression).getArguments());
            }
        }
        return null;
    }

    protected Object union(Expression left, Expression right) {
        Object l = this.eval(left, false);
        Object r = this.eval(right, false);
        EvalContext lctx = l instanceof EvalContext ? (EvalContext)l : this.getRootContext().getConstantContext(l);
        EvalContext rctx = r instanceof EvalContext ? (EvalContext)r : this.getRootContext().getConstantContext(r);
        return new UnionContext(this.getRootContext(), new EvalContext[]{lctx, rctx});
    }

    protected Object minus(Expression arg) {
        double a = EvalContext.doubleValue(this.eval(arg));
        return new Double(-a);
    }

    protected Object sum(Expression[] arguments) {
        double s = 0.0;
        int i = 0;
        while (i < arguments.length) {
            s += EvalContext.doubleValue(this.eval(arguments[i]));
            ++i;
        }
        return new Double(s);
    }

    protected Object minus(Expression left, Expression right) {
        double l = EvalContext.doubleValue(this.eval(left));
        double r = EvalContext.doubleValue(this.eval(right));
        return new Double(l - r);
    }

    protected Object div(Expression left, Expression right) {
        double l = EvalContext.doubleValue(this.eval(left));
        double r = EvalContext.doubleValue(this.eval(right));
        return new Double(l / r);
    }

    protected Object mult(Expression left, Expression right) {
        double l = EvalContext.doubleValue(this.eval(left));
        double r = EvalContext.doubleValue(this.eval(right));
        return new Double(l * r);
    }

    protected Object mod(Expression left, Expression right) {
        long l = (long)EvalContext.doubleValue(this.eval(left));
        long r = (long)EvalContext.doubleValue(this.eval(right));
        return new Double(l % r);
    }

    protected Object lt(Expression left, Expression right) {
        double r;
        double l = EvalContext.doubleValue(this.eval(left));
        return l < (r = EvalContext.doubleValue(this.eval(right))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object gt(Expression left, Expression right) {
        double r;
        double l = EvalContext.doubleValue(this.eval(left));
        return l > (r = EvalContext.doubleValue(this.eval(right))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object lte(Expression left, Expression right) {
        double r;
        double l = EvalContext.doubleValue(this.eval(left));
        return l <= (r = EvalContext.doubleValue(this.eval(right))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object gte(Expression left, Expression right) {
        double r;
        double l = EvalContext.doubleValue(this.eval(left));
        return l >= (r = EvalContext.doubleValue(this.eval(right))) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object eq(Expression left, Expression right) {
        return this.equal(left, right) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object ne(Expression left, Expression right) {
        return this.equal(left, right) ? Boolean.FALSE : Boolean.TRUE;
    }

    protected boolean equal(Expression left, Expression right) {
        boolean result;
        Object r;
        Object l = this.eval(left);
        if (l == (r = this.eval(right))) {
            return true;
        }
        if (l instanceof EvalContext && r instanceof EvalContext) {
            HashSet lset = new HashSet(((EvalContext)l).valueSet());
            HashSet rset = new HashSet(((EvalContext)r).valueSet());
            return lset.equals(rset);
        }
        if (l instanceof EvalContext) {
            l = ((EvalContext)l).getContextNodePointer();
        }
        if (r instanceof EvalContext) {
            r = ((EvalContext)r).getContextNodePointer();
        }
        if (l instanceof Pointer && r instanceof Pointer && l.equals(r)) {
            return true;
        }
        if (l instanceof Pointer) {
            l = ((Pointer)l).getValue();
        }
        if (r instanceof Pointer) {
            r = ((Pointer)r).getValue();
        }
        if (l instanceof Boolean || r instanceof Boolean) {
            result = EvalContext.booleanValue(l) == EvalContext.booleanValue(r);
        } else if (l instanceof Number || r instanceof Number) {
            result = EvalContext.doubleValue(l) == EvalContext.doubleValue(r);
        } else if (l instanceof String || r instanceof String) {
            result = EvalContext.stringValue(l).equals(EvalContext.stringValue(r));
        } else {
            if (l == null) {
                return r == null;
            }
            result = l.equals(r);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private Set valueSet() {
        set = new HashSet<Object>();
        ** GOTO lbl8
        {
            pointer = this.getCurrentNodePointer();
            set.add(pointer.getValue());
            do {
                if (this.next()) continue block0;
lbl8:
                // 2 sources

            } while (this.nextSet());
        }
        return set;
    }

    protected Object and(Expression[] arguments) {
        int i = 0;
        while (i < arguments.length) {
            if (!EvalContext.booleanValue(this.eval(arguments[i]))) {
                return Boolean.FALSE;
            }
            ++i;
        }
        return Boolean.TRUE;
    }

    protected Object or(Expression[] arguments) {
        int i = 0;
        while (i < arguments.length) {
            if (EvalContext.booleanValue(this.eval(arguments[i]))) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    public static String stringValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            return String.valueOf(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        if (object == null) {
            return "";
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            short nodeType = node.getNodeType();
            if (nodeType == 8) {
                String text = ((Comment)node).getData();
                return text == null ? "" : text.trim();
            }
            if (nodeType == 3 || nodeType == 4) {
                String text = node.getNodeValue();
                return text == null ? "" : text.trim();
            }
            if (nodeType == 7) {
                String text = ((ProcessingInstruction)node).getData();
                return text == null ? "" : text.trim();
            }
            NodeList list = node.getChildNodes();
            StringBuffer buf = new StringBuffer(16);
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child.getNodeType() == 3) {
                    buf.append(child.getNodeValue());
                } else {
                    buf.append(EvalContext.stringValue(child));
                }
                ++i;
            }
            return buf.toString().trim();
        }
        if (object instanceof NodePointer) {
            return EvalContext.stringValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getContextNodePointer();
            if (ptr != null) {
                return EvalContext.stringValue(ptr);
            }
            return "";
        }
        return String.valueOf(object);
    }

    protected Number number(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? ONE : ZERO;
        }
        if (object instanceof String) {
            Double value;
            try {
                value = new Double((String)object);
            }
            catch (NumberFormatException ex) {
                value = NaN;
            }
            return value;
        }
        if (object instanceof Node) {
            return this.number(EvalContext.stringValue(object));
        }
        if (object instanceof EvalContext) {
            return this.number(EvalContext.stringValue(object));
        }
        if (object instanceof NodePointer) {
            return this.number(((NodePointer)object).getValue());
        }
        return ZERO;
    }

    public static double doubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 0.0 : 1.0;
        }
        if (object instanceof String) {
            double value;
            if (object.equals("")) {
                return 0.0;
            }
            try {
                value = Double.parseDouble((String)object);
            }
            catch (NumberFormatException ex) {
                value = Double.NaN;
            }
            return value;
        }
        if (object instanceof Node) {
            return EvalContext.doubleValue(EvalContext.stringValue(object));
        }
        if (object instanceof NodePointer) {
            return EvalContext.doubleValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            return EvalContext.doubleValue(EvalContext.stringValue(object));
        }
        return 0.0;
    }

    public static boolean booleanValue(Object object) {
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            return value != 0.0 && value != 0.0 && !Double.isNaN(value);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            return ctx.nextSet() && ctx.next();
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Node) {
            return EvalContext.stringValue(object).length() != 0;
        }
        if (object instanceof NodePointer) {
            return EvalContext.booleanValue(((NodePointer)object).getValue());
        }
        return false;
    }

    protected Object path(LocationPath path, boolean firstMatch) {
        Object result;
        boolean basic;
        Step[] steps = path.getSteps();
        EvalContext rootContext = path.isAbsolute() ? this.getRootContext() : this;
        if (firstMatch && (basic = path.getEvaluationHint("basicPathHint").equals(Boolean.TRUE)) && (result = this.tryBasicPath(new InitialContext(rootContext), steps)) != FAILURE) {
            return result;
        }
        InitialContext aContext = new InitialContext(rootContext);
        return this.evalSteps(aContext, steps, firstMatch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object tryBasicPath(EvalContext context, Step[] steps) {
        NodePointer ptr = (NodePointer)context.getContextNodePointer();
        if (ptr == null || !(ptr instanceof PropertyOwnerPointer)) {
            return FAILURE;
        }
        PropertyOwnerPointer pointer = (PropertyOwnerPointer)ptr.clone();
        int i = 0;
        while (i < steps.length) {
            String propertyName = ((NodeNameTest)steps[i].getNodeTest()).getNodeName().getName();
            pointer = pointer.getPropertyPointer();
            ((PropertyPointer)pointer).setPropertyName(propertyName);
            Expression[] predicates = steps[i].getPredicates();
            if (predicates == null || predicates.length == 0) return FAILURE;
            boolean dynamicProperty = false;
            Expression expr = (Expression)predicates[0].getEvaluationHint("dynamicPropertyAccessHint");
            if (expr != null) {
                String prop = EvalContext.stringValue(this.eval(expr, true));
                pointer = pointer.getPropertyPointer();
                ((PropertyPointer)pointer).setPropertyName(prop);
            } else {
                Object predicate = this.eval(predicates[0], true);
                if (predicate instanceof EvalContext) {
                    predicate = ((EvalContext)predicate).getContextNodePointer();
                }
                if (predicate instanceof Pointer) {
                    predicate = ((Pointer)predicate).getValue();
                }
                if (predicate == null) {
                    throw new RuntimeException("Predicate is null: " + predicates[0]);
                }
                if (predicate instanceof Number) {
                    int index = (int)(EvalContext.doubleValue(predicate) + 0.5);
                    if (index <= 0 || index > pointer.getLength()) return null;
                    pointer.setIndex(index - 1);
                } else if (!EvalContext.booleanValue(predicate)) {
                    return null;
                }
            }
            ++i;
        }
        return pointer;
    }

    protected Object expressionPath(Expression expression, Expression[] predicates, Step[] steps, boolean firstMatch) {
        Object value = this.eval(expression, false);
        EvalContext context = value instanceof InitialContext ? (InitialContext)value : (value instanceof EvalContext ? new UnionContext(this, new EvalContext[]{(EvalContext)value}) : this.getRootContext().getConstantContext(value));
        if (predicates != null) {
            int j = 0;
            while (j < predicates.length) {
                context = new PredicateContext(context, predicates[j]);
                ++j;
            }
        }
        return this.evalSteps(context, steps, firstMatch);
    }

    private Object evalSteps(EvalContext context, Step[] steps, boolean firstMatch) {
        int i = 0;
        while (i < steps.length) {
            context = this.createContextForStep(context, steps[i].getAxis(), steps[i].getNodeTest());
            Expression[] predicates = steps[i].getPredicates();
            if (predicates != null) {
                int j = 0;
                while (j < predicates.length) {
                    context = new PredicateContext(context, predicates[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (firstMatch) {
            Pointer ptr = context.getContextNodePointer();
            return ptr;
        }
        return context;
    }

    protected EvalContext createContextForStep(EvalContext context, int axis, NodeTest nodeTest) {
        switch (axis) {
            case 4: {
                return new AncestorContext(context, false, nodeTest);
            }
            case 10: {
                return new AncestorContext(context, true, nodeTest);
            }
            case 5: {
                return new AttributeContext(context, nodeTest);
            }
            case 2: {
                return new ChildContext(context, nodeTest, false, false);
            }
            case 9: {
                return new DescendantContext(context, false, nodeTest);
            }
            case 13: {
                return new DescendantContext(context, true, nodeTest);
            }
            case 8: {
                return new PrecedingOrFollowingContext(context, nodeTest, false);
            }
            case 11: {
                return new ChildContext(context, nodeTest, true, false);
            }
            case 6: {
                return new NamespaceContext(context, nodeTest);
            }
            case 3: {
                return new ParentContext(context, nodeTest);
            }
            case 7: {
                return new PrecedingOrFollowingContext(context, nodeTest, true);
            }
            case 12: {
                return new ChildContext(context, nodeTest, true, true);
            }
            case 1: {
                return new SelfContext(context, nodeTest);
            }
        }
        return null;
    }

    protected Object function(QName functionName, Expression[] arguments) {
        Function function;
        Object[] parameters = null;
        if (arguments != null) {
            parameters = new Object[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                parameters[i] = this.eval(arguments[i]);
                ++i;
            }
        }
        if ((function = this.getRootContext().getFunction(functionName, parameters)) == null) {
            throw new RuntimeException("No such function: " + functionName + Arrays.asList(parameters));
        }
        return function.invoke(parameters);
    }

    protected Object coreFunction(CoreFunction function) {
        int code = function.getFunctionCode();
        switch (code) {
            case 1: {
                return this.functionLast(function);
            }
            case 2: {
                return this.functionPosition(function);
            }
            case 3: {
                return this.functionCount(function);
            }
            case 22: {
                return this.functionLang(function);
            }
            case 4: {
                System.err.println("UNIMPLEMENTED: " + function);
                return null;
            }
            case 5: {
                return this.functionLocalName(function);
            }
            case 6: {
                return this.functionNamespaceURI(function);
            }
            case 7: {
                return this.functionName(function);
            }
            case 8: {
                return this.functionString(function);
            }
            case 9: {
                return this.functionConcat(function);
            }
            case 10: {
                return this.functionStartsWith(function);
            }
            case 11: {
                return this.functionContains(function);
            }
            case 12: {
                return this.functionSubstringBefore(function);
            }
            case 13: {
                return this.functionSubstringAfter(function);
            }
            case 14: {
                return this.functionSubstring(function);
            }
            case 15: {
                return this.functionStringLength(function);
            }
            case 16: {
                return this.functionNormalizeSpace(function);
            }
            case 17: {
                return this.functionTranslate(function);
            }
            case 18: {
                return this.functionBoolean(function);
            }
            case 19: {
                return this.functionNot(function);
            }
            case 20: {
                return this.functionTrue(function);
            }
            case 21: {
                return this.functionFalse(function);
            }
            case 28: {
                return this.functionNull(function);
            }
            case 23: {
                return this.functionNumber(function);
            }
            case 24: {
                return this.functionSum(function);
            }
            case 25: {
                return this.functionFloor(function);
            }
            case 26: {
                return this.functionCeiling(function);
            }
            case 27: {
                return this.functionRound(function);
            }
        }
        return null;
    }

    protected Object functionLast(CoreFunction function) {
        this.assertArgCount(function, 0);
        int old = this.getCurrentPosition();
        this.setPosition(0);
        int count = 0;
        while (this.next()) {
            ++count;
        }
        if (old != 0) {
            this.setPosition(old);
        }
        return new Double(count);
    }

    protected Object functionPosition(CoreFunction function) {
        this.assertArgCount(function, 0);
        return new Integer(this.getCurrentPosition());
    }

    /*
     * Unable to fully structure code
     */
    protected Object functionCount(CoreFunction function) {
        block4: {
            block3: {
                this.assertArgCount(function, 1);
                arg1 = function.getArg1();
                count = 0;
                value = this.eval(arg1, false);
                if (value instanceof Pointer) {
                    value = ((Pointer)value).getValue();
                }
                if (!(value instanceof EvalContext)) break block3;
                ctx = (EvalContext)value;
                ** GOTO lbl13
                {
                    ++count;
                    do {
                        if (ctx.next()) continue block0;
lbl13:
                        // 2 sources

                    } while (ctx.nextSet());
                }
                break block4;
            }
            count = value instanceof Collection != false ? ((Collection)value).size() : (value == null ? 0 : 1);
        }
        return new Double(count);
    }

    protected Object functionLang(CoreFunction function) {
        this.assertArgCount(function, 1);
        String lang = EvalContext.stringValue(this.eval(function.getArg1()));
        NodePointer pointer = (NodePointer)this.getContextNodePointer();
        if (pointer == null) {
            return Boolean.FALSE;
        }
        return pointer.isLanguage(lang) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionNamespaceURI(CoreFunction function) {
        EvalContext ctx;
        if (function.getArgumentCount() == 0) {
            return this.getCurrentNodePointer();
        }
        this.assertArgCount(function, 1);
        Object set = this.eval(function.getArg1(), false);
        if (set instanceof EvalContext && (ctx = (EvalContext)set).nextSet() && ctx.next()) {
            String str = ctx.getCurrentNodePointer().getNamespaceURI();
            return str == null ? "" : str;
        }
        return "";
    }

    protected Object functionLocalName(CoreFunction function) {
        EvalContext ctx;
        if (function.getArgumentCount() == 0) {
            return this.getCurrentNodePointer();
        }
        this.assertArgCount(function, 1);
        Object set = this.eval(function.getArg1(), false);
        if (set instanceof EvalContext && (ctx = (EvalContext)set).nextSet() && ctx.next()) {
            return ctx.getCurrentNodePointer().getName().getName();
        }
        return "";
    }

    protected Object functionName(CoreFunction function) {
        EvalContext ctx;
        if (function.getArgumentCount() == 0) {
            return this.getCurrentNodePointer();
        }
        this.assertArgCount(function, 1);
        Object set = this.eval(function.getArg1(), false);
        if (set instanceof EvalContext && (ctx = (EvalContext)set).nextSet() && ctx.next()) {
            return ctx.getCurrentNodePointer().getExpandedName().toString();
        }
        return "";
    }

    protected Object functionString(CoreFunction function) {
        if (function.getArgumentCount() == 0) {
            return EvalContext.stringValue(this.getCurrentNodePointer());
        }
        this.assertArgCount(function, 1);
        return EvalContext.stringValue(this.eval(function.getArg1()));
    }

    protected Object functionConcat(CoreFunction function) {
        if (function.getArgumentCount() < 2) {
            this.assertArgCount(function, 2);
        }
        StringBuffer buffer = new StringBuffer();
        Expression[] args = function.getArguments();
        int i = 0;
        while (i < args.length) {
            buffer.append(EvalContext.stringValue(this.eval(args[i])));
            ++i;
        }
        return buffer.toString();
    }

    protected Object functionStartsWith(CoreFunction function) {
        this.assertArgCount(function, 2);
        String s1 = EvalContext.stringValue(this.eval(function.getArg1()));
        String s2 = EvalContext.stringValue(this.eval(function.getArg2()));
        return s1.startsWith(s2) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionContains(CoreFunction function) {
        this.assertArgCount(function, 2);
        String s1 = EvalContext.stringValue(this.eval(function.getArg1()));
        String s2 = EvalContext.stringValue(this.eval(function.getArg2()));
        return s1.indexOf(s2) != -1 ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionSubstringBefore(CoreFunction function) {
        this.assertArgCount(function, 2);
        String s1 = EvalContext.stringValue(this.eval(function.getArg1()));
        String s2 = EvalContext.stringValue(this.eval(function.getArg2()));
        int index = s1.indexOf(s2);
        if (index == -1) {
            return "";
        }
        return s1.substring(0, index);
    }

    protected Object functionSubstringAfter(CoreFunction function) {
        this.assertArgCount(function, 2);
        String s1 = EvalContext.stringValue(this.eval(function.getArg1()));
        String s2 = EvalContext.stringValue(this.eval(function.getArg2()));
        int index = s1.indexOf(s2);
        if (index == -1) {
            return "";
        }
        return s1.substring(index + s2.length());
    }

    protected Object functionSubstring(CoreFunction function) {
        int ac = function.getArgumentCount();
        if (ac != 2 && ac != 3) {
            this.assertArgCount(function, 2);
        }
        String s1 = EvalContext.stringValue(this.eval(function.getArg1()));
        double from = EvalContext.doubleValue(this.eval(function.getArg2()));
        if (Double.isNaN(from)) {
            return "";
        }
        from = Math.round(from);
        if (ac == 2) {
            if (from < 1.0) {
                from = 1.0;
            }
            return s1.substring((int)from - 1);
        }
        double length = EvalContext.doubleValue(this.eval(function.getArg3()));
        if ((length = (double)Math.round(length)) < 0.0) {
            return "";
        }
        double to = from + length;
        if (to < 1.0) {
            return "";
        }
        if (to > (double)(s1.length() + 1)) {
            if (from < 1.0) {
                from = 1.0;
            }
            return s1.substring((int)from - 1);
        }
        if (from < 1.0) {
            from = 1.0;
        }
        return s1.substring((int)from - 1, (int)(to - 1.0));
    }

    protected Object functionStringLength(CoreFunction function) {
        String s;
        if (function.getArgumentCount() == 0) {
            s = EvalContext.stringValue(this.getCurrentNodePointer());
        } else {
            this.assertArgCount(function, 1);
            s = EvalContext.stringValue(this.eval(function.getArg1()));
        }
        return new Double(s.length());
    }

    protected Object functionNormalizeSpace(CoreFunction function) {
        this.assertArgCount(function, 1);
        String s = EvalContext.stringValue(this.eval(function.getArg1()));
        char[] chars = s.toCharArray();
        int out = 0;
        int phase = 0;
        int in = 0;
        while (in < chars.length) {
            switch (chars[in]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (phase == 0 || phase != 1) break;
                    phase = 2;
                    chars[out++] = 32;
                    break;
                }
                default: {
                    chars[out++] = chars[in];
                    phase = 1;
                }
            }
            ++in;
        }
        if (phase == 2) {
            --out;
        }
        return new String(chars, 0, out);
    }

    protected Object functionTranslate(CoreFunction function) {
        this.assertArgCount(function, 3);
        String s1 = EvalContext.stringValue(this.eval(function.getArg1()));
        String s2 = EvalContext.stringValue(this.eval(function.getArg2()));
        String s3 = EvalContext.stringValue(this.eval(function.getArg3()));
        char[] chars = s1.toCharArray();
        int out = 0;
        int in = 0;
        while (in < chars.length) {
            char c = chars[in];
            int inx = s2.indexOf(c);
            if (inx != -1) {
                if (inx < s3.length()) {
                    chars[out++] = s3.charAt(inx);
                }
            } else {
                chars[out++] = c;
            }
            ++in;
        }
        return new String(chars, 0, out);
    }

    protected Object functionBoolean(CoreFunction function) {
        this.assertArgCount(function, 1);
        return EvalContext.booleanValue(this.eval(function.getArg1())) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object functionNot(CoreFunction function) {
        this.assertArgCount(function, 1);
        return EvalContext.booleanValue(this.eval(function.getArg1())) ? Boolean.FALSE : Boolean.TRUE;
    }

    protected Object functionTrue(CoreFunction function) {
        this.assertArgCount(function, 0);
        return Boolean.TRUE;
    }

    protected Object functionFalse(CoreFunction function) {
        this.assertArgCount(function, 0);
        return Boolean.FALSE;
    }

    protected Object functionNull(CoreFunction function) {
        this.assertArgCount(function, 0);
        return new NullPointer(null, this.getRootContext().getCurrentNodePointer().getLocale());
    }

    protected Object functionNumber(CoreFunction function) {
        if (function.getArgumentCount() == 0) {
            return this.number(this.getCurrentNodePointer());
        }
        this.assertArgCount(function, 1);
        return this.number(this.eval(function.getArg1()));
    }

    /*
     * Unable to fully structure code
     */
    protected Object functionSum(CoreFunction function) {
        block3: {
            this.assertArgCount(function, 1);
            v = this.eval(function.getArg1(), false);
            if (v == null) {
                return EvalContext.ZERO;
            }
            if (!(v instanceof EvalContext)) break block3;
            sum = 0.0;
            ctx = (EvalContext)v;
            ** GOTO lbl12
            {
                sum += EvalContext.doubleValue(ctx.getCurrentNodePointer());
                do {
                    if (ctx.next()) continue block0;
lbl12:
                    // 2 sources

                } while (ctx.nextSet());
            }
            return new Double(sum);
        }
        throw new RuntimeException("Invalid argument type for 'sum': " + v.getClass().getName());
    }

    protected Object functionFloor(CoreFunction function) {
        this.assertArgCount(function, 1);
        double v = EvalContext.doubleValue(this.eval(function.getArg1()));
        return new Double(Math.floor(v));
    }

    protected Object functionCeiling(CoreFunction function) {
        this.assertArgCount(function, 1);
        double v = EvalContext.doubleValue(this.eval(function.getArg1()));
        return new Double(Math.ceil(v));
    }

    protected Object functionRound(CoreFunction function) {
        this.assertArgCount(function, 1);
        double v = EvalContext.doubleValue(this.eval(function.getArg1()));
        return new Double(Math.round(v));
    }

    private void assertArgCount(CoreFunction function, int count) {
        if (function.getArgumentCount() != count) {
            throw new RuntimeException("Incorrect number of argument: " + function);
        }
    }
}

