/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.PackageFunctions;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.functions.Types;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.Parser;
import org.apache.commons.jxpath.ri.axes.RootContext;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.compiler.TreeCompiler;
import org.apache.commons.jxpath.ri.pointers.NodePointer;
import org.apache.commons.jxpath.ri.pointers.VariablePointer;
import org.w3c.dom.Node;

public class JXPathContextReferenceImpl
extends JXPathContext {
    private static final Compiler compiler = new TreeCompiler();
    private static final Map compiled = new HashMap();
    private static final PackageFunctions genericFunctions = new PackageFunctions("", null);
    private static boolean useSoftCache = true;
    private static int cleanupCount = 0;
    private static final int CLEANUP_THRESHOLD = 500;

    protected JXPathContextReferenceImpl(JXPathContext parentContext, Object contextBean) {
        super(parentContext, contextBean);
    }

    private static Expression compile(String xpath) {
        Expression expr;
        if (useSoftCache) {
            expr = null;
            SoftReference ref = (SoftReference)compiled.get(xpath);
            if (ref != null) {
                expr = (Expression)ref.get();
            }
            if (expr == null) {
                expr = (Expression)Parser.parseExpression(xpath, compiler);
                expr.setEvaluationMode(0);
                compiled.put(xpath, new SoftReference<Expression>(expr));
                if (cleanupCount++ >= 500) {
                    JXPathContextReferenceImpl.cleanupCache();
                }
            }
        } else {
            expr = (Expression)compiled.get(xpath);
            if (expr == null) {
                expr = (Expression)Parser.parseExpression(xpath, compiler);
                expr.setEvaluationMode(0);
                compiled.put(xpath, expr);
            }
        }
        return expr;
    }

    private static void cleanupCache() {
        System.gc();
        Iterator it = compiled.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (((SoftReference)me.getValue()).get() != null) continue;
            it.remove();
        }
        cleanupCount = 0;
    }

    public Object getValue(String xpath) {
        Object result = this.eval(xpath, true);
        if (result == null && !this.lenient) {
            throw new RuntimeException("No value for xpath: " + xpath);
        }
        if (result instanceof EvalContext) {
            EvalContext ctx = (EvalContext)result;
            result = ctx.getContextNodePointer();
        }
        if (result instanceof Pointer) {
            result = ((Pointer)result).getValue();
        }
        if (result instanceof Node) {
            result = EvalContext.stringValue((Node)result);
        }
        return result;
    }

    public Object getValue(String xpath, Class requiredType) {
        Object value = this.getValue(xpath);
        if (value != null && requiredType != null) {
            if (!Types.canConvert(value, requiredType)) {
                throw new RuntimeException("Invalid expression type. '" + xpath + "' returns " + value.getClass().getName() + ". It cannot be converted to " + requiredType.getName());
            }
            value = Types.convert(value, requiredType);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public List eval(String xpath) {
        block5: {
            block4: {
                result = this.eval(xpath, false);
                list = new ArrayList<Object>();
                if (!(result instanceof EvalContext)) break block4;
                context = (EvalContext)result;
                ** GOTO lbl11
                {
                    pointer = context.getCurrentNodePointer();
                    list.add(pointer.getValue());
                    do {
                        if (context.next()) continue block0;
lbl11:
                        // 2 sources

                    } while (context.nextSet());
                }
                break block5;
            }
            if (result instanceof Pointer) {
                list.add(((Pointer)result).getValue());
            } else {
                list.add(result);
            }
        }
        return list;
    }

    public Pointer locateValue(String xpath) {
        Object result = this.eval(xpath, true);
        if (result instanceof EvalContext) {
            result = ((EvalContext)result).getContextNodePointer();
        }
        if (result instanceof Pointer) {
            return (Pointer)result;
        }
        return NodePointer.createNodePointer(null, result, this.getLocale());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String xpath, Object value) {
        Object result = this.eval(xpath, true);
        if (result instanceof Pointer) {
            ((Pointer)result).setValue(value);
            return;
        } else {
            if (!(result instanceof EvalContext)) throw new RuntimeException("Cannot set value for xpath: " + xpath);
            EvalContext ctx = (EvalContext)result;
            Pointer ptr = ctx.getContextNodePointer();
            if (ptr == null) throw new RuntimeException("Cannot set value for xpath: " + xpath + ": no such property");
            ptr.setValue(value);
        }
    }

    /*
     * Unable to fully structure code
     */
    public List locate(String xpath) {
        block5: {
            block4: {
                result = this.eval(xpath, false);
                list = new ArrayList<Pointer>();
                if (!(result instanceof EvalContext)) break block4;
                context = (EvalContext)result;
                ** GOTO lbl11
                {
                    pointer = context.getCurrentNodePointer();
                    list.add(pointer);
                    do {
                        if (context.next()) continue block0;
lbl11:
                        // 2 sources

                    } while (context.nextSet());
                }
                break block5;
            }
            if (result instanceof Pointer) {
                list.add((Pointer)result);
            } else {
                list.add(NodePointer.createNodePointer(null, result, this.getLocale()));
            }
        }
        return list;
    }

    private Object eval(String xpath, boolean firstMatchLookup) {
        Expression expr = JXPathContextReferenceImpl.compile(xpath);
        NodePointer pointer = NodePointer.createNodePointer(new QName(null, "root"), this.getContextBean(), this.getLocale());
        RootContext ctx = new RootContext(this, pointer);
        return ctx.eval(expr, firstMatchLookup);
    }

    private List resolveNodeSet(List list) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            Object element = list.get(i);
            if (element instanceof NodePointer) {
                element = ((NodePointer)element).getValue();
            }
            result.add(element);
            ++i;
        }
        return result;
    }

    public NodePointer getVariablePointer(QName name) {
        String varName = name.toString();
        JXPathContext varCtx = this;
        Variables vars = null;
        while (varCtx != null) {
            vars = varCtx.getVariables();
            if (vars.isDeclaredVariable(varName)) break;
            varCtx = varCtx.getParentContext();
            vars = null;
        }
        if (vars != null) {
            return new VariablePointer(vars, name);
        }
        throw new RuntimeException("Undefined variable: " + varName);
    }

    public Function getFunction(QName functionName, Object[] parameters) {
        String namespace = functionName.getPrefix();
        String name = functionName.getName();
        JXPathContext funcCtx = this;
        Function func = null;
        while (funcCtx != null) {
            Functions funcs = funcCtx.getFunctions();
            if (funcs == null) break;
            func = funcs.getFunction(namespace, name, parameters);
            if (func != null) {
                return func;
            }
            funcCtx = funcCtx.getParentContext();
        }
        if ((func = genericFunctions.getFunction(namespace, name, parameters)) != null) {
            return func;
        }
        throw new RuntimeException("Undefined function: " + functionName.toString());
    }
}

