/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.HashSet;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.pointers.NodePointer;

public class AncestorContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private NodePointer currentNodePointer;
    private boolean includeSelf;
    private HashSet visitedNodes = new HashSet();

    public AncestorContext(EvalContext parentContext, boolean includeSelf, NodeTest nodeTest) {
        super(parentContext);
        this.includeSelf = includeSelf;
        this.nodeTest = nodeTest;
    }

    public NodePointer getCurrentNodePointer() {
        return this.currentNodePointer;
    }

    public boolean setPosition(int position) {
        if (position == 0 || position < this.getCurrentPosition()) {
            this.setStarted = false;
        }
        while (this.getCurrentPosition() < position) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    public boolean next() {
        while (this.nextIgnoreDuplicates()) {
            NodePointer location = this.getCurrentNodePointer();
            if (this.visitedNodes.contains(location)) continue;
            this.visitedNodes.add(location.clone());
            ++this.position;
            return true;
        }
        return false;
    }

    private boolean nextIgnoreDuplicates() {
        if (!this.setStarted) {
            this.setStarted = true;
            this.currentNodePointer = this.parentContext.getCurrentNodePointer();
            if (this.includeSelf && this.currentNodePointer.testNode(this.nodeTest)) {
                return true;
            }
        }
        this.currentNodePointer = this.currentNodePointer.getParent();
        return this.currentNodePointer != null && this.currentNodePointer.testNode(this.nodeTest);
    }
}

