/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.pointers.NodeIterator;
import org.apache.commons.jxpath.ri.pointers.NodePointer;

public class ChildContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean startFromParentLocation;
    private boolean reverse;
    private NodeIterator iterator;

    public ChildContext(EvalContext parentContext, NodeTest nodeTest, boolean startFromParentLocation, boolean reverse) {
        super(parentContext);
        this.nodeTest = nodeTest;
        this.startFromParentLocation = startFromParentLocation;
        this.reverse = reverse;
    }

    public NodePointer getCurrentNodePointer() {
        if (this.iterator != null) {
            return this.iterator.getNodePointer();
        }
        return null;
    }

    public Pointer getContextNodePointer() {
        if (this.position == 0) {
            while (this.nextSet()) {
                this.prepare();
                if (this.iterator == null) {
                    return null;
                }
                if (this.iterator.getNodePointer() != null) break;
            }
        }
        return this.getCurrentNodePointer();
    }

    public boolean next() {
        return this.setPosition(this.getCurrentPosition() + 1);
    }

    public boolean setPosition(int position) {
        int oldPosition = this.getCurrentPosition();
        super.setPosition(position);
        if (position == 0) {
            this.iterator = null;
            return true;
        }
        if (oldPosition == 0) {
            this.prepare();
        }
        if (this.iterator == null) {
            return false;
        }
        return this.iterator.setPosition(position);
    }

    private void prepare() {
        NodePointer parent = this.parentContext.getCurrentNodePointer();
        this.iterator = this.startFromParentLocation ? parent.siblingIterator(this.nodeTest, this.reverse) : parent.childIterator(this.nodeTest, this.reverse);
    }
}

