/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.HashSet;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.pointers.NodePointer;

public class ParentContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private NodePointer currentNodePointer;
    private HashSet visitedNodes = new HashSet();

    public ParentContext(EvalContext parentContext, NodeTest nodeTest) {
        super(parentContext);
        this.nodeTest = nodeTest;
    }

    public NodePointer getCurrentNodePointer() {
        return this.currentNodePointer;
    }

    public int getCurrentPosition() {
        return 1;
    }

    public boolean setPosition(int position) {
        super.setPosition(position);
        if (position == 0) {
            this.setStarted = false;
        }
        return position == 1;
    }

    public boolean next() {
        while (this.nextIgnoreDuplicates()) {
            NodePointer location = this.getCurrentNodePointer();
            if (this.visitedNodes.contains(location)) continue;
            this.visitedNodes.add(location.clone());
            ++this.position;
            return true;
        }
        return false;
    }

    private boolean nextIgnoreDuplicates() {
        if (this.setStarted) {
            return false;
        }
        this.setStarted = true;
        NodePointer thisLocation = this.parentContext.getCurrentNodePointer();
        this.currentNodePointer = thisLocation.getParent();
        return this.currentNodePointer != null && this.currentNodePointer.testNode(this.nodeTest);
    }
}

