/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.compiler.QName;
import org.apache.commons.jxpath.ri.pointers.NodePointer;

public class RootContext
extends EvalContext {
    private boolean startedSet = false;
    private boolean started = false;
    private JXPathContextReferenceImpl parent;
    private NodePointer pointer;
    private Object[] registers;
    private int availableRegister = 0;
    public static final Object UNKNOWN_VALUE = new Object();
    private static final int MAX_REGISTER = 4;

    public RootContext(JXPathContextReferenceImpl parent, NodePointer pointer) {
        super(null);
        this.parent = parent;
        this.pointer = pointer;
    }

    public RootContext getRootContext() {
        return this;
    }

    public NodePointer getCurrentNodePointer() {
        return this.pointer;
    }

    public int getCurrentPosition() {
        return 1;
    }

    public boolean next() {
        if (this.started) {
            return false;
        }
        this.started = true;
        return true;
    }

    public boolean nextSet() {
        if (this.startedSet) {
            return false;
        }
        this.startedSet = true;
        return true;
    }

    public boolean setPosition(int position) {
        return position == 1;
    }

    public EvalContext getConstantContext(Object constant) {
        NodePointer pointer = NodePointer.createNodePointer(new QName(null, ""), constant, null);
        return new InitialContext(new RootContext(this.parent, pointer));
    }

    public EvalContext getVariableContext(QName variableName) {
        return new InitialContext(new RootContext(this.parent, this.parent.getVariablePointer(variableName)));
    }

    public Function getFunction(QName functionName, Object[] parameters) {
        return this.parent.getFunction(functionName, parameters);
    }

    public Object getRegisteredValue(int id) {
        if (this.registers == null || id >= 4 || id == -1) {
            return UNKNOWN_VALUE;
        }
        return this.registers[id];
    }

    public int setRegisteredValue(Object value) {
        if (this.registers == null) {
            this.registers = new Object[4];
            int i = 0;
            while (i < 4) {
                this.registers[i] = UNKNOWN_VALUE;
                ++i;
            }
        }
        if (this.availableRegister >= 4) {
            return -1;
        }
        this.registers[this.availableRegister] = value;
        ++this.availableRegister;
        return this.availableRegister - 1;
    }

    public String toString() {
        return super.toString() + ":" + this.pointer.asPath();
    }
}

