/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Operation;

public class CoreFunction
extends Operation {
    private int functionCode;

    public CoreFunction(int functionCode, Expression[] args) {
        super(22, args);
        this.functionCode = functionCode;
    }

    public int getFunctionCode() {
        return this.functionCode;
    }

    public Expression getArg1() {
        return this.args[0];
    }

    public Expression getArg2() {
        return this.args[1];
    }

    public Expression getArg3() {
        return this.args[2];
    }

    public int getArgumentCount() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    public boolean computeContextDependent() {
        if (super.computeContextDependent()) {
            return true;
        }
        switch (this.functionCode) {
            case 1: 
            case 2: {
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 22: 
            case 23: {
                return this.args.length == 0;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return false;
            }
        }
        return false;
    }

    protected String opCodeToString() {
        String function = null;
        switch (this.functionCode) {
            case 1: {
                function = "last";
                break;
            }
            case 2: {
                function = "position";
                break;
            }
            case 3: {
                function = "count";
                break;
            }
            case 4: {
                function = "id";
                break;
            }
            case 5: {
                function = "local-name";
                break;
            }
            case 6: {
                function = "namespace-uri";
                break;
            }
            case 7: {
                function = "name";
                break;
            }
            case 8: {
                function = "string";
                break;
            }
            case 9: {
                function = "concat";
                break;
            }
            case 10: {
                function = "starts-with";
                break;
            }
            case 11: {
                function = "contains";
                break;
            }
            case 12: {
                function = "substring-before";
                break;
            }
            case 13: {
                function = "substring-after";
                break;
            }
            case 14: {
                function = "substring";
                break;
            }
            case 15: {
                function = "string-length";
                break;
            }
            case 16: {
                function = "normalize-space";
                break;
            }
            case 17: {
                function = "translate";
                break;
            }
            case 18: {
                function = "boolean";
                break;
            }
            case 19: {
                function = "not";
                break;
            }
            case 20: {
                function = "true";
                break;
            }
            case 21: {
                function = "false";
                break;
            }
            case 22: {
                function = "lang";
                break;
            }
            case 23: {
                function = "number";
                break;
            }
            case 24: {
                function = "sum";
                break;
            }
            case 25: {
                function = "floor";
                break;
            }
            case 26: {
                function = "ceiling";
                break;
            }
            case 27: {
                function = "round";
            }
        }
        return super.opCodeToString() + ':' + function;
    }
}

