/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

public abstract class Expression {
    public static final int OP_SUM = 1;
    public static final int OP_MINUS = 2;
    public static final int OP_MULT = 3;
    public static final int OP_DIV = 4;
    public static final int OP_CONSTANT = 5;
    public static final int OP_STEP = 6;
    public static final int OP_AND = 7;
    public static final int OP_OR = 8;
    public static final int OP_UNARY_MINUS = 9;
    public static final int OP_MOD = 10;
    public static final int OP_LT = 11;
    public static final int OP_GT = 12;
    public static final int OP_LTE = 13;
    public static final int OP_GTE = 14;
    public static final int OP_EQ = 15;
    public static final int OP_NE = 16;
    public static final int OP_VAR = 17;
    public static final int OP_FUNCTION = 18;
    public static final int OP_UNION = 19;
    public static final int OP_LOCATION_PATH = 20;
    public static final int OP_EXPRESSION_PATH = 21;
    public static final int OP_CORE_FUNCTION = 22;
    private int typeCode;
    private boolean contextDependencyKnown = false;
    private boolean contextDependent;
    public static final int EVALUATION_MODE_ONCE = 0;
    public static final int EVALUATION_MODE_ONCE_AND_SAVE = 1;
    public static final int EVALUATION_MODE_ALWAYS = 2;
    private int evaluationMode;
    private int id = -1;

    protected Expression(int typeCode) {
        this.typeCode = typeCode;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int getExpressionTypeCode() {
        return this.typeCode;
    }

    protected Expression[] getArguments() {
        return null;
    }

    public boolean isContextDependent() {
        if (!this.contextDependencyKnown) {
            this.contextDependent = this.computeContextDependent();
            this.contextDependencyKnown = true;
        }
        return this.contextDependent;
    }

    public abstract boolean computeContextDependent();

    public void setEvaluationMode(int mode) {
        this.evaluationMode = mode;
    }

    public int getEvaluationMode() {
        return this.evaluationMode;
    }

    public Object getEvaluationHint(String hint) {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this.opCodeToString());
        Expression[] args = this.getArguments();
        if (args != null) {
            buffer.append(' ');
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String opCodeToString() {
        switch (this.typeCode) {
            case 5: {
                return "CONST";
            }
            case 6: {
                return "STEP";
            }
            case 1: {
                return "SUM";
            }
            case 19: {
                return "UNION";
            }
            case 2: {
                return "MINUS";
            }
            case 9: {
                return "UNARY_MINUS";
            }
            case 3: {
                return "MULT";
            }
            case 4: {
                return "DIV";
            }
            case 10: {
                return "MOD";
            }
            case 7: {
                return "AND";
            }
            case 8: {
                return "OR";
            }
            case 11: {
                return "LT";
            }
            case 12: {
                return "GT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "GTE";
            }
            case 15: {
                return "EQ";
            }
            case 16: {
                return "NE";
            }
            case 17: {
                return "VAR";
            }
            case 18: {
                return "FUNCTION";
            }
            case 20: {
                return "LOCATION_PATH";
            }
            case 21: {
                return "EXPRESSION_PATH";
            }
            case 22: {
                return "CORE_FUNCTION";
            }
        }
        return "UNKNOWN";
    }
}

