/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.Step;

public class ExpressionPath
extends Path {
    private Expression expression;
    private Expression[] predicates;

    public ExpressionPath(Expression expression, Expression[] predicates, Step[] steps) {
        super(21, steps);
        this.expression = expression;
        this.predicates = predicates;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression[] getPredicates() {
        return this.predicates;
    }

    public boolean computeContextDependent() {
        if (this.expression.isContextDependent()) {
            return true;
        }
        if (this.predicates != null) {
            int i = 0;
            while (i < this.predicates.length) {
                if (this.predicates[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return super.computeContextDependent();
    }

    public void setEvaluationMode(int mode) {
        super.setEvaluationMode(mode);
        switch (mode) {
            case 2: {
                if (this.expression.isContextDependent()) {
                    this.expression.setEvaluationMode(2);
                    break;
                }
                this.expression.setEvaluationMode(1);
                break;
            }
            case 0: 
            case 1: {
                this.expression.setEvaluationMode(0);
            }
        }
        if (this.predicates != null) {
            int i = 0;
            while (i < this.predicates.length) {
                switch (mode) {
                    case 2: {
                        if (this.predicates[i].isContextDependent()) {
                            this.predicates[i].setEvaluationMode(2);
                            break;
                        }
                        this.predicates[i].setEvaluationMode(1);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.predicates[i].setEvaluationMode(0);
                    }
                }
                ++i;
            }
        }
    }

    public String toString() {
        Step[] steps;
        StringBuffer buffer = new StringBuffer();
        buffer.append("(EXPRESSION-PATH ");
        buffer.append(this.expression);
        if (this.predicates != null) {
            buffer.append(' ');
            int i = 0;
            while (i < this.predicates.length) {
                buffer.append('[');
                buffer.append(this.predicates[i]);
                buffer.append(']');
                ++i;
            }
        }
        if ((steps = this.getSteps()) != null) {
            buffer.append(' ');
            int i = 0;
            while (i < steps.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(steps[i]);
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

