/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.Path;
import org.apache.commons.jxpath.ri.compiler.Step;

public class LocationPath
extends Path {
    private boolean absolute;
    public static final String BASIC_PATH_HINT = "basicPathHint";
    private boolean basicKnown = false;
    private boolean basic;

    public LocationPath(boolean absolute, Step[] steps) {
        super(20, steps);
        this.absolute = absolute;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean computeContextDependent() {
        if (!this.absolute) {
            return true;
        }
        return super.computeContextDependent();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(PATH");
        if (this.absolute) {
            buffer.append("[absolute] ");
        } else {
            buffer.append("[relative] ");
        }
        Step[] args = this.getSteps();
        if (args != null) {
            buffer.append(' ');
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(args[i]);
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object getEvaluationHint(String hint) {
        if (!hint.equals(BASIC_PATH_HINT)) {
            return null;
        }
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = true;
            Step[] steps = this.getSteps();
            int i = 0;
            while (i < steps.length) {
                if (steps[i].getAxis() != 2 || !(steps[i].getNodeTest() instanceof NodeNameTest) || ((NodeNameTest)steps[i].getNodeTest()).getNodeName().getName().equals("*")) {
                    this.basic = false;
                    break;
                }
                Expression[] predicates = steps[i].getPredicates();
                if (predicates != null && predicates.length != 0) {
                    if (predicates.length != 1) {
                        this.basic = false;
                        break;
                    }
                    if (predicates[0].getEvaluationHint("dynamicPropertyAccessHint") == null && predicates[0].isContextDependent()) {
                        this.basic = false;
                        break;
                    }
                }
                ++i;
            }
        }
        return this.basic ? Boolean.TRUE : Boolean.FALSE;
    }
}

