/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;

public class Operation
extends Expression {
    protected Expression[] args;

    public Operation(int code, Expression[] args) {
        super(code);
        this.args = args;
    }

    public Expression[] getArguments() {
        return this.args;
    }

    public boolean computeContextDependent() {
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                if (this.args[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setEvaluationMode(int mode) {
        super.setEvaluationMode(mode);
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                switch (mode) {
                    case 2: {
                        if (this.args[i].isContextDependent()) {
                            this.args[i].setEvaluationMode(2);
                            break;
                        }
                        this.args[i].setEvaluationMode(1);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.args[i].setEvaluationMode(0);
                    }
                }
                ++i;
            }
        }
    }
}

