/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.Step;

public class Path
extends Expression {
    private Step[] steps;

    public Path(int typeCode, Step[] steps) {
        super(typeCode);
        this.steps = steps;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public boolean computeContextDependent() {
        if (this.steps != null) {
            int i = 0;
            while (i < this.steps.length) {
                if (this.steps[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setEvaluationMode(int mode) {
        super.setEvaluationMode(mode);
        if (this.steps != null) {
            int i = 0;
            while (i < this.steps.length) {
                if (this.steps[i].isContextDependent()) {
                    this.steps[i].setEvaluationMode(2);
                } else {
                    switch (mode) {
                        case 1: 
                        case 2: {
                            this.steps[i].setEvaluationMode(1);
                            break;
                        }
                        case 0: {
                            this.steps[i].setEvaluationMode(0);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

