/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NodeTest;

public class Step {
    private int axis;
    private NodeTest nodeTest;
    private Expression[] predicates;

    protected Step(int axis, NodeTest nodeTest, Expression[] predicates) {
        this.axis = axis;
        this.nodeTest = nodeTest;
        this.predicates = predicates;
    }

    public int getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    public Expression[] getPredicates() {
        return this.predicates;
    }

    public boolean isContextDependent() {
        if (this.predicates != null) {
            int i = 0;
            while (i < this.predicates.length) {
                if (this.predicates[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setEvaluationMode(int mode) {
        if (this.predicates != null) {
            int i = 0;
            while (i < this.predicates.length) {
                switch (mode) {
                    case 2: {
                        if (this.predicates[i].isContextDependent()) {
                            this.predicates[i].setEvaluationMode(2);
                            break;
                        }
                        this.predicates[i].setEvaluationMode(1);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.predicates[i].setEvaluationMode(0);
                    }
                }
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Step.axisToString(this.getAxis()));
        buffer.append("::");
        buffer.append(this.nodeTest);
        Expression[] predicates = this.getPredicates();
        if (predicates != null) {
            int i = 0;
            while (i < predicates.length) {
                buffer.append('[');
                buffer.append(predicates[i]);
                buffer.append(']');
                ++i;
            }
        }
        return buffer.toString();
    }

    public static String axisToString(int axis) {
        switch (axis) {
            case 1: {
                return "self";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "parent";
            }
            case 4: {
                return "ancestor";
            }
            case 5: {
                return "attribute";
            }
            case 6: {
                return "namespace";
            }
            case 7: {
                return "preceding";
            }
            case 8: {
                return "following";
            }
            case 9: {
                return "descendant";
            }
            case 10: {
                return "ancestor-or-self";
            }
            case 11: {
                return "following-sibling";
            }
            case 12: {
                return "preceding-sibling";
            }
            case 13: {
                return "descendant-or-self";
            }
        }
        return "UNKNOWN";
    }
}

